/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.indices.stats;

import io.lucenia.action.support.broadcast.node.TransportBroadcastByNodeAction;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.indices.stats.CommonStats;
import io.skylite.core.action.admin.indices.stats.CommonStatsFlags;
import io.skylite.core.action.admin.indices.stats.IndicesStatsAction;
import io.skylite.core.action.admin.indices.stats.IndicesStatsRequest;
import io.skylite.core.action.admin.indices.stats.IndicesStatsResponse;
import io.skylite.core.action.admin.indices.stats.ShardStats;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.DefaultShardOperationFailedException;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.routing.ShardsIterator;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.index.engine.CommitStats;
import io.skylite.core.index.seqno.RetentionLeaseStats;
import io.skylite.core.index.seqno.SeqNoStats;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.index.shard.ShardNotFoundException;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.List;
import org.apache.lucene.store.AlreadyClosedException;
import org.opensearch.index.IndexService;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.IndicesQueryCache;
import org.opensearch.indices.IndicesService;

public class TransportIndicesStatsAction
extends TransportBroadcastByNodeAction<IndicesStatsRequest, IndicesStatsResponse, ShardStats> {
    private final IndicesService indicesService;

    @Inject
    public TransportIndicesStatsAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:monitor/stats", clusterService, transportService, actionFilters, indexNameExpressionResolver, IndicesStatsRequest::new, "management");
        this.indicesService = indicesService;
    }

    @Override
    protected ShardsIterator shards(ClusterState clusterState, IndicesStatsRequest request, String[] concreteIndices) {
        return clusterState.routingTable().allShards(concreteIndices);
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, IndicesStatsRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, IndicesStatsRequest request, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, concreteIndices);
    }

    @Override
    protected ShardStats readShardResult(StreamInput in) throws IOException {
        return new ShardStats(in);
    }

    @Override
    protected IndicesStatsResponse newResponse(IndicesStatsRequest request, int totalShards, int successfulShards, int failedShards, List<ShardStats> responses, List<DefaultShardOperationFailedException> shardFailures, ClusterState clusterState) {
        return new IndicesStatsResponse(responses.toArray(new ShardStats[0]), totalShards, successfulShards, failedShards, shardFailures);
    }

    @Override
    protected IndicesStatsRequest readRequestFrom(StreamInput in) throws IOException {
        return new IndicesStatsRequest(in);
    }

    @Override
    protected ShardStats shardOperation(IndicesStatsRequest request, ShardRouting shardRouting) {
        RetentionLeaseStats retentionLeaseStats;
        SeqNoStats seqNoStats;
        CommitStats commitStats;
        IndexService indexService = this.indicesService.indexServiceSafe(shardRouting.shardId().getIndex());
        IndexShard indexShard = indexService.getShard(shardRouting.shardId().id());
        ShardId shardId = indexShard.shardId();
        if (indexShard.routingEntry() == null) {
            throw new ShardNotFoundException(shardId);
        }
        CommonStatsFlags flags = request.flags();
        IndicesQueryCache indicesQueryCache = this.indicesService.getIndicesQueryCache();
        CommonStats commonStats = new CommonStats(flags, indexShard.docStats(), indexShard.storeStats(), indexShard.indexingStats(), indexShard.getStats(), indexShard.searchStats(flags.groups()), indexShard.mergeStats(), indexShard.refreshStats(), indexShard.flushStats(), indexShard.warmerStats(), indicesQueryCache.getStats(shardId), indexShard.fieldDataStats(flags.fieldDataFields()), indexShard.completionStats(flags.completionDataFields()), indexShard.segmentStats(flags.includeSegmentFileSizes(), flags.includeUnloadedSegments()), indexShard.translogStats(), indexShard.requestCache().stats(), indexShard.recoveryStats());
        try {
            commitStats = indexShard.commitStats();
            seqNoStats = indexShard.seqNoStats();
            retentionLeaseStats = indexShard.getRetentionLeaseStats();
        }
        catch (AlreadyClosedException e) {
            commitStats = null;
            seqNoStats = null;
            retentionLeaseStats = null;
        }
        return new ShardStats(indexShard.routingEntry(), indexShard.shardPath(), commonStats, commitStats, seqNoStats, retentionLeaseStats);
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return IndicesStatsAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportIndicesStatsAction.class;
        }
    }
}

