/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.indices.template.get;

import io.skylite.ResourceNotFoundException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.indices.template.get.GetComponentTemplateAction;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeReadAction;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.ComponentTemplate;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.regex.Regex;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class TransportGetComponentTemplateAction
extends TransportClusterManagerNodeReadAction<GetComponentTemplateAction.Request, GetComponentTemplateAction.Response> {
    @Inject
    public TransportGetComponentTemplateAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/component_template/get", transportService, clusterService, threadPool, actionFilters, GetComponentTemplateAction.Request::new, indexNameExpressionResolver);
    }

    protected String executor() {
        return "same";
    }

    protected GetComponentTemplateAction.Response read(StreamInput in) throws IOException {
        return new GetComponentTemplateAction.Response(in);
    }

    protected ClusterBlockException checkBlock(GetComponentTemplateAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    protected void clusterManagerOperation(GetComponentTemplateAction.Request request, ClusterState state, ActionListener<GetComponentTemplateAction.Response> listener) {
        Map allTemplates = state.metadata().componentTemplates();
        if (request.name() == null) {
            listener.onResponse((Object)new GetComponentTemplateAction.Response(allTemplates));
            return;
        }
        HashMap<String, ComponentTemplate> results = new HashMap<String, ComponentTemplate>();
        String name = request.name();
        if (Regex.isSimpleMatchPattern((String)name)) {
            for (Map.Entry entry : allTemplates.entrySet()) {
                if (!Regex.simpleMatch((String)name, (String)((String)entry.getKey()))) continue;
                results.put((String)entry.getKey(), (ComponentTemplate)entry.getValue());
            }
        } else if (allTemplates.containsKey(name)) {
            results.put(name, (ComponentTemplate)allTemplates.get(name));
        } else {
            throw new ResourceNotFoundException("component template matching [" + request.name() + "] not found", new Object[0]);
        }
        listener.onResponse((Object)new GetComponentTemplateAction.Response(results));
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return GetComponentTemplateAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportGetComponentTemplateAction.class;
        }
    }
}

