/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.indices.template.post;

import io.skylite.common.Nullable;
import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.core.action.admin.indices.template.put.PutComposableIndexTemplateAction;
import io.skylite.core.action.clustermanager.ClusterManagerNodeReadRequest;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import java.io.IOException;
import java.util.Objects;

public class SimulateIndexTemplateRequest
extends ClusterManagerNodeReadRequest<SimulateIndexTemplateRequest> {
    private String indexName;
    @Nullable
    private PutComposableIndexTemplateAction.Request indexTemplateRequest;

    public SimulateIndexTemplateRequest(String indexName) {
        if (Strings.isNullOrEmpty((String)indexName)) {
            throw new IllegalArgumentException("index name cannot be null or empty");
        }
        this.indexName = indexName;
    }

    public SimulateIndexTemplateRequest(StreamInput in) throws IOException {
        super(in);
        this.indexName = in.readString();
        this.indexTemplateRequest = (PutComposableIndexTemplateAction.Request)in.readOptionalWriteable(PutComposableIndexTemplateAction.Request::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.indexName);
        out.writeOptionalWriteable((Writeable)this.indexTemplateRequest);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.indexTemplateRequest != null) {
            validationException = this.indexTemplateRequest.validateIndexTemplate(validationException);
        }
        return validationException;
    }

    public String getIndexName() {
        return this.indexName;
    }

    @Nullable
    public PutComposableIndexTemplateAction.Request getIndexTemplateRequest() {
        return this.indexTemplateRequest;
    }

    public SimulateIndexTemplateRequest indexName(String indexName) {
        this.indexName = indexName;
        return this;
    }

    public SimulateIndexTemplateRequest indexTemplateRequest(PutComposableIndexTemplateAction.Request indexTemplateRequest) {
        this.indexTemplateRequest = indexTemplateRequest;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SimulateIndexTemplateRequest that = (SimulateIndexTemplateRequest)((Object)o);
        return this.indexName.equals(that.indexName) && Objects.equals(this.indexTemplateRequest, that.indexTemplateRequest);
    }

    public int hashCode() {
        return Objects.hash(this.indexName, this.indexTemplateRequest);
    }
}

