/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.indices.template.post;

import io.skylite.common.Nullable;
import io.skylite.core.ParseField;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.cluster.metadata.Template;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SimulateIndexTemplateResponse
extends ActionResponse
implements ToXContentObject {
    private static final ParseField TEMPLATE = new ParseField("template", new String[0]);
    private static final ParseField OVERLAPPING = new ParseField("overlapping", new String[0]);
    private static final ParseField NAME = new ParseField("name", new String[0]);
    private static final ParseField INDEX_PATTERNS = new ParseField("index_patterns", new String[0]);
    @Nullable
    private Template resolvedTemplate;
    @Nullable
    private Map<String, List<String>> overlappingTemplates;

    public SimulateIndexTemplateResponse(@Nullable Template resolvedTemplate, @Nullable Map<String, List<String>> overlappingTemplates) {
        this.resolvedTemplate = resolvedTemplate;
        this.overlappingTemplates = overlappingTemplates;
    }

    public SimulateIndexTemplateResponse(StreamInput in) throws IOException {
        super(in);
        this.resolvedTemplate = (Template)in.readOptionalWriteable(Template::new);
        if (in.readBoolean()) {
            int overlappingTemplatesCount = in.readInt();
            this.overlappingTemplates = new HashMap<String, List<String>>(overlappingTemplatesCount, 1.0f);
            for (int i = 0; i < overlappingTemplatesCount; ++i) {
                String templateName = in.readString();
                this.overlappingTemplates.put(templateName, in.readStringList());
            }
        } else {
            this.overlappingTemplates = null;
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable((Writeable)this.resolvedTemplate);
        if (this.overlappingTemplates != null) {
            out.writeBoolean(true);
            out.writeInt(this.overlappingTemplates.size());
            for (Map.Entry<String, List<String>> entry : this.overlappingTemplates.entrySet()) {
                out.writeString(entry.getKey());
                out.writeStringCollection((Collection)entry.getValue());
            }
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.resolvedTemplate != null) {
            builder.field(TEMPLATE.getPreferredName(), (ToXContent)this.resolvedTemplate);
        }
        if (this.overlappingTemplates != null) {
            builder.startArray(OVERLAPPING.getPreferredName());
            for (Map.Entry<String, List<String>> entry : this.overlappingTemplates.entrySet()) {
                builder.startObject();
                builder.field(NAME.getPreferredName(), entry.getKey());
                builder.field(INDEX_PATTERNS.getPreferredName(), (Iterable)entry.getValue());
                builder.endObject();
            }
            builder.endArray();
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SimulateIndexTemplateResponse that = (SimulateIndexTemplateResponse)((Object)o);
        return Objects.equals(this.resolvedTemplate, that.resolvedTemplate) && Objects.deepEquals(this.overlappingTemplates, that.overlappingTemplates);
    }

    public int hashCode() {
        return Objects.hash(this.resolvedTemplate, this.overlappingTemplates);
    }

    public String toString() {
        return "SimulateIndexTemplateResponse{resolved template=" + String.valueOf(this.resolvedTemplate) + ", overlapping templates=" + String.join((CharSequence)"|", this.overlappingTemplates.keySet()) + "}";
    }
}

