/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.indices.validate.query;

import io.lucenia.action.support.broadcast.TransportBroadcastAction;
import io.skylite.SkyliteException;
import io.skylite.common.Randomness;
import io.skylite.common.action.ActionListener;
import io.skylite.common.lease.Releasable;
import io.skylite.common.lease.Releasables;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.indices.validate.QueryExplanation;
import io.skylite.core.action.admin.indices.validate.ShardValidateQueryRequest;
import io.skylite.core.action.admin.indices.validate.ShardValidateQueryResponse;
import io.skylite.core.action.admin.indices.validate.ValidateQueryAction;
import io.skylite.core.action.admin.indices.validate.ValidateQueryRequest;
import io.skylite.core.action.admin.indices.validate.ValidateQueryResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.DefaultShardOperationFailedException;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.broadcast.BroadcastShardOperationFailedException;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.routing.GroupShardsIterator;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.ParsingException;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.index.query.ParsedQuery;
import io.skylite.core.index.query.QueryRewriteContext;
import io.skylite.core.index.query.QueryShardException;
import io.skylite.core.index.query.Rewriteable;
import io.skylite.core.indices.IndexClosedException;
import io.skylite.core.search.internal.AliasFilter;
import io.skylite.core.search.internal.ShardSearchRequest;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.LongSupplier;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.opensearch.search.DefaultSearchContext;
import org.opensearch.search.SearchService;
import org.opensearch.search.internal.SearchContext;

public class TransportValidateQueryAction
extends TransportBroadcastAction<ValidateQueryRequest, ValidateQueryResponse, ShardValidateQueryRequest, ShardValidateQueryResponse> {
    private final SearchService searchService;

    @Inject
    public TransportValidateQueryAction(ClusterService clusterService, TransportService transportService, SearchService searchService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:admin/validate/query", clusterService, transportService, actionFilters, indexNameExpressionResolver, ValidateQueryRequest::new, ShardValidateQueryRequest::new, "search");
        this.searchService = searchService;
    }

    @Override
    protected void doExecute(Task task, ValidateQueryRequest request, ActionListener<ValidateQueryResponse> listener) {
        request.setNowInMillis(System.currentTimeMillis());
        LongSupplier timeProvider = () -> ((ValidateQueryRequest)request).nowInMillis();
        ActionListener rewriteListener = ActionListenerHelper.wrap(rewrittenQuery -> {
            request.query(rewrittenQuery);
            super.doExecute(task, request, listener);
        }, ex -> {
            if (ex instanceof IndexNotFoundException || ex instanceof IndexClosedException) {
                listener.onFailure(ex);
                return;
            }
            ArrayList<QueryExplanation> explanations = new ArrayList<QueryExplanation>();
            explanations.add(new QueryExplanation(null, -1, false, null, ex.getMessage()));
            listener.onResponse((Object)new ValidateQueryResponse(false, explanations, 0, 0, 0, null));
        });
        if (request.query() == null) {
            rewriteListener.onResponse((Object)request.query());
        } else {
            Rewriteable.rewriteAndFetch((Rewriteable)request.query(), (QueryRewriteContext)this.searchService.getValidationRewriteContext(timeProvider), (ActionListener)rewriteListener);
        }
    }

    @Override
    protected ShardValidateQueryRequest newShardRequest(int numShards, ShardRouting shard, ValidateQueryRequest request) {
        ClusterState clusterState = this.clusterService.state();
        Set indicesAndAliases = this.indexNameExpressionResolver.resolveExpressions(clusterState, request.indices());
        AliasFilter aliasFilter = this.searchService.buildAliasFilter(clusterState, shard.getIndexName(), indicesAndAliases);
        return new ShardValidateQueryRequest(shard.shardId(), aliasFilter, request);
    }

    @Override
    protected ShardValidateQueryResponse readShardResponse(StreamInput in) throws IOException {
        return new ShardValidateQueryResponse(in);
    }

    @Override
    protected GroupShardsIterator shards(ClusterState clusterState, ValidateQueryRequest request, String[] concreteIndices) {
        String routing = request.allShards() ? null : Integer.toString(Randomness.get().nextInt(1000));
        Map routingMap = this.indexNameExpressionResolver.resolveSearchRouting(clusterState, routing, request.indices());
        return this.clusterService.operationRouting().searchShards(clusterState, concreteIndices, routingMap, "_local");
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, ValidateQueryRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.READ);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, ValidateQueryRequest countRequest, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.READ, concreteIndices);
    }

    @Override
    protected ValidateQueryResponse newResponse(ValidateQueryRequest request, AtomicReferenceArray shardsResponses, ClusterState clusterState) {
        int successfulShards = 0;
        int failedShards = 0;
        boolean valid = true;
        ArrayList<DefaultShardOperationFailedException> shardFailures = null;
        ArrayList<QueryExplanation> queryExplanations = null;
        for (int i = 0; i < shardsResponses.length(); ++i) {
            Object shardResponse = shardsResponses.get(i);
            if (shardResponse == null) continue;
            if (shardResponse instanceof BroadcastShardOperationFailedException) {
                ++failedShards;
                if (shardFailures == null) {
                    shardFailures = new ArrayList<DefaultShardOperationFailedException>();
                }
                shardFailures.add(new DefaultShardOperationFailedException((SkyliteException)((BroadcastShardOperationFailedException)shardResponse)));
                continue;
            }
            ShardValidateQueryResponse validateQueryResponse = (ShardValidateQueryResponse)shardResponse;
            boolean bl = valid = valid && validateQueryResponse.isValid();
            if (request.explain() || request.rewrite() || request.allShards()) {
                if (queryExplanations == null) {
                    queryExplanations = new ArrayList<QueryExplanation>();
                }
                queryExplanations.add(new QueryExplanation(validateQueryResponse.getIndex(), request.allShards() ? validateQueryResponse.getShardId().getId() : -1, validateQueryResponse.isValid(), validateQueryResponse.getExplanation(), validateQueryResponse.getError()));
            }
            ++successfulShards;
        }
        return new ValidateQueryResponse(valid, queryExplanations, shardsResponses.length(), successfulShards, failedShards, shardFailures);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ShardValidateQueryResponse shardOperation(ShardValidateQueryRequest request, Task task) throws IOException {
        boolean valid;
        String explanation = null;
        String error = null;
        ShardSearchRequest shardSearchLocalRequest = new ShardSearchRequest(request.shardId(), request.nowInMillis(), request.filteringAliases());
        DefaultSearchContext searchContext = this.searchService.createValidationContext(shardSearchLocalRequest, TimeValue.NO_TIMEOUT);
        try {
            ParsedQuery parsedQuery = searchContext.getQueryShardContext().toQuery(request.query());
            ((SearchContext)searchContext).parsedQuery(parsedQuery);
            searchContext.preProcess(request.rewrite());
            valid = true;
            explanation = this.explain(searchContext, request.rewrite());
        }
        catch (ParsingException | QueryShardException e) {
            valid = false;
            error = e.getDetailedMessage();
        }
        catch (AssertionError e) {
            valid = false;
            error = ((Throwable)((Object)e)).getMessage();
        }
        finally {
            Releasables.close((Releasable)searchContext);
        }
        return new ShardValidateQueryResponse(request.shardId(), valid, explanation, error);
    }

    private String explain(SearchContext context, boolean rewritten) {
        Query query = context.query();
        if (rewritten && query instanceof MatchNoDocsQuery) {
            return context.parsedQuery().query().toString();
        }
        return query.toString();
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return ValidateQueryAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportValidateQueryAction.class;
        }
    }
}

