/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.bulk;

import io.lucenia.action.bulk.BulkProcessor;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.bulk.BackoffPolicy;
import io.skylite.core.action.bulk.BulkRequest;
import io.skylite.core.action.bulk.BulkResponse;
import io.skylite.core.action.bulk.Retry;
import io.skylite.core.threadpool.Scheduler;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;

public final class BulkRequestHandler {
    private final Logger logger;
    private final BiConsumer<BulkRequest, ActionListener<BulkResponse>> consumer;
    private final BulkProcessor.Listener listener;
    private final Semaphore semaphore;
    private final Retry retry;
    private final int concurrentRequests;

    BulkRequestHandler(BiConsumer<BulkRequest, ActionListener<BulkResponse>> consumer, BackoffPolicy backoffPolicy, BulkProcessor.Listener listener, Scheduler scheduler, int concurrentRequests) {
        assert (concurrentRequests >= 0);
        this.logger = LogManager.getLogger(this.getClass());
        this.consumer = consumer;
        this.listener = listener;
        this.concurrentRequests = concurrentRequests;
        this.retry = new Retry(backoffPolicy, scheduler);
        this.semaphore = new Semaphore(concurrentRequests > 0 ? concurrentRequests : 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(final BulkRequest bulkRequest, final long executionId) {
        Runnable toRelease = () -> {};
        boolean bulkRequestSetupSuccessful = false;
        try {
            this.listener.beforeBulk(executionId, bulkRequest);
            this.semaphore.acquire();
            toRelease = this.semaphore::release;
            CountDownLatch latch = new CountDownLatch(1);
            this.retry.withBackoff(this.consumer, bulkRequest, ActionListenerHelper.runAfter((ActionListener)new ActionListener<BulkResponse>(){

                public void onResponse(BulkResponse response) {
                    BulkRequestHandler.this.listener.afterBulk(executionId, bulkRequest, response);
                }

                public void onFailure(Exception e) {
                    BulkRequestHandler.this.listener.afterBulk(executionId, bulkRequest, e);
                }
            }, () -> {
                this.semaphore.release();
                latch.countDown();
            }));
            bulkRequestSetupSuccessful = true;
            if (this.concurrentRequests == 0) {
                latch.await();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logger.info(() -> new ParameterizedMessage("Bulk request {} has been cancelled.", (Object)executionId), (Throwable)e);
            this.listener.afterBulk(executionId, bulkRequest, e);
        }
        catch (Exception e) {
            this.logger.warn(() -> new ParameterizedMessage("Failed to execute bulk request {}.", (Object)executionId), (Throwable)e);
            this.listener.afterBulk(executionId, bulkRequest, e);
        }
        finally {
            if (!bulkRequestSetupSuccessful) {
                toRelease.run();
            }
        }
    }

    boolean awaitClose(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.semaphore.tryAcquire(this.concurrentRequests, timeout, unit)) {
            this.semaphore.release(this.concurrentRequests);
            return true;
        }
        return false;
    }
}

