/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.bulk;

import io.lucenia.action.bulk.TransportShardBulkAction;
import io.lucenia.action.update.TransportUpdateAction;
import io.skylite.ResourceAlreadyExistsException;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteParseException;
import io.skylite.Version;
import io.skylite.common.Assertions;
import io.skylite.common.action.ActionListener;
import io.skylite.common.action.ActionRunnable;
import io.skylite.common.lease.Releasable;
import io.skylite.common.telemetry.tracing.Span;
import io.skylite.common.telemetry.tracing.SpanScope;
import io.skylite.common.telemetry.tracing.Tracer;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.DocWriteRequest;
import io.skylite.core.action.DocWriteResponse;
import io.skylite.core.action.RoutingMissingException;
import io.skylite.core.action.admin.indices.create.AutoCreateAction;
import io.skylite.core.action.admin.indices.create.CreateIndexRequest;
import io.skylite.core.action.admin.indices.create.CreateIndexResponse;
import io.skylite.core.action.bulk.BaseTransportBulkAction;
import io.skylite.core.action.bulk.BulkAction;
import io.skylite.core.action.bulk.BulkItemRequest;
import io.skylite.core.action.bulk.BulkItemResponse;
import io.skylite.core.action.bulk.BulkRequest;
import io.skylite.core.action.bulk.BulkResponse;
import io.skylite.core.action.bulk.BulkShardRequest;
import io.skylite.core.action.bulk.BulkShardResponse;
import io.skylite.core.action.index.IndexRequest;
import io.skylite.core.action.ingest.IngestActionForwarder;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.replication.ReplicatedWriteRequest;
import io.skylite.core.action.update.UpdateRequest;
import io.skylite.core.action.update.UpdateResponse;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.DataStream;
import io.skylite.core.cluster.metadata.IndexAbstraction;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.metadata.MappingMetadata;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateApplier;
import io.skylite.core.cluster.state.ClusterStateObserver;
import io.skylite.core.common.concurrent.AtomicArray;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.index.Index;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.index.VersionType;
import io.skylite.core.index.pressure.IndexingPressureService;
import io.skylite.core.index.shard.IndexingStats;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.indices.IndexClosedException;
import io.skylite.core.indices.SystemIndices;
import io.skylite.core.ingest.BaseIngestService;
import io.skylite.core.node.NodeClosedException;
import io.skylite.core.tasks.Task;
import io.skylite.core.telemetry.tracing.SpanBuilder;
import io.skylite.core.telemetry.tracing.listener.TraceableActionListener;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SparseFixedBitSet;
import org.opensearch.indices.IndicesService;

public class TransportBulkAction
extends BaseTransportBulkAction {
    private static final Logger logger = LogManager.getLogger(TransportBulkAction.class);
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final BaseIngestService ingestService;
    private final TransportShardBulkAction shardBulkAction;
    private final LongSupplier relativeTimeProvider;
    private final IngestActionForwarder ingestForwarder;
    private final NodeClient client;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private static final String DROPPED_ITEM_WITH_AUTO_GENERATED_ID = "auto-generated";
    private final IndexingPressureService indexingPressureService;
    private final IndicesService indicesService;
    private final SystemIndices systemIndices;
    private final Tracer tracer;

    @Inject
    public TransportBulkAction(ThreadPool threadPool, TransportService transportService, ClusterService clusterService, BaseIngestService ingestService, TransportShardBulkAction shardBulkAction, NodeClient client, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndexingPressureService indexingPressureService, IndicesService indicesService, SystemIndices systemIndices, Tracer tracer) {
        this(threadPool, transportService, clusterService, ingestService, shardBulkAction, client, actionFilters, indexNameExpressionResolver, indexingPressureService, indicesService, systemIndices, System::nanoTime, tracer);
    }

    public TransportBulkAction(ThreadPool threadPool, TransportService transportService, ClusterService clusterService, BaseIngestService ingestService, TransportShardBulkAction shardBulkAction, NodeClient client, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndexingPressureService indexingPressureService, IndicesService indicesService, SystemIndices systemIndices, LongSupplier relativeTimeProvider, Tracer tracer) {
        super("indices:data/write/bulk", transportService, actionFilters, BulkRequest::new, "same");
        Objects.requireNonNull(relativeTimeProvider);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.ingestService = ingestService;
        this.shardBulkAction = shardBulkAction;
        this.relativeTimeProvider = relativeTimeProvider;
        this.ingestForwarder = new IngestActionForwarder(transportService);
        this.client = client;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.indexingPressureService = indexingPressureService;
        this.indicesService = indicesService;
        this.systemIndices = systemIndices;
        clusterService.addStateApplier((ClusterStateApplier)this.ingestForwarder);
        this.tracer = tracer;
    }

    public static IndexRequest getIndexWriteRequest(DocWriteRequest<?> docWriteRequest) {
        IndexRequest indexRequest = null;
        if (docWriteRequest instanceof IndexRequest) {
            indexRequest = (IndexRequest)docWriteRequest;
        } else if (docWriteRequest instanceof UpdateRequest) {
            UpdateRequest updateRequest = (UpdateRequest)docWriteRequest;
            indexRequest = updateRequest.docAsUpsert() ? updateRequest.doc() : updateRequest.upsertRequest();
        }
        return indexRequest;
    }

    protected void doExecute(Task task, BulkRequest bulkRequest, ActionListener<BulkResponse> listener) {
        boolean isOnlySystem = this.isOnlySystem(bulkRequest, this.clusterService.state().metadata().getIndicesLookup(), this.systemIndices);
        Releasable releasable = this.indexingPressureService.markCoordinatingOperationStarted(() -> ((BulkRequest)bulkRequest).ramBytesUsed(), isOnlySystem);
        ActionListener releasingListener = ActionListenerHelper.runBefore(listener, () -> ((Releasable)releasable).close());
        String executorName = isOnlySystem ? "system_write" : "write";
        try {
            this.doInternalExecute(task, bulkRequest, executorName, (ActionListener<BulkResponse>)releasingListener);
        }
        catch (Exception e) {
            releasingListener.onFailure(e);
        }
    }

    protected void doInternalExecute(final Task task, final BulkRequest bulkRequest, final String executorName, final ActionListener<BulkResponse> listener) {
        final long startTime = this.relativeTime();
        final AtomicArray responses = new AtomicArray(bulkRequest.requests().size());
        boolean hasIndexRequestsWithPipelines = false;
        Metadata metadata = this.clusterService.state().getMetadata();
        Version minNodeVersion = this.clusterService.state().getNodes().getMinNodeVersion();
        for (DocWriteRequest actionRequest : bulkRequest.requests()) {
            IndexRequest indexRequest = TransportBulkAction.getIndexWriteRequest(actionRequest);
            if (indexRequest != null) {
                boolean indexRequestHasPipeline = BaseIngestService.resolvePipelines((DocWriteRequest)actionRequest, (IndexRequest)indexRequest, (Metadata)metadata);
                hasIndexRequestsWithPipelines |= indexRequestHasPipeline;
            }
            if (!(actionRequest instanceof IndexRequest)) continue;
            IndexRequest ir = (IndexRequest)actionRequest;
            ir.checkAutoIdWithOpTypeCreateSupportedByVersion(minNodeVersion);
            if (ir.getAutoGeneratedTimestamp() == -1L) continue;
            throw new IllegalArgumentException("autoGeneratedTimestamp should not be set externally");
        }
        if (hasIndexRequestsWithPipelines) {
            try {
                if (Assertions.ENABLED) {
                    boolean arePipelinesResolved = bulkRequest.requests().stream().map(TransportBulkAction::getIndexWriteRequest).filter(Objects::nonNull).allMatch(IndexRequest::isPipelineResolved);
                    assert (arePipelinesResolved) : bulkRequest;
                }
                if (this.clusterService.localNode().isIngestNode()) {
                    this.processBulkIndexIngestRequest(task, bulkRequest, executorName, listener);
                } else {
                    this.ingestForwarder.forwardIngestRequest((ActionType)BulkAction.INSTANCE, (ActionRequest)bulkRequest, listener);
                }
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
            return;
        }
        Map<String, Boolean> indices = bulkRequest.requests().stream().filter(request -> request.opType() != DocWriteRequest.OpType.DELETE || request.versionType() == VersionType.EXTERNAL || request.versionType() == VersionType.EXTERNAL_GTE).collect(Collectors.toMap(DocWriteRequest::index, DocWriteRequest::isRequireAlias, (v1, v2) -> v1 != false || v2 != false));
        final HashMap<String, IndexNotFoundException> indicesThatCannotBeCreated = new HashMap<String, IndexNotFoundException>();
        HashSet<String> autoCreateIndices = new HashSet<String>();
        ClusterState state = this.clusterService.state();
        for (Map.Entry<String, Boolean> indexAndFlag : indices.entrySet()) {
            final String index = indexAndFlag.getKey();
            boolean shouldAutoCreate = !this.indexNameExpressionResolver.hasIndexAbstraction(index, state);
            if (!shouldAutoCreate || indexAndFlag.getValue().booleanValue()) continue;
            autoCreateIndices.add(index);
        }
        if (autoCreateIndices.isEmpty()) {
            this.executeBulk(task, bulkRequest, startTime, listener, (AtomicArray<BulkItemResponse>)responses, indicesThatCannotBeCreated);
        } else {
            final AtomicInteger counter = new AtomicInteger(autoCreateIndices.size());
            for (final String index : autoCreateIndices) {
                this.createIndex(index, bulkRequest.timeout(), minNodeVersion, new ActionListener<CreateIndexResponse>(){

                    public void onResponse(CreateIndexResponse result) {
                        if (counter.decrementAndGet() == 0) {
                            TransportBulkAction.this.threadPool.executor(executorName).execute(() -> TransportBulkAction.this.executeBulk(task, bulkRequest, startTime, (ActionListener<BulkResponse>)listener, (AtomicArray<BulkItemResponse>)responses, indicesThatCannotBeCreated));
                        }
                    }

                    public void onFailure(final Exception e) {
                        Throwable cause = SkyliteExceptionsHelper.unwrapCause((Throwable)e);
                        if (cause instanceof IndexNotFoundException) {
                            indicesThatCannotBeCreated.put(index, (IndexNotFoundException)((Object)e));
                        } else if (!(cause instanceof ResourceAlreadyExistsException)) {
                            for (int i = 0; i < bulkRequest.requests().size(); ++i) {
                                DocWriteRequest request = (DocWriteRequest)bulkRequest.requests().get(i);
                                if (request == null || !TransportBulkAction.this.setResponseFailureIfIndexMatches((AtomicArray<BulkItemResponse>)responses, i, request, index, e)) continue;
                                bulkRequest.requests().set(i, null);
                            }
                        }
                        if (counter.decrementAndGet() == 0) {
                            final ActionListener wrappedListener = ActionListenerHelper.wrap(arg_0 -> ((ActionListener)listener).onResponse(arg_0), inner -> {
                                inner.addSuppressed(e);
                                listener.onFailure(inner);
                            });
                            TransportBulkAction.this.threadPool.executor(executorName).execute((Runnable)new ActionRunnable<BulkResponse>(wrappedListener){

                                public void doRun() {
                                    TransportBulkAction.this.executeBulk(task, bulkRequest, startTime, (ActionListener<BulkResponse>)wrappedListener, (AtomicArray<BulkItemResponse>)responses, indicesThatCannotBeCreated);
                                }

                                public void onRejection(Exception rejectedException) {
                                    rejectedException.addSuppressed(e);
                                    super.onRejection(rejectedException);
                                }
                            });
                        }
                    }
                });
            }
        }
    }

    static void prohibitAppendWritesInBackingIndices(DocWriteRequest<?> writeRequest, Metadata metadata) {
        IndexAbstraction indexAbstraction = (IndexAbstraction)metadata.getIndicesLookup().get(writeRequest.index());
        if (indexAbstraction == null) {
            return;
        }
        if (indexAbstraction.getType() != IndexAbstraction.Type.CONCRETE_INDEX) {
            return;
        }
        if (indexAbstraction.getParentDataStream() == null) {
            return;
        }
        DataStream dataStream = indexAbstraction.getParentDataStream().getDataStream();
        DocWriteRequest.OpType opType = writeRequest.opType();
        if (opType == DocWriteRequest.OpType.CREATE) {
            throw new IllegalArgumentException("index request with op_type=create targeting backing indices is disallowed, target corresponding data stream [" + dataStream.getName() + "] instead");
        }
        if (opType == DocWriteRequest.OpType.INDEX && writeRequest.ifPrimaryTerm() == 0L && writeRequest.ifSeqNo() == -2L) {
            throw new IllegalArgumentException("index request with op_type=index and no if_primary_term and if_seq_no set targeting backing indices is disallowed, target corresponding data stream [" + dataStream.getName() + "] instead");
        }
    }

    static void prohibitCustomRoutingOnDataStream(DocWriteRequest<?> writeRequest, Metadata metadata) {
        IndexAbstraction indexAbstraction = (IndexAbstraction)metadata.getIndicesLookup().get(writeRequest.index());
        if (indexAbstraction == null) {
            return;
        }
        if (indexAbstraction.getType() != IndexAbstraction.Type.DATA_STREAM) {
            return;
        }
        if (writeRequest.routing() != null) {
            IndexAbstraction.DataStream dataStream = (IndexAbstraction.DataStream)indexAbstraction;
            throw new IllegalArgumentException("index request targeting data stream [" + dataStream.getName() + "] specifies a custom routing. target the backing indices directly or remove the custom routing.");
        }
    }

    boolean isOnlySystem(BulkRequest request, SortedMap<String, IndexAbstraction> indicesLookup, SystemIndices systemIndices) {
        return request.getIndices().stream().allMatch(indexName -> this.isSystemIndex(indicesLookup, systemIndices, (String)indexName));
    }

    private boolean isSystemIndex(SortedMap<String, IndexAbstraction> indicesLookup, SystemIndices systemIndices, String indexName) {
        IndexAbstraction abstraction = (IndexAbstraction)indicesLookup.get(indexName);
        if (abstraction != null) {
            return abstraction.isSystem();
        }
        return systemIndices.isSystemIndex(indexName);
    }

    void createIndex(String index, TimeValue timeout, Version minNodeVersion, ActionListener<CreateIndexResponse> listener) {
        CreateIndexRequest createIndexRequest = new CreateIndexRequest();
        createIndexRequest.index(index);
        createIndexRequest.cause("auto(bulk api)");
        createIndexRequest.clusterManagerNodeTimeout(timeout);
        this.client.execute((ActionType)AutoCreateAction.INSTANCE, (ActionRequest)createIndexRequest, listener);
    }

    private boolean setResponseFailureIfIndexMatches(AtomicArray<BulkItemResponse> responses, int idx, DocWriteRequest<?> request, String index, Exception e) {
        if (index.equals(request.index())) {
            responses.set(idx, (Object)new BulkItemResponse(idx, request.opType(), new BulkItemResponse.Failure(request.index(), request.id(), e)));
            return true;
        }
        return false;
    }

    private long buildTookInMillis(long startTimeNanos) {
        return TimeUnit.NANOSECONDS.toMillis(this.relativeTime() - startTimeNanos);
    }

    void executeBulk(Task task, BulkRequest bulkRequest, long startTimeNanos, ActionListener<BulkResponse> listener, AtomicArray<BulkItemResponse> responses, Map<String, IndexNotFoundException> indicesThatCannotBeCreated) {
        new BulkOperation(task, bulkRequest, listener, responses, startTimeNanos, indicesThatCannotBeCreated).run();
    }

    private long relativeTime() {
        return this.relativeTimeProvider.getAsLong();
    }

    private void processBulkIndexIngestRequest(final Task task, BulkRequest original, final String executorName, ActionListener<BulkResponse> listener) {
        long ingestStartTimeInNanos = System.nanoTime();
        BulkRequestModifier bulkRequestModifier = new BulkRequestModifier(original);
        this.ingestService.executeBulkRequest(original.numberOfActions(), () -> bulkRequestModifier, bulkRequestModifier::markItemAsFailed, (originalThread, exception) -> {
            if (exception != null) {
                logger.debug("failed to execute pipeline for a bulk request", (Throwable)exception);
                listener.onFailure(exception);
            } else {
                long ingestTookInMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - ingestStartTimeInNanos);
                final BulkRequest bulkRequest = bulkRequestModifier.getBulkRequest();
                final ActionListener<BulkResponse> actionListener = bulkRequestModifier.wrapActionListenerIfNeeded(ingestTookInMillis, listener);
                if (bulkRequest.requests().isEmpty()) {
                    actionListener.onResponse((Object)new BulkResponse(new BulkItemResponse[0], 0L));
                } else if (originalThread == Thread.currentThread()) {
                    assert (Thread.currentThread().getName().contains(executorName));
                    this.doInternalExecute(task, bulkRequest, executorName, actionListener);
                } else {
                    this.threadPool.executor(executorName).execute((Runnable)new ActionRunnable<BulkResponse>(listener){

                        public void doRun() {
                            TransportBulkAction.this.doInternalExecute(task, bulkRequest, executorName, (ActionListener<BulkResponse>)actionListener);
                        }

                        public boolean isForceExecution() {
                            return true;
                        }
                    });
                }
            }
        }, bulkRequestModifier::markItemAsDropped, executorName);
    }

    private final class BulkOperation
    extends ActionRunnable<BulkResponse> {
        private final Task task;
        private BulkRequest bulkRequest;
        private final AtomicArray<BulkItemResponse> responses;
        private final long startTimeNanos;
        private final ClusterStateObserver observer;
        private final Map<String, IndexNotFoundException> indicesThatCannotBeCreated;

        BulkOperation(Task task, BulkRequest bulkRequest, ActionListener<BulkResponse> listener, AtomicArray<BulkItemResponse> responses, long startTimeNanos, Map<String, IndexNotFoundException> indicesThatCannotBeCreated) {
            super(listener);
            this.task = task;
            this.bulkRequest = bulkRequest;
            this.responses = responses;
            this.startTimeNanos = startTimeNanos;
            this.indicesThatCannotBeCreated = indicesThatCannotBeCreated;
            this.observer = new ClusterStateObserver(TransportBulkAction.this.clusterService, bulkRequest.timeout(), logger, TransportBulkAction.this.threadPool.getThreadContext());
        }

        public void doRun() {
            assert (this.bulkRequest != null);
            ClusterState clusterState = this.observer.setAndGetObservedState();
            if (this.handleBlockExceptions(clusterState)) {
                return;
            }
            final ConcreteIndices concreteIndices = new ConcreteIndices(clusterState, TransportBulkAction.this.indexNameExpressionResolver);
            Metadata metadata = clusterState.metadata();
            block14: for (int i = 0; i < this.bulkRequest.requests().size(); ++i) {
                DocWriteRequest docWriteRequest = (DocWriteRequest)this.bulkRequest.requests().get(i);
                if (docWriteRequest == null || this.addFailureIfRequiresAliasAndAliasIsMissing(docWriteRequest, i, metadata) || this.addFailureIfIndexIsUnavailable(docWriteRequest, i, concreteIndices, metadata)) continue;
                Index concreteIndex = concreteIndices.resolveIfAbsent(docWriteRequest);
                try {
                    IndexAbstraction indexAbstraction = (IndexAbstraction)clusterState.getMetadata().getIndicesLookup().get(concreteIndex.getName());
                    if (indexAbstraction.getParentDataStream() != null && !concreteIndex.getName().equals(docWriteRequest.index()) && docWriteRequest.opType() != DocWriteRequest.OpType.CREATE) {
                        throw new IllegalArgumentException("only write ops with an op_type of create are allowed in data streams");
                    }
                    switch (docWriteRequest.opType()) {
                        case CREATE: 
                        case INDEX: {
                            TransportBulkAction.prohibitAppendWritesInBackingIndices(docWriteRequest, metadata);
                            TransportBulkAction.prohibitCustomRoutingOnDataStream(docWriteRequest, metadata);
                            IndexRequest indexRequest = (IndexRequest)docWriteRequest;
                            IndexMetadata indexMetadata = metadata.index(concreteIndex);
                            MappingMetadata mappingMd = indexMetadata.mapping();
                            Version indexCreated = indexMetadata.getCreationVersion();
                            indexRequest.resolveRouting(metadata);
                            indexRequest.process(indexCreated, mappingMd, concreteIndex.getName());
                            break;
                        }
                        case UPDATE: {
                            TransportUpdateAction.resolveAndValidateRouting(metadata, concreteIndex.getName(), (UpdateRequest)docWriteRequest);
                            break;
                        }
                        case DELETE: {
                            docWriteRequest.routing(metadata.resolveWriteIndexRouting(docWriteRequest.routing(), docWriteRequest.index()));
                            if (docWriteRequest.routing() != null || !metadata.routingRequired(concreteIndex.getName())) continue block14;
                            throw new RoutingMissingException(concreteIndex.getName(), docWriteRequest.id());
                        }
                        default: {
                            throw new AssertionError((Object)("request type not supported: [" + String.valueOf(docWriteRequest.opType()) + "]"));
                        }
                    }
                    continue;
                }
                catch (SkyliteParseException | RoutingMissingException | IllegalArgumentException e) {
                    BulkItemResponse.Failure failure = new BulkItemResponse.Failure(concreteIndex.getName(), docWriteRequest.id(), (Exception)e);
                    BulkItemResponse bulkItemResponse = new BulkItemResponse(i, docWriteRequest.opType(), failure);
                    this.responses.set(i, (Object)bulkItemResponse);
                    this.bulkRequest.setRequest(i, null);
                }
            }
            HashMap<ShardId, List> requestsByShard = new HashMap<ShardId, List>();
            for (int i = 0; i < this.bulkRequest.requests().size(); ++i) {
                DocWriteRequest request = (DocWriteRequest)this.bulkRequest.requests().get(i);
                if (request == null) continue;
                String concreteIndex = concreteIndices.getConcreteIndex(request.index()).getName();
                ShardId shardId = TransportBulkAction.this.clusterService.operationRouting().indexShards(clusterState, concreteIndex, request.id(), request.routing()).shardId();
                List shardRequests = requestsByShard.computeIfAbsent(shardId, shard -> new ArrayList());
                shardRequests.add(new BulkItemRequest(i, request));
            }
            if (requestsByShard.isEmpty()) {
                BulkItemResponse[] response = (BulkItemResponse[])this.responses.toArray((Object[])new BulkItemResponse[this.responses.length()]);
                long tookMillis = TransportBulkAction.this.buildTookInMillis(this.startTimeNanos);
                IndexingStats.Stats.DocStatusStats stats = new IndexingStats.Stats.DocStatusStats();
                for (BulkItemResponse itemResponse : response) {
                    if (itemResponse == null) continue;
                    stats.inc(itemResponse.status());
                }
                TransportBulkAction.this.indicesService.addDocStatusStats(stats);
                this.listener.onResponse((Object)new BulkResponse(response, tookMillis));
                return;
            }
            final AtomicInteger counter = new AtomicInteger(requestsByShard.size());
            final IndexingStats.Stats.DocStatusStats docStatusStats = new IndexingStats.Stats.DocStatusStats();
            String nodeId = TransportBulkAction.this.clusterService.localNode().getId();
            for (Map.Entry entry : requestsByShard.entrySet()) {
                ShardId shardId = (ShardId)entry.getKey();
                final List requests = (List)entry.getValue();
                BulkShardRequest bulkShardRequest = new BulkShardRequest(shardId, this.bulkRequest.getRefreshPolicy(), requests.toArray(new BulkItemRequest[0]));
                bulkShardRequest.waitForActiveShards(this.bulkRequest.waitForActiveShards());
                bulkShardRequest.timeout(this.bulkRequest.timeout());
                bulkShardRequest.routedBasedOnClusterVersion(clusterState.version());
                if (this.task != null) {
                    bulkShardRequest.setParentTask(nodeId, this.task.getId());
                }
                boolean isOnlySystem = TransportBulkAction.this.isOnlySystem(this.bulkRequest, TransportBulkAction.this.clusterService.state().metadata().getIndicesLookup(), TransportBulkAction.this.systemIndices);
                Releasable releasable = TransportBulkAction.this.indexingPressureService.markCoordinatingOperationStarted(shardId, () -> ((BulkShardRequest)bulkShardRequest).ramBytesUsed(), isOnlySystem);
                Span span = TransportBulkAction.this.tracer.startSpan(SpanBuilder.from((String)"bulkShardAction", (String)nodeId, (ReplicatedWriteRequest)bulkShardRequest));
                try {
                    SpanScope spanScope = TransportBulkAction.this.tracer.withSpanInScope(span);
                    try {
                        TransportBulkAction.this.shardBulkAction.execute((ActionRequest)bulkShardRequest, TraceableActionListener.create((ActionListener)ActionListenerHelper.runBefore((ActionListener)new ActionListener<BulkShardResponse>(){

                            public void onResponse(BulkShardResponse bulkShardResponse) {
                                for (BulkItemResponse bulkItemResponse : bulkShardResponse.getResponses()) {
                                    if (bulkItemResponse.getResponse() != null) {
                                        bulkItemResponse.getResponse().setShardInfo(bulkShardResponse.getShardInfo());
                                    }
                                    docStatusStats.inc(bulkItemResponse.status());
                                    BulkOperation.this.responses.set(bulkItemResponse.getItemId(), (Object)bulkItemResponse);
                                }
                                if (counter.decrementAndGet() == 0) {
                                    this.finishHim();
                                }
                            }

                            public void onFailure(Exception e) {
                                for (BulkItemRequest request : requests) {
                                    String indexName = concreteIndices.getConcreteIndex(request.index()).getName();
                                    DocWriteRequest docWriteRequest = request.request();
                                    BulkItemResponse bulkItemResponse = new BulkItemResponse(request.id(), docWriteRequest.opType(), new BulkItemResponse.Failure(indexName, docWriteRequest.id(), e));
                                    docStatusStats.inc(bulkItemResponse.status());
                                    BulkOperation.this.responses.set(request.id(), (Object)bulkItemResponse);
                                }
                                if (counter.decrementAndGet() == 0) {
                                    this.finishHim();
                                }
                            }

                            private void finishHim() {
                                TransportBulkAction.this.indicesService.addDocStatusStats(docStatusStats);
                                BulkOperation.this.listener.onResponse((Object)new BulkResponse((BulkItemResponse[])BulkOperation.this.responses.toArray((Object[])new BulkItemResponse[BulkOperation.this.responses.length()]), TransportBulkAction.this.buildTookInMillis(BulkOperation.this.startTimeNanos)));
                            }
                        }, () -> ((Releasable)releasable).close()), (Span)span, (Tracer)TransportBulkAction.this.tracer));
                    }
                    finally {
                        if (spanScope == null) continue;
                        spanScope.close();
                    }
                }
                catch (Exception e) {
                    span.setError(e);
                    span.endSpan();
                    throw e;
                }
            }
            this.bulkRequest = null;
        }

        private boolean handleBlockExceptions(ClusterState state) {
            ClusterBlockException blockException = state.blocks().globalBlockedException(ClusterBlockLevel.WRITE);
            if (blockException != null) {
                if (blockException.retryable()) {
                    logger.trace("cluster is blocked, scheduling a retry", (Throwable)blockException);
                    this.retry((Exception)blockException);
                } else {
                    this.onFailure((Exception)blockException);
                }
                return true;
            }
            return false;
        }

        void retry(Exception failure) {
            assert (failure != null);
            if (this.observer.isTimedOut()) {
                this.onFailure(failure);
                return;
            }
            this.observer.waitForNextChange(new ClusterStateObserver.Listener(){

                public void onNewClusterState(ClusterState state) {
                    BulkOperation.this.run();
                }

                public void onClusterServiceClose() {
                    BulkOperation.this.onFailure((Exception)new NodeClosedException(TransportBulkAction.this.clusterService.localNode()));
                }

                public void onTimeout(TimeValue timeout) {
                    BulkOperation.this.run();
                }
            });
        }

        private boolean addFailureIfRequiresAliasAndAliasIsMissing(DocWriteRequest<?> request, int idx, Metadata metadata) {
            if (request.isRequireAlias() && !metadata.hasAlias(request.index())) {
                IndexNotFoundException exception = new IndexNotFoundException("[require_alias] request flag is [true] and [" + request.index() + "] is not an alias", request.index());
                this.addFailure(request, idx, (Exception)((Object)exception));
                return true;
            }
            return false;
        }

        private boolean addFailureIfIndexIsUnavailable(DocWriteRequest<?> request, int idx, ConcreteIndices concreteIndices, Metadata metadata) {
            IndexMetadata indexMetadata;
            IndexNotFoundException cannotCreate = this.indicesThatCannotBeCreated.get(request.index());
            if (cannotCreate != null) {
                this.addFailure(request, idx, (Exception)((Object)cannotCreate));
                return true;
            }
            Index concreteIndex = concreteIndices.getConcreteIndex(request.index());
            if (concreteIndex == null) {
                try {
                    concreteIndex = concreteIndices.resolveIfAbsent(request);
                }
                catch (IndexNotFoundException | IndexClosedException | IllegalArgumentException ex) {
                    this.addFailure(request, idx, (Exception)ex);
                    return true;
                }
            }
            if ((indexMetadata = metadata.getIndexSafe(concreteIndex)).getState() == IndexMetadata.State.CLOSE) {
                this.addFailure(request, idx, (Exception)((Object)new IndexClosedException(concreteIndex)));
                return true;
            }
            return false;
        }

        private void addFailure(DocWriteRequest<?> request, int idx, Exception unavailableException) {
            BulkItemResponse.Failure failure = new BulkItemResponse.Failure(request.index(), request.id(), unavailableException);
            BulkItemResponse bulkItemResponse = new BulkItemResponse(idx, request.opType(), failure);
            this.responses.set(idx, (Object)bulkItemResponse);
            this.bulkRequest.setRequest(idx, null);
        }
    }

    static final class BulkRequestModifier
    implements Iterator<DocWriteRequest<?>> {
        final BulkRequest bulkRequest;
        final SparseFixedBitSet failedSlots;
        final List<BulkItemResponse> itemResponses;
        final AtomicIntegerArray originalSlots;
        volatile int currentSlot = -1;

        BulkRequestModifier(BulkRequest bulkRequest) {
            this.bulkRequest = bulkRequest;
            this.failedSlots = new SparseFixedBitSet(bulkRequest.requests().size());
            this.itemResponses = new ArrayList<BulkItemResponse>(bulkRequest.requests().size());
            this.originalSlots = new AtomicIntegerArray(bulkRequest.requests().size());
        }

        @Override
        public DocWriteRequest<?> next() {
            return (DocWriteRequest)this.bulkRequest.requests().get(++this.currentSlot);
        }

        @Override
        public boolean hasNext() {
            return this.currentSlot + 1 < this.bulkRequest.requests().size();
        }

        BulkRequest getBulkRequest() {
            if (this.itemResponses.isEmpty()) {
                return this.bulkRequest;
            }
            BulkRequest modifiedBulkRequest = new BulkRequest();
            modifiedBulkRequest.setRefreshPolicy(this.bulkRequest.getRefreshPolicy());
            modifiedBulkRequest.waitForActiveShards(this.bulkRequest.waitForActiveShards());
            modifiedBulkRequest.timeout(this.bulkRequest.timeout());
            int slot = 0;
            List requests = this.bulkRequest.requests();
            for (int i = 0; i < requests.size(); ++i) {
                DocWriteRequest request = (DocWriteRequest)requests.get(i);
                if (this.failedSlots.get(i)) continue;
                modifiedBulkRequest.add(request);
                this.originalSlots.set(slot++, i);
            }
            return modifiedBulkRequest;
        }

        ActionListener<BulkResponse> wrapActionListenerIfNeeded(long ingestTookInMillis, ActionListener<BulkResponse> actionListener) {
            if (this.itemResponses.isEmpty()) {
                return ActionListenerHelper.map(actionListener, response -> new BulkResponse(response.getItems(), response.getTook().getMillis(), ingestTookInMillis));
            }
            return ActionListenerHelper.delegateFailure(actionListener, (delegatedListener, response) -> {
                BulkItemResponse[] items = response.getItems();
                for (int i = 0; i < items.length; ++i) {
                    this.itemResponses.add(this.originalSlots.get(i), response.getItems()[i]);
                }
                delegatedListener.onResponse((Object)new BulkResponse(this.itemResponses.toArray(new BulkItemResponse[0]), response.getTook().getMillis(), ingestTookInMillis));
            });
        }

        synchronized void markItemAsDropped(int slot) {
            IndexRequest indexRequest = TransportBulkAction.getIndexWriteRequest((DocWriteRequest)this.bulkRequest.requests().get(slot));
            this.failedSlots.set(slot);
            String id = indexRequest.id() == null ? TransportBulkAction.DROPPED_ITEM_WITH_AUTO_GENERATED_ID : indexRequest.id();
            this.itemResponses.add(new BulkItemResponse(slot, indexRequest.opType(), (DocWriteResponse)new UpdateResponse(new ShardId(indexRequest.index(), "_na_", 0), id, -2L, 0L, indexRequest.version(), DocWriteResponse.Result.NOOP)));
        }

        synchronized void markItemAsFailed(int slot, Exception e) {
            IndexRequest indexRequest = TransportBulkAction.getIndexWriteRequest((DocWriteRequest)this.bulkRequest.requests().get(slot));
            logger.debug(String.format(Locale.ROOT, "failed to execute pipeline [%s] for document [%s/%s]", indexRequest.getPipeline(), indexRequest.index(), indexRequest.id()), (Throwable)e);
            this.failedSlots.set(slot);
            BulkItemResponse.Failure failure = new BulkItemResponse.Failure(indexRequest.index(), indexRequest.id(), e);
            this.itemResponses.add(new BulkItemResponse(slot, indexRequest.opType(), failure));
        }
    }

    public static class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return BulkAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportBulkAction.class;
        }
    }

    private static class ConcreteIndices {
        private final ClusterState state;
        private final IndexNameExpressionResolver indexNameExpressionResolver;
        private final Map<String, Index> indices = new HashMap<String, Index>();

        ConcreteIndices(ClusterState state, IndexNameExpressionResolver indexNameExpressionResolver) {
            this.state = state;
            this.indexNameExpressionResolver = indexNameExpressionResolver;
        }

        Index getConcreteIndex(String indexOrAlias) {
            return this.indices.get(indexOrAlias);
        }

        Index resolveIfAbsent(DocWriteRequest<?> request) {
            Index concreteIndex = this.indices.get(request.index());
            if (concreteIndex == null) {
                boolean includeDataStreams = request.opType() == DocWriteRequest.OpType.CREATE;
                try {
                    concreteIndex = this.indexNameExpressionResolver.concreteWriteIndex(this.state, request.indicesOptions(), request.indices()[0], false, includeDataStreams);
                }
                catch (IndexNotFoundException e) {
                    if (!includeDataStreams && e.getMetadataKeys().contains("skylite.excluded_ds")) {
                        throw new IllegalArgumentException("only write ops with an op_type of create are allowed in data streams");
                    }
                    throw e;
                }
                this.indices.put(request.index(), concreteIndex);
            }
            return concreteIndex;
        }
    }
}

