/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.explain;

import io.skylite.SkyliteException;
import io.skylite.common.action.ActionListener;
import io.skylite.common.lease.Releasable;
import io.skylite.common.lease.Releasables;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.ParseField;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.RoutingMissingException;
import io.skylite.core.action.explain.ExplainAction;
import io.skylite.core.action.explain.ExplainRequest;
import io.skylite.core.action.explain.ExplainResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.single.shard.SingleShardRequest;
import io.skylite.core.action.support.single.shard.TransportSingleShardAction;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.routing.ShardIterator;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.index.engine.Engine;
import io.skylite.core.index.get.GetResult;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.mapper.Uid;
import io.skylite.core.search.internal.AliasFilter;
import io.skylite.core.search.internal.ShardSearchRequest;
import io.skylite.core.search.rescore.RescoreContext;
import io.skylite.core.search.rescore.Rescorer;
import io.skylite.core.tasks.Task;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.opensearch.index.IndexService;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.search.DefaultSearchContext;
import org.opensearch.search.SearchService;
import org.opensearch.search.internal.SearchContext;

public class TransportExplainAction
extends TransportSingleShardAction<ExplainRequest, ExplainResponse> {
    private final SearchService searchService;

    @Inject
    public TransportExplainAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, SearchService searchService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:data/read/explain", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, ExplainRequest::new, "get");
        this.searchService = searchService;
    }

    protected void doExecute(Task task, ExplainRequest request, ActionListener<ExplainResponse> listener) {
        request.nowInMillis(System.currentTimeMillis());
        super.doExecute(task, (SingleShardRequest)request, listener);
    }

    protected boolean resolveIndex(ExplainRequest request) {
        return true;
    }

    protected void resolveRequest(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        Set indicesAndAliases = this.indexNameExpressionResolver.resolveExpressions(state, new String[]{((ExplainRequest)request.request()).index()});
        AliasFilter aliasFilter = this.searchService.buildAliasFilter(state, request.concreteIndex(), indicesAndAliases);
        ((ExplainRequest)request.request()).filteringAlias(aliasFilter);
        if (((ExplainRequest)request.request()).routing() == null && state.getMetadata().routingRequired(request.concreteIndex())) {
            throw new RoutingMissingException(request.concreteIndex(), ((ExplainRequest)request.request()).id());
        }
    }

    protected void asyncShardOperation(ExplainRequest request, ShardId shardId, ActionListener<ExplainResponse> listener) throws IOException {
        IndexShard baseIndexShard;
        IndexService baseIndexService;
        IndexService indexService = baseIndexService = this.searchService.getIndicesService().indexServiceSafe(shardId.getIndex());
        IndexShard indexShard = baseIndexShard = indexService.getShard(shardId.id());
        indexShard.awaitShardSearchActive(b -> {
            try {
                super.asyncShardOperation((SingleShardRequest)request, shardId, listener);
            }
            catch (Exception ex) {
                listener.onFailure(ex);
            }
        });
    }

    protected ExplainResponse shardOperation(ExplainRequest request, ShardId shardId) throws IOException {
        ExplainResponse explainResponse;
        Explanation explanation;
        Engine.GetResult result;
        DefaultSearchContext context;
        block8: {
            block7: {
                ShardSearchRequest shardSearchLocalRequest = new ShardSearchRequest(shardId, request.nowInMillis(), request.filteringAlias());
                context = this.searchService.createSearchContext(shardSearchLocalRequest, TimeValue.NO_TIMEOUT);
                result = null;
                Term uidTerm = new Term(ParseField.CommonMetaFields.ID_FIELD.getPreferredName(), Uid.encodeId((String)request.id()));
                result = ((IndexShard)context.indexShard()).get(new Engine.Get(false, false, request.id(), uidTerm));
                if (result.exists()) break block7;
                ExplainResponse explainResponse2 = new ExplainResponse(shardId.getIndexName(), request.id(), false);
                Releasables.close((Releasable[])new Releasable[]{result, context});
                return explainResponse2;
            }
            ((SearchContext)context).parsedQuery(context.getQueryShardContext().toQuery(request.query()));
            context.preProcess(true);
            int topLevelDocId = result.docIdAndVersion().docId + result.docIdAndVersion().docBase;
            explanation = context.searcher().explain(context.query(), topLevelDocId);
            for (RescoreContext ctx : context.rescore()) {
                Rescorer rescorer = ctx.rescorer();
                explanation = rescorer.explain(topLevelDocId, (IndexSearcher)context.searcher(), ctx, explanation);
            }
            if (request.storedFields() == null && (request.fetchSourceContext() == null || !request.fetchSourceContext().fetchSource())) break block8;
            GetResult getResult = ((IndexShard)context.indexShard()).getService().get(result, request.id(), request.storedFields(), request.fetchSourceContext());
            ExplainResponse explainResponse3 = new ExplainResponse(shardId.getIndexName(), request.id(), true, explanation, getResult);
            Releasables.close((Releasable[])new Releasable[]{result, context});
            return explainResponse3;
        }
        try {
            explainResponse = new ExplainResponse(shardId.getIndexName(), request.id(), true, explanation);
        }
        catch (IOException e) {
            try {
                throw new SkyliteException("Could not explain", (Throwable)e, new Object[0]);
            }
            catch (Throwable throwable) {
                Releasables.close((Releasable[])new Releasable[]{result, context});
                throw throwable;
            }
        }
        Releasables.close((Releasable[])new Releasable[]{result, context});
        return explainResponse;
    }

    protected Writeable.Reader<ExplainResponse> getResponseReader() {
        return ExplainResponse::new;
    }

    protected ShardIterator shards(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        return this.clusterService.operationRouting().getShards(this.clusterService.state(), request.concreteIndex(), ((ExplainRequest)request.request()).id(), ((ExplainRequest)request.request()).routing(), ((ExplainRequest)request.request()).preference());
    }

    protected String getExecutor(ExplainRequest request, ShardId shardId) {
        IndexService indexService = this.searchService.getIndicesService().indexServiceSafe(shardId.getIndex());
        return indexService.getIndexSettings().isSearchThrottled() ? "search_throttled" : super.getExecutor((SingleShardRequest)request, shardId);
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return ExplainAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportExplainAction.class;
        }
    }
}

