/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.fieldcaps;

import io.lucenia.action.fieldcaps.TransportFieldCapabilitiesIndexAction;
import io.skylite.common.action.ActionListener;
import io.skylite.common.util.concurrent.CountDown;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.IndicesRequest;
import io.skylite.core.action.OriginalIndices;
import io.skylite.core.action.fieldcaps.FieldCapabilities;
import io.skylite.core.action.fieldcaps.FieldCapabilitiesIndexRequest;
import io.skylite.core.action.fieldcaps.FieldCapabilitiesIndexResponse;
import io.skylite.core.action.fieldcaps.FieldCapabilitiesRequest;
import io.skylite.core.action.fieldcaps.FieldCapabilitiesResponse;
import io.skylite.core.action.fieldcaps.IndexFieldCapabilities;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.Strings;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.tasks.Task;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.RemoteClusterService;
import io.skylite.core.transport.RemoteClusterUtils;
import io.skylite.core.transport.TransportService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class TransportFieldCapabilitiesAction
extends HandledTransportAction<FieldCapabilitiesRequest, FieldCapabilitiesResponse> {
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final TransportFieldCapabilitiesIndexAction shardAction;
    private final RemoteClusterService remoteClusterService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    @Inject
    public TransportFieldCapabilitiesAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, TransportFieldCapabilitiesIndexAction shardAction, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:data/read/field_caps", transportService, actionFilters, FieldCapabilitiesRequest::new);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.remoteClusterService = transportService.getRemoteClusterService();
        this.shardAction = shardAction;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }

    protected void doExecute(Task task, FieldCapabilitiesRequest request, ActionListener<FieldCapabilitiesResponse> listener) {
        long nowInMillis = request.nowInMillis() == null ? System.currentTimeMillis() : request.nowInMillis();
        ClusterState clusterState = this.clusterService.state();
        Map remoteClusterIndices = this.remoteClusterService.groupIndices(request.indicesOptions(), request.indices(), idx -> this.indexNameExpressionResolver.hasIndexAbstraction(idx, clusterState));
        OriginalIndices localIndices = (OriginalIndices)remoteClusterIndices.remove("");
        String[] concreteIndices = localIndices == null ? Strings.EMPTY_ARRAY : this.indexNameExpressionResolver.concreteIndexNames(clusterState, (IndicesRequest)localIndices);
        int totalNumRequest = concreteIndices.length + remoteClusterIndices.size();
        CountDown completionCounter = new CountDown(totalNumRequest);
        final List indexResponses = Collections.synchronizedList(new ArrayList());
        final Runnable onResponse = () -> {
            if (completionCounter.countDown()) {
                if (request.isMergeResults()) {
                    listener.onResponse((Object)this.merge(indexResponses, request.includeUnmapped()));
                } else {
                    listener.onResponse((Object)new FieldCapabilitiesResponse(indexResponses));
                }
            }
        };
        if (totalNumRequest == 0) {
            listener.onResponse((Object)new FieldCapabilitiesResponse(new String[0], Collections.emptyMap()));
        } else {
            ActionListener<FieldCapabilitiesIndexResponse> innerListener = new ActionListener<FieldCapabilitiesIndexResponse>(){

                public void onResponse(FieldCapabilitiesIndexResponse result) {
                    if (result.canMatch()) {
                        indexResponses.add(result);
                    }
                    onResponse.run();
                }

                public void onFailure(Exception e) {
                    onResponse.run();
                }
            };
            for (String index : concreteIndices) {
                this.shardAction.execute((ActionRequest)new FieldCapabilitiesIndexRequest(request.fields(), index, localIndices, request.indexFilter(), nowInMillis), (ActionListener)innerListener);
            }
            for (Map.Entry entry : remoteClusterIndices.entrySet()) {
                String clusterAlias = (String)entry.getKey();
                OriginalIndices originalIndices = (OriginalIndices)entry.getValue();
                Client remoteClusterClient = this.remoteClusterService.getRemoteClusterClient(this.threadPool, clusterAlias);
                FieldCapabilitiesRequest remoteRequest = new FieldCapabilitiesRequest();
                remoteRequest.setMergeResults(false);
                remoteRequest.indicesOptions(originalIndices.indicesOptions());
                remoteRequest.indices(originalIndices.indices());
                remoteRequest.fields(request.fields());
                remoteRequest.indexFilter(request.indexFilter());
                remoteRequest.nowInMillis(nowInMillis);
                remoteClusterClient.fieldCaps(remoteRequest, ActionListenerHelper.wrap(response -> {
                    for (FieldCapabilitiesIndexResponse res : response.getIndexResponses()) {
                        indexResponses.add(new FieldCapabilitiesIndexResponse(RemoteClusterUtils.buildRemoteIndexName((String)clusterAlias, (String)res.getIndexName()), res.get(), res.canMatch()));
                    }
                    onResponse.run();
                }, failure -> onResponse.run()));
            }
        }
    }

    private FieldCapabilitiesResponse merge(List<FieldCapabilitiesIndexResponse> indexResponses, boolean includeUnmapped) {
        String[] indices = (String[])indexResponses.stream().map(FieldCapabilitiesIndexResponse::getIndexName).sorted().toArray(String[]::new);
        HashMap<String, Map<String, FieldCapabilities.Builder>> responseMapBuilder = new HashMap<String, Map<String, FieldCapabilities.Builder>>();
        for (FieldCapabilitiesIndexResponse response : indexResponses) {
            this.innerMerge(responseMapBuilder, response.getIndexName(), response.get());
        }
        HashMap responseMap = new HashMap();
        for (Map.Entry entry : responseMapBuilder.entrySet()) {
            Map typeMapBuilder = (Map)entry.getValue();
            if (includeUnmapped) {
                this.addUnmappedFields(indices, (String)entry.getKey(), typeMapBuilder);
            }
            boolean multiTypes = typeMapBuilder.size() > 1;
            HashMap<String, FieldCapabilities> typeMap = new HashMap<String, FieldCapabilities>();
            for (Map.Entry fieldEntry : typeMapBuilder.entrySet()) {
                typeMap.put((String)fieldEntry.getKey(), ((FieldCapabilities.Builder)fieldEntry.getValue()).build(multiTypes));
            }
            responseMap.put((String)entry.getKey(), Collections.unmodifiableMap(typeMap));
        }
        return new FieldCapabilitiesResponse(indices, Collections.unmodifiableMap(responseMap));
    }

    private void addUnmappedFields(String[] indices, String field, Map<String, FieldCapabilities.Builder> typeMap) {
        HashSet unmappedIndices = new HashSet();
        Arrays.stream(indices).forEach(unmappedIndices::add);
        typeMap.values().stream().forEach(b -> b.getIndices().stream().forEach(unmappedIndices::remove));
        if (!unmappedIndices.isEmpty()) {
            FieldCapabilities.Builder unmapped = new FieldCapabilities.Builder(field, "unmapped");
            typeMap.put("unmapped", unmapped);
            for (String index : unmappedIndices) {
                unmapped.add(index, false, false, Collections.emptyMap());
            }
        }
    }

    private void innerMerge(Map<String, Map<String, FieldCapabilities.Builder>> responseMapBuilder, String indexName, Map<String, IndexFieldCapabilities> map) {
        for (Map.Entry<String, IndexFieldCapabilities> entry : map.entrySet()) {
            String field = entry.getKey();
            IndexFieldCapabilities fieldCap = entry.getValue();
            Map typeMap = responseMapBuilder.computeIfAbsent(field, f -> new HashMap());
            FieldCapabilities.Builder builder = typeMap.computeIfAbsent(fieldCap.getType(), key -> new FieldCapabilities.Builder(field, key));
            builder.add(indexName, fieldCap.isSearchable(), fieldCap.isAggregatable(), fieldCap.meta());
        }
    }
}

