/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.ingest;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.ingest.SimulateExecutionService;
import io.skylite.core.action.ingest.SimulatePipelineAction;
import io.skylite.core.action.ingest.SimulatePipelineRequest;
import io.skylite.core.action.ingest.SimulatePipelineResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.ingest.BaseIngestService;
import io.skylite.core.tasks.Task;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.XContentHelper;
import java.util.Map;
import org.opensearch.ingest.IngestService;

public class SimulatePipelineTransportAction
extends HandledTransportAction<SimulatePipelineRequest, SimulatePipelineResponse> {
    private final IngestService ingestService;
    private final SimulateExecutionService executionService;

    @Inject
    public SimulatePipelineTransportAction(ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IngestService ingestService) {
        super("cluster:admin/ingest/pipeline/simulate", transportService, actionFilters, SimulatePipelineRequest::new);
        this.ingestService = ingestService;
        this.executionService = new SimulateExecutionService(threadPool);
    }

    protected void doExecute(Task task, SimulatePipelineRequest request, ActionListener<SimulatePipelineResponse> listener) {
        SimulatePipelineRequest.Parsed simulateRequest;
        Map source = (Map)XContentHelper.convertToMap((BytesReference)request.getSource(), (boolean)false, (MediaType)request.getXContentType()).v2();
        try {
            simulateRequest = request.getId() != null ? SimulatePipelineRequest.parseWithPipelineId((String)request.getId(), (Map)source, (boolean)request.isVerbose(), (BaseIngestService)this.ingestService) : SimulatePipelineRequest.parse((Map)source, (boolean)request.isVerbose(), (BaseIngestService)this.ingestService);
        }
        catch (Exception e) {
            listener.onFailure(e);
            return;
        }
        this.executionService.execute(simulateRequest, listener);
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return SimulatePipelineAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return SimulatePipelineTransportAction.class;
        }
    }
}

