/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.main;

import io.skylite.Build;
import io.skylite.LuceniaVersion;
import io.skylite.OpenSearchVersion;
import io.skylite.Version;
import io.skylite.core.ParseField;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.cluster.ClusterName;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.ObjectParser;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Objects;

public class MainResponse
extends ActionResponse
implements ToXContentObject {
    private String nodeName;
    private Version<?> version;
    private ClusterName clusterName;
    private String clusterUuid;
    private Build build;
    private String versionNumber;
    private String distribution;
    public static final String TAGLINE = "[SEARCH]...on your terms";
    private static final ObjectParser<MainResponse, Void> PARSER = new ObjectParser(MainResponse.class.getName(), true, MainResponse::new);

    MainResponse() {
    }

    MainResponse(StreamInput in) throws IOException {
        super(in);
        this.nodeName = in.readString();
        this.version = in.readVersion();
        this.clusterName = new ClusterName(in);
        this.clusterUuid = in.readString();
        this.build = in.readBuild();
        this.versionNumber = this.build.getQualifiedVersion();
        this.distribution = this.build.getDistribution();
    }

    public MainResponse(String nodeName, Version<?> version, ClusterName clusterName, String clusterUuid, Build build) {
        this.nodeName = nodeName;
        this.version = version;
        this.clusterName = clusterName;
        this.clusterUuid = clusterUuid;
        this.build = build;
        this.versionNumber = build.getQualifiedVersion();
        this.distribution = build.getDistribution();
    }

    public MainResponse(String nodeName, Version<?> version, ClusterName clusterName, String clusterUuid, Build build, String versionNumber, String distribution) {
        this.nodeName = nodeName;
        this.version = version;
        this.clusterName = clusterName;
        this.clusterUuid = clusterUuid;
        this.build = build;
        this.versionNumber = versionNumber;
        this.distribution = distribution;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public Version<?> getVersion() {
        return this.version;
    }

    public ClusterName getClusterName() {
        return this.clusterName;
    }

    public String getClusterUuid() {
        return this.clusterUuid;
    }

    public Build getBuild() {
        return this.build;
    }

    public String getVersionNumber() {
        return this.versionNumber;
    }

    public String getDistribution() {
        return this.distribution;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.nodeName);
        if (out.getVersion().before((Version)LuceniaVersion.V_0_1_0)) {
            out.writeVersion((Version)OpenSearchVersion.V_2_14_0);
        } else {
            out.writeVersion(this.version);
        }
        this.clusterName.writeTo(out);
        out.writeString(this.clusterUuid);
        out.writeBuild(this.build);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("name", this.nodeName);
        builder.field("cluster_name", this.clusterName.value());
        builder.field("cluster_uuid", this.clusterUuid);
        builder.startObject("version").field("distribution", this.build.getDistribution()).field("number", this.versionNumber).field("build_type", this.build.type().displayName()).field("build_hash", this.build.hash()).field("build_date", this.build.date()).field("build_snapshot", this.build.isSnapshot()).field("lucene_version", this.version.luceneVersion.toString()).field("minimum_wire_compatibility_version", this.version.minimumWireCompatibilityVersion().toString()).field("minimum_index_compatibility_version", this.version.minimumIndexCompatibilityVersion().toString()).endObject();
        builder.field("tagline", TAGLINE);
        builder.endObject();
        return builder;
    }

    public static MainResponse fromXContent(XContentParser parser) {
        return (MainResponse)((Object)PARSER.apply(parser, null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        MainResponse other = (MainResponse)((Object)o);
        return Objects.equals(this.nodeName, other.nodeName) && Objects.equals(this.version, other.version) && Objects.equals(this.clusterUuid, other.clusterUuid) && Objects.equals(this.build, other.build) && Objects.equals(this.clusterName, other.clusterName);
    }

    public int hashCode() {
        return Objects.hash(this.nodeName, this.version, this.clusterUuid, this.build, this.clusterName);
    }

    public String toString() {
        return "MainResponse{nodeName='" + this.nodeName + "', version=" + String.valueOf(this.version) + ", clusterName=" + String.valueOf(this.clusterName) + ", clusterUuid='" + this.clusterUuid + "', build=" + String.valueOf(this.build) + "}";
    }

    static {
        PARSER.declareString((response, value) -> {
            response.nodeName = value;
        }, new ParseField("name", new String[0]));
        PARSER.declareString((response, value) -> {
            response.clusterName = new ClusterName(value);
        }, new ParseField("cluster_name", new String[0]));
        PARSER.declareString((response, value) -> {
            response.clusterUuid = value;
        }, new ParseField("cluster_uuid", new String[0]));
        PARSER.declareString((response, value) -> {}, new ParseField("tagline", new String[0]));
        PARSER.declareObject((response, value) -> {
            String buildType = (String)value.get("build_type");
            response.build = new Build(buildType == null ? Build.Type.UNKNOWN : Build.Type.fromDisplayName((String)buildType, (boolean)false), (String)value.get("build_hash"), (String)value.get("build_date"), ((Boolean)value.get("build_snapshot")).booleanValue(), (String)value.get("number"), (String)value.get("distribution"));
            response.version = Version.fromString((String)((String)value.get("number")).replace("-SNAPSHOT", "").replaceFirst("-(alpha\\d+|beta\\d+|rc\\d+)", ""));
            response.versionNumber = response.version.toString();
            response.distribution = response.build.getDistribution();
        }, (parser, context) -> parser.map(), new ParseField("version", new String[0]));
    }
}

