/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.main;

import io.lucenia.action.main.MainAction;
import io.lucenia.action.main.MainActionSettings;
import io.lucenia.action.main.MainResponse;
import io.skylite.Build;
import io.skylite.Version;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.main.MainRequest;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.settings.CommonSettings;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;

public class TransportMainAction
extends HandledTransportAction<MainRequest, MainResponse> {
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(TransportMainAction.class);
    public static final String OVERRIDE_MAIN_RESPONSE_DEPRECATION_MESSAGE = "overriding main response will be removed in a future version";
    private final String nodeName;
    private final ClusterService clusterService;
    private volatile String responseVersion;
    private volatile String responseDistribution;

    @Inject
    public TransportMainAction(Settings settings, TransportService transportService, ActionFilters actionFilters, ClusterService clusterService) {
        super("cluster:monitor/main", transportService, actionFilters, MainRequest::new);
        this.nodeName = (String)CommonSettings.NODE_NAME_SETTING.get(settings);
        this.clusterService = clusterService;
        this.responseVersion = (String)MainActionSettings.OVERRIDE_MAIN_RESPONSE_VERSION.get(settings);
        this.responseDistribution = (String)MainActionSettings.OVERRIDE_MAIN_RESPONSE_DISTRIBUTION.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MainActionSettings.OVERRIDE_MAIN_RESPONSE_VERSION, this::setResponseVersion);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MainActionSettings.OVERRIDE_MAIN_RESPONSE_DISTRIBUTION, this::setResponseDistribution);
    }

    private void setResponseVersion(String responseVersion) {
        if (responseVersion != null && !responseVersion.equals(Build.CURRENT.getQualifiedVersion())) {
            DEPRECATION_LOGGER.deprecate(MainActionSettings.OVERRIDE_MAIN_RESPONSE_VERSION.getKey(), OVERRIDE_MAIN_RESPONSE_DEPRECATION_MESSAGE, new Object[0]);
            this.responseVersion = responseVersion;
        } else {
            this.responseVersion = Build.CURRENT.getQualifiedVersion();
        }
    }

    private void setResponseDistribution(String responseDistribution) {
        if (responseDistribution != null && !responseDistribution.equals(Build.CURRENT.getDistribution())) {
            DEPRECATION_LOGGER.deprecate(MainActionSettings.OVERRIDE_MAIN_RESPONSE_DISTRIBUTION.getKey(), OVERRIDE_MAIN_RESPONSE_DEPRECATION_MESSAGE, new Object[0]);
            this.responseDistribution = responseDistribution;
        } else {
            this.responseDistribution = Build.CURRENT.getDistribution();
        }
    }

    protected void doExecute(Task task, MainRequest request, ActionListener<MainResponse> listener) {
        ClusterState clusterState = this.clusterService.state();
        listener.onResponse((Object)new MainResponse(this.nodeName, this.responseVersion.equals(Version.CURRENT.toString()) ? Version.CURRENT : Version.fromString((String)this.responseVersion), clusterState.getClusterName(), clusterState.metadata().clusterUUID(), new Build(Build.CURRENT.type(), Build.CURRENT.hash(), Build.CURRENT.date(), Build.CURRENT.isSnapshot(), this.responseVersion, this.responseDistribution), this.responseVersion, this.responseDistribution));
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return MainAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportMainAction.class;
        }
    }
}

