/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.pagination;

import io.lucenia.action.pagination.IndexPaginationStrategy;
import io.lucenia.action.pagination.PageParams;
import io.lucenia.action.pagination.PageToken;
import io.lucenia.action.pagination.PaginationStrategy;
import io.skylite.SkyliteParseException;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.routing.IndexRoutingTable;
import io.skylite.core.cluster.routing.IndexShardRoutingTable;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.state.ClusterState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ShardPaginationStrategy
implements PaginationStrategy<ShardRouting> {
    private static final String DEFAULT_SHARDS_PAGINATED_ENTITY = "shards";
    private PageData pageData;

    public ShardPaginationStrategy(PageParams pageParams, ClusterState clusterState) {
        this(pageParams, clusterState, new int[0]);
    }

    public ShardPaginationStrategy(PageParams pageParams, ClusterState clusterState, int[] shardIDs) {
        ShardStrategyToken shardStrategyToken = this.getShardStrategyToken(pageParams.getRequestedToken());
        List<IndexMetadata> filteredIndices = ShardPaginationStrategy.getEligibleIndices(clusterState, pageParams.getSort(), Objects.isNull(shardStrategyToken) ? null : shardStrategyToken.lastIndexName, Objects.isNull(shardStrategyToken) ? null : Long.valueOf(shardStrategyToken.lastIndexCreationTime));
        this.pageData = this.getPageData(filteredIndices, clusterState.getRoutingTable().getIndicesRouting(), shardStrategyToken, pageParams.getSize(), shardIDs);
    }

    private static List<IndexMetadata> getEligibleIndices(ClusterState clusterState, String sortOrder, String lastIndexName, Long lastIndexCreationTime) {
        if (Objects.isNull(lastIndexName) || Objects.isNull(lastIndexCreationTime)) {
            return PaginationStrategy.getSortedIndexMetadata(clusterState, "asc".equals(sortOrder) ? IndexPaginationStrategy.ASC_COMPARATOR : IndexPaginationStrategy.DESC_COMPARATOR);
        }
        return PaginationStrategy.getSortedIndexMetadata(clusterState, ShardPaginationStrategy.getMetadataFilter(sortOrder, lastIndexName, lastIndexCreationTime), "asc".equals(sortOrder) ? IndexPaginationStrategy.ASC_COMPARATOR : IndexPaginationStrategy.DESC_COMPARATOR);
    }

    private static Predicate<IndexMetadata> getMetadataFilter(String sortOrder, String lastIndexName, Long lastIndexCreationTime) {
        if (Objects.isNull(lastIndexName) || Objects.isNull(lastIndexCreationTime)) {
            return indexMetadata -> true;
        }
        return ShardPaginationStrategy.indexNameFilter(lastIndexName).or(IndexPaginationStrategy.getIndexCreateTimeFilter(sortOrder, lastIndexName, lastIndexCreationTime));
    }

    private static Predicate<IndexMetadata> indexNameFilter(String lastIndexName) {
        return metadata -> metadata.getIndex().getName().equals(lastIndexName);
    }

    private PageData getPageData(List<IndexMetadata> filteredIndices, Map<String, IndexRoutingTable> indicesRouting, ShardStrategyToken token, int numShardsRequired, int[] shardIDs) {
        ArrayList<ShardRouting> shardRoutings = new ArrayList<ShardRouting>();
        ArrayList<String> indices = new ArrayList<String>();
        Set shardIdSet = Arrays.stream(shardIDs).boxed().collect(Collectors.toSet());
        int shardCount = 0;
        IndexMetadata lastAddedIndex = null;
        for (IndexMetadata indexMetadata : filteredIndices) {
            String indexName = indexMetadata.getIndex().getName();
            boolean indexShardsAdded = false;
            Map indexShardRoutingTable = indicesRouting.get(indexName).getShards();
            for (int startShardId = shardCount == 0 ? this.getStartShardIdForPageIndex(token, indexName, indexMetadata.getCreationDate()) : 0; startShardId < indexShardRoutingTable.size(); ++startShardId) {
                if (!shardIdSet.isEmpty() && !shardIdSet.contains(startShardId)) continue;
                if (((IndexShardRoutingTable)indexShardRoutingTable.get(startShardId)).size() > numShardsRequired) {
                    throw new IllegalArgumentException("size value should be greater than the replica count of all indices, so that all primary and replicas of a shard show up in single page");
                }
                if ((shardCount += ((IndexShardRoutingTable)indexShardRoutingTable.get(startShardId)).size()) > numShardsRequired) break;
                shardRoutings.addAll(((IndexShardRoutingTable)indexShardRoutingTable.get(startShardId)).shards());
                indexShardsAdded = true;
            }
            if (indexShardsAdded) {
                lastAddedIndex = indexMetadata;
                indices.add(indexName);
            }
            if (shardCount <= numShardsRequired) continue;
            return new PageData(shardRoutings, indices, new PageToken(new ShardStrategyToken(lastAddedIndex.getIndex().getName(), ((ShardRouting)shardRoutings.get(shardRoutings.size() - 1)).id(), lastAddedIndex.getCreationDate()).generateEncryptedToken(), DEFAULT_SHARDS_PAGINATED_ENTITY));
        }
        return new PageData(shardRoutings, indices, new PageToken(null, DEFAULT_SHARDS_PAGINATED_ENTITY));
    }

    private ShardStrategyToken getShardStrategyToken(String requestedToken) {
        return Objects.isNull(requestedToken) || requestedToken.isEmpty() ? null : new ShardStrategyToken(requestedToken);
    }

    private int getStartShardIdForPageIndex(ShardStrategyToken token, String pageIndexName, long pageIndexCreationTime) {
        return Objects.isNull(token) ? 0 : (token.lastIndexName.equals(pageIndexName) && token.lastIndexCreationTime == pageIndexCreationTime ? token.lastShardId + 1 : 0);
    }

    @Override
    public PageToken getResponseToken() {
        return this.pageData.pageToken;
    }

    @Override
    public List<ShardRouting> getRequestedEntities() {
        return this.pageData.shardRoutings;
    }

    public List<String> getRequestedIndices() {
        return this.pageData.indices;
    }

    public static class ShardStrategyToken {
        private static final String JOIN_DELIMITER = "|";
        private static final String SPLIT_REGEX = "\\|";
        private static final int SHARD_ID_POS_IN_TOKEN = 0;
        private static final int CREATE_TIME_POS_IN_TOKEN = 1;
        private static final int INDEX_NAME_POS_IN_TOKEN = 2;
        private final int lastShardId;
        private final long lastIndexCreationTime;
        private final String lastIndexName;

        public ShardStrategyToken(String requestedTokenString) {
            ShardStrategyToken.validateShardStrategyToken(requestedTokenString);
            String decryptedToken = PaginationStrategy.decryptStringToken(requestedTokenString);
            String[] decryptedTokenElements = decryptedToken.split(SPLIT_REGEX);
            this.lastShardId = Integer.parseInt(decryptedTokenElements[0]);
            this.lastIndexCreationTime = Long.parseLong(decryptedTokenElements[1]);
            this.lastIndexName = decryptedTokenElements[2];
        }

        public ShardStrategyToken(String lastIndexName, int lastShardId, long lastIndexCreationTime) {
            Objects.requireNonNull(lastIndexName, "index name should be provided");
            this.lastIndexName = lastIndexName;
            this.lastShardId = lastShardId;
            this.lastIndexCreationTime = lastIndexCreationTime;
        }

        public String generateEncryptedToken() {
            return PaginationStrategy.encryptStringToken(String.join((CharSequence)JOIN_DELIMITER, String.valueOf(this.lastShardId), String.valueOf(this.lastIndexCreationTime), this.lastIndexName));
        }

        public static void validateShardStrategyToken(String requestedTokenStr) {
            Objects.requireNonNull(requestedTokenStr, "requestedTokenString can not be null");
            String decryptedToken = PaginationStrategy.decryptStringToken(requestedTokenStr);
            String[] decryptedTokenElements = decryptedToken.split(SPLIT_REGEX);
            if (decryptedTokenElements.length != 3) {
                throw new SkyliteParseException("Parameter [next_token] has been tainted and is incorrect. Please provide a valid [next_token].", new Object[0]);
            }
            try {
                int shardId = Integer.parseInt(decryptedTokenElements[0]);
                long creationTimeOfLastRespondedIndex = Long.parseLong(decryptedTokenElements[1]);
                if (shardId < 0 || creationTimeOfLastRespondedIndex <= 0L) {
                    throw new SkyliteParseException("Parameter [next_token] has been tainted and is incorrect. Please provide a valid [next_token].", new Object[0]);
                }
            }
            catch (NumberFormatException exception) {
                throw new SkyliteParseException("Parameter [next_token] has been tainted and is incorrect. Please provide a valid [next_token].", new Object[0]);
            }
        }
    }

    private static class PageData {
        private final List<ShardRouting> shardRoutings;
        private final List<String> indices;
        private final PageToken pageToken;

        PageData(List<ShardRouting> shardRoutings, List<String> indices, PageToken pageToken) {
            this.shardRoutings = shardRoutings;
            this.indices = indices;
            this.pageToken = pageToken;
        }
    }
}

