/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.search;

import io.skylite.common.Nullable;
import io.skylite.common.action.ActionListener;
import io.skylite.common.util.concurrent.CountDown;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.search.ParsedScrollId;
import io.skylite.core.action.search.ReduceSearchPhaseException;
import io.skylite.core.action.search.SearchActionListener;
import io.skylite.core.action.search.SearchContextIdForNode;
import io.skylite.core.action.search.SearchPhase;
import io.skylite.core.action.search.SearchPhaseExecutionException;
import io.skylite.core.action.search.SearchPhaseName;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.action.search.SearchResponseSections;
import io.skylite.core.action.search.SearchScrollRequest;
import io.skylite.core.action.search.SearchTransportService;
import io.skylite.core.action.search.ShardSearchFailure;
import io.skylite.core.action.search.TransportSearchHelper;
import io.skylite.core.action.search.phase.SearchPhaseController;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.node.DiscoveryNodes;
import io.skylite.core.common.concurrent.AtomicArray;
import io.skylite.core.search.SearchPhaseResult;
import io.skylite.core.search.SearchShardTarget;
import io.skylite.core.search.internal.InternalScrollSearchRequest;
import io.skylite.core.search.internal.InternalSearchResponse;
import io.skylite.core.search.internal.ShardSearchContextId;
import io.skylite.core.transport.RemoteClusterService;
import io.skylite.core.transport.TransportConnection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;

abstract class SearchScrollAsyncAction<T extends SearchPhaseResult>
implements Runnable {
    protected final Logger logger;
    protected final ActionListener<SearchResponse> listener;
    protected final ParsedScrollId scrollId;
    protected final DiscoveryNodes nodes;
    protected final SearchPhaseController searchPhaseController;
    protected final SearchScrollRequest request;
    protected final SearchTransportService searchTransportService;
    private final long startTime;
    private final List<ShardSearchFailure> shardFailures = new ArrayList<ShardSearchFailure>();
    private final AtomicInteger successfulOps;

    protected SearchScrollAsyncAction(ParsedScrollId scrollId, Logger logger, DiscoveryNodes nodes, ActionListener<SearchResponse> listener, SearchPhaseController searchPhaseController, SearchScrollRequest request, SearchTransportService searchTransportService) {
        this.startTime = System.currentTimeMillis();
        this.scrollId = scrollId;
        this.successfulOps = new AtomicInteger(scrollId.getContext().length);
        this.logger = logger;
        this.listener = listener;
        this.nodes = nodes;
        this.searchPhaseController = searchPhaseController;
        this.request = request;
        this.searchTransportService = searchTransportService;
    }

    private long buildTookInMillis() {
        return Math.max(1L, System.currentTimeMillis() - this.startTime);
    }

    @Override
    public final void run() {
        SearchContextIdForNode[] context = this.scrollId.getContext();
        if (context.length == 0) {
            this.listener.onFailure((Exception)new SearchPhaseExecutionException("query", "no nodes to search on", ShardSearchFailure.EMPTY_ARRAY));
        } else {
            SearchScrollAsyncAction.collectNodesAndRun(Arrays.asList(context), this.nodes, this.searchTransportService, (ActionListener<BiFunction<String, String, DiscoveryNode>>)ActionListenerHelper.wrap(lookup -> this.run((BiFunction<String, String, DiscoveryNode>)lookup, context), arg_0 -> this.listener.onFailure(arg_0)));
        }
    }

    static void collectNodesAndRun(Iterable<SearchContextIdForNode> scrollIds, DiscoveryNodes nodes, SearchTransportService searchTransportService, ActionListener<BiFunction<String, String, DiscoveryNode>> listener) {
        HashSet<String> clusters = new HashSet<String>();
        for (SearchContextIdForNode target : scrollIds) {
            if (target.getClusterAlias() == null) continue;
            clusters.add(target.getClusterAlias());
        }
        if (clusters.isEmpty()) {
            listener.onResponse((cluster, node) -> nodes.get(node));
        } else {
            RemoteClusterService remoteClusterService = searchTransportService.getRemoteClusterService();
            remoteClusterService.collectNodes(clusters, ActionListenerHelper.map(listener, nodeFunction -> (clusterAlias, node) -> clusterAlias == null ? nodes.get(node) : (DiscoveryNode)nodeFunction.apply(clusterAlias, node)));
        }
    }

    private void run(final BiFunction<String, String, DiscoveryNode> clusterNodeLookup, SearchContextIdForNode[] context) {
        final CountDown counter = new CountDown(this.scrollId.getContext().length);
        for (int i = 0; i < context.length; ++i) {
            TransportConnection connection;
            final SearchContextIdForNode target = context[i];
            final int shardIndex = i;
            try {
                DiscoveryNode node = clusterNodeLookup.apply(target.getClusterAlias(), target.getNode());
                if (node == null) {
                    throw new IllegalStateException("node [" + target.getNode() + "] is not available");
                }
                connection = this.getConnection(target.getClusterAlias(), node);
            }
            catch (Exception ex) {
                this.onShardFailure("query", counter, target.getSearchContextId(), ex, null, () -> this.moveToNextPhase(clusterNodeLookup));
                continue;
            }
            InternalScrollSearchRequest internalRequest = TransportSearchHelper.internalScrollSearchRequest((ShardSearchContextId)target.getSearchContextId(), (SearchScrollRequest)this.request);
            SearchActionListener searchActionListener = new SearchActionListener<T>(null, shardIndex){

                protected void setSearchShardTarget(T response) {
                    assert (response.getSearchShardTarget() != null) : "search shard target must not be null";
                    if (target.getClusterAlias() != null) {
                        SearchShardTarget searchShardTarget = response.getSearchShardTarget();
                        response.setSearchShardTarget(new SearchShardTarget(searchShardTarget.getNodeId(), searchShardTarget.getShardId(), target.getClusterAlias(), null));
                    }
                }

                protected void innerOnResponse(T result) {
                    assert (shardIndex == result.getShardIndex()) : "shard index mismatch: " + shardIndex + " but got: " + result.getShardIndex();
                    SearchScrollAsyncAction.this.onFirstPhaseResult(shardIndex, result);
                    if (counter.countDown()) {
                        SearchPhase phase = SearchScrollAsyncAction.this.moveToNextPhase(clusterNodeLookup);
                        try {
                            phase.run();
                        }
                        catch (Exception e) {
                            SearchScrollAsyncAction.this.listener.onFailure((Exception)new SearchPhaseExecutionException(phase.getName(), "Phase failed", (Throwable)e, ShardSearchFailure.EMPTY_ARRAY));
                        }
                    }
                }

                public void onFailure(Exception t) {
                    SearchScrollAsyncAction.this.onShardFailure("query", counter, target.getSearchContextId(), t, null, () -> SearchScrollAsyncAction.this.moveToNextPhase(clusterNodeLookup));
                }
            };
            this.executeInitialPhase(connection, internalRequest, searchActionListener);
        }
    }

    synchronized ShardSearchFailure[] buildShardFailures() {
        if (this.shardFailures.isEmpty()) {
            return ShardSearchFailure.EMPTY_ARRAY;
        }
        return this.shardFailures.toArray(new ShardSearchFailure[0]);
    }

    private synchronized void addShardFailure(ShardSearchFailure failure) {
        this.shardFailures.add(failure);
    }

    protected abstract void executeInitialPhase(TransportConnection var1, InternalScrollSearchRequest var2, SearchActionListener<T> var3);

    protected abstract SearchPhase moveToNextPhase(BiFunction<String, String, DiscoveryNode> var1);

    protected abstract void onFirstPhaseResult(int var1, T var2);

    protected SearchPhase sendResponsePhase(final SearchPhaseController.ReducedQueryPhase queryPhase, final AtomicArray<? extends SearchPhaseResult> fetchResults) {
        return new SearchPhase(SearchPhaseName.FETCH.getName()){

            public void run() throws IOException {
                SearchScrollAsyncAction.this.sendResponse(queryPhase, (AtomicArray<SearchPhaseResult>)fetchResults);
            }
        };
    }

    protected final void sendResponse(SearchPhaseController.ReducedQueryPhase queryPhase, AtomicArray<? extends SearchPhaseResult> fetchResults) {
        try {
            InternalSearchResponse internalResponse = this.searchPhaseController.merge(true, queryPhase, (Collection)fetchResults.asList(), arg_0 -> fetchResults.get(arg_0));
            String scrollId = null;
            if (this.request.scroll() != null) {
                scrollId = this.request.scrollId();
            }
            this.listener.onResponse((Object)new SearchResponse((SearchResponseSections)internalResponse, scrollId, this.scrollId.getContext().length, this.successfulOps.get(), 0, this.buildTookInMillis(), this.buildShardFailures(), SearchResponse.Clusters.EMPTY, null));
        }
        catch (Exception e) {
            this.listener.onFailure((Exception)new ReduceSearchPhaseException("fetch", "inner finish failed", (Throwable)e, this.buildShardFailures()));
        }
    }

    protected void onShardFailure(String phaseName, CountDown counter, ShardSearchContextId searchId, Exception failure, @Nullable SearchShardTarget searchShardTarget, Supplier<SearchPhase> nextPhaseSupplier) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Message)new ParameterizedMessage("[{}] Failed to execute {} phase", (Object)searchId, (Object)phaseName), (Throwable)failure);
        }
        this.addShardFailure(new ShardSearchFailure(failure, searchShardTarget));
        int successfulOperations = this.successfulOps.decrementAndGet();
        assert (successfulOperations >= 0) : "successfulOperations must be >= 0 but was: " + successfulOperations;
        if (counter.countDown()) {
            if (this.successfulOps.get() == 0) {
                this.listener.onFailure((Exception)new SearchPhaseExecutionException(phaseName, "all shards failed", (Throwable)failure, this.buildShardFailures()));
            } else {
                SearchPhase phase = nextPhaseSupplier.get();
                try {
                    phase.run();
                }
                catch (Exception e) {
                    e.addSuppressed(failure);
                    this.listener.onFailure((Exception)new SearchPhaseExecutionException(phase.getName(), "Phase failed", (Throwable)e, ShardSearchFailure.EMPTY_ARRAY));
                }
            }
        }
    }

    protected TransportConnection getConnection(String clusterAlias, DiscoveryNode node) {
        return this.searchTransportService.getConnection(clusterAlias, node);
    }
}

