/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.search;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.search.MultiSearchAction;
import io.skylite.core.action.search.MultiSearchRequest;
import io.skylite.core.action.search.MultiSearchResponse;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.concurrent.AtomicArray;
import io.skylite.core.common.concurrent.SkyliteExecutors;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.LongSupplier;

public class TransportMultiSearchAction
extends HandledTransportAction<MultiSearchRequest, MultiSearchResponse> {
    private final int allocatedProcessors;
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final LongSupplier relativeTimeProvider;
    private final NodeClient client;

    @Inject
    public TransportMultiSearchAction(Settings settings, ThreadPool threadPool, TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, NodeClient client) {
        super("indices:data/read/msearch", transportService, actionFilters, MultiSearchRequest::new);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.allocatedProcessors = SkyliteExecutors.allocatedProcessors((Settings)settings);
        this.relativeTimeProvider = System::nanoTime;
        this.client = client;
    }

    TransportMultiSearchAction(ThreadPool threadPool, ActionFilters actionFilters, TransportService transportService, ClusterService clusterService, int allocatedProcessors, LongSupplier relativeTimeProvider, NodeClient client) {
        super("indices:data/read/msearch", transportService, actionFilters, MultiSearchRequest::new);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.allocatedProcessors = allocatedProcessors;
        this.relativeTimeProvider = relativeTimeProvider;
        this.client = client;
    }

    protected void doExecute(Task task, MultiSearchRequest request, ActionListener<MultiSearchResponse> listener) {
        long relativeStartTime = this.relativeTimeProvider.getAsLong();
        ClusterState clusterState = this.clusterService.state();
        clusterState.blocks().globalBlockedRaiseException(ClusterBlockLevel.READ);
        int maxConcurrentSearches = request.maxConcurrentSearchRequests();
        if (maxConcurrentSearches == 0) {
            maxConcurrentSearches = TransportMultiSearchAction.defaultMaxConcurrentSearches(this.allocatedProcessors, clusterState);
        }
        ConcurrentLinkedQueue<SearchRequestSlot> searchRequestSlots = new ConcurrentLinkedQueue<SearchRequestSlot>();
        for (int i = 0; i < request.requests().size(); ++i) {
            SearchRequest searchRequest = (SearchRequest)request.requests().get(i);
            searchRequest.setParentTask(this.client.getLocalNodeId(), task.getId());
            searchRequestSlots.add(new SearchRequestSlot(searchRequest, i));
        }
        int numRequests = request.requests().size();
        AtomicArray responses = new AtomicArray(numRequests);
        AtomicInteger responseCounter = new AtomicInteger(numRequests);
        int numConcurrentSearches = Math.min(numRequests, maxConcurrentSearches);
        for (int i = 0; i < numConcurrentSearches; ++i) {
            this.executeSearch(searchRequestSlots, (AtomicArray<MultiSearchResponse.Item>)responses, responseCounter, listener, relativeStartTime);
        }
    }

    static int defaultMaxConcurrentSearches(int allocatedProcessors, ClusterState state) {
        int numDateNodes = state.getNodes().getDataNodes().size();
        int defaultSearchThreadPoolSize = Math.min(ThreadPool.searchThreadPoolSize((int)allocatedProcessors), 10);
        return Math.max(1, numDateNodes * defaultSearchThreadPoolSize);
    }

    void executeSearch(final Queue<SearchRequestSlot> requests, final AtomicArray<MultiSearchResponse.Item> responses, final AtomicInteger responseCounter, final ActionListener<MultiSearchResponse> listener, final long relativeStartTime) {
        final SearchRequestSlot request = requests.poll();
        if (request == null) {
            return;
        }
        final Thread thread = Thread.currentThread();
        this.client.search(request.request, (ActionListener)new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse searchResponse) {
                this.handleResponse(request.responseSlot, new MultiSearchResponse.Item(searchResponse, null));
            }

            public void onFailure(Exception e) {
                this.handleResponse(request.responseSlot, new MultiSearchResponse.Item(null, e));
            }

            private void handleResponse(int responseSlot, MultiSearchResponse.Item item) {
                responses.set(responseSlot, (Object)item);
                if (responseCounter.decrementAndGet() == 0) {
                    assert (requests.isEmpty());
                    this.finish();
                } else if (thread == Thread.currentThread()) {
                    TransportMultiSearchAction.this.threadPool.generic().execute(() -> TransportMultiSearchAction.this.executeSearch(requests, (AtomicArray<MultiSearchResponse.Item>)responses, responseCounter, (ActionListener<MultiSearchResponse>)listener, relativeStartTime));
                } else {
                    TransportMultiSearchAction.this.executeSearch(requests, (AtomicArray<MultiSearchResponse.Item>)responses, responseCounter, (ActionListener<MultiSearchResponse>)listener, relativeStartTime);
                }
            }

            private void finish() {
                listener.onResponse((Object)new MultiSearchResponse((MultiSearchResponse.Item[])responses.toArray((Object[])new MultiSearchResponse.Item[responses.length()]), this.buildTookInMillis()));
            }

            private long buildTookInMillis() {
                return TimeUnit.NANOSECONDS.toMillis(TransportMultiSearchAction.this.relativeTimeProvider.getAsLong() - relativeStartTime);
            }
        });
    }

    static final class SearchRequestSlot {
        final SearchRequest request;
        final int responseSlot;

        SearchRequestSlot(SearchRequest request, int responseSlot) {
            this.request = request;
            this.responseSlot = responseSlot;
        }
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return MultiSearchAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportMultiSearchAction.class;
        }
    }
}

