/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.search;

import io.lucenia.action.search.SearchScrollQueryAndFetchAsyncAction;
import io.lucenia.action.search.SearchScrollQueryThenFetchAsyncAction;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.search.ParsedScrollId;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.action.search.SearchScrollAction;
import io.skylite.core.action.search.SearchScrollRequest;
import io.skylite.core.action.search.SearchTask;
import io.skylite.core.action.search.SearchTransportService;
import io.skylite.core.action.search.TransportSearchHelper;
import io.skylite.core.action.search.phase.SearchPhaseController;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;

public class TransportSearchScrollAction
extends HandledTransportAction<SearchScrollRequest, SearchResponse> {
    private final ClusterService clusterService;
    private final SearchTransportService searchTransportService;
    private final SearchPhaseController searchPhaseController;

    @Inject
    public TransportSearchScrollAction(TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, SearchTransportService searchTransportService, SearchPhaseController searchPhaseController) {
        super("indices:data/read/scroll", transportService, actionFilters, SearchScrollRequest::new);
        this.clusterService = clusterService;
        this.searchTransportService = searchTransportService;
        this.searchPhaseController = searchPhaseController;
    }

    protected void doExecute(Task task, SearchScrollRequest request, ActionListener<SearchResponse> listener) {
        try {
            ParsedScrollId scrollId = TransportSearchHelper.parseScrollId((String)request.scrollId());
            (switch (scrollId.getType()) {
                case "queryThenFetch" -> new SearchScrollQueryThenFetchAsyncAction(this.logger, this.clusterService, this.searchTransportService, this.searchPhaseController, request, (SearchTask)task, scrollId, listener);
                case "queryAndFetch" -> new SearchScrollQueryAndFetchAsyncAction(this.logger, this.clusterService, this.searchTransportService, this.searchPhaseController, request, (SearchTask)task, scrollId, listener);
                default -> throw new IllegalArgumentException("Scroll id type [" + scrollId.getType() + "] unrecognized");
            }).run();
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return SearchScrollAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportSearchScrollAction.class;
        }
    }
}

