/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.support;

import io.skylite.common.Booleans;
import io.skylite.common.collect.Tuple;
import io.skylite.core.cluster.metadata.ComposableIndexTemplate;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.metadata.MetadataIndexTemplateUtility;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.Strings;
import io.skylite.core.common.regex.Regex;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.indices.SystemIndices;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.MapperSettings;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.spi.SettingsProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class AutoCreateIndex {
    public static final Setting<AutoCreate> AUTO_CREATE_INDEX_SETTING = new Setting("action.auto_create_index", "true", AutoCreate::new, new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private final boolean dynamicMappingDisabled;
    private final IndexNameExpressionResolver resolver;
    private final SystemIndices systemIndices;
    private volatile AutoCreate autoCreate;

    public AutoCreateIndex(Settings settings, ClusterSettings clusterSettings, IndexNameExpressionResolver resolver, SystemIndices systemIndices) {
        this.resolver = resolver;
        this.dynamicMappingDisabled = (Boolean)MapperSettings.INDEX_MAPPER_DYNAMIC_SETTING.get(settings) == false;
        this.systemIndices = systemIndices;
        this.autoCreate = (AutoCreate)AUTO_CREATE_INDEX_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(AUTO_CREATE_INDEX_SETTING, this::setAutoCreate);
    }

    public boolean shouldAutoCreate(String index, ClusterState state) {
        if (this.resolver.hasIndexAbstraction(index, state)) {
            return false;
        }
        if (this.systemIndices.isSystemIndex(index)) {
            return true;
        }
        ComposableIndexTemplate template = this.findTemplate(index, state.metadata());
        if (template != null && template.getAllowAutoCreate() != null) {
            if (template.getAllowAutoCreate().booleanValue()) {
                return true;
            }
            throw new IndexNotFoundException("composable template " + String.valueOf(template.indexPatterns()) + " forbids index auto creation");
        }
        AutoCreate autoCreate = this.autoCreate;
        if (!autoCreate.autoCreateIndex) {
            throw new IndexNotFoundException("[" + AUTO_CREATE_INDEX_SETTING.getKey() + "] is [false]", index);
        }
        if (this.dynamicMappingDisabled) {
            throw new IndexNotFoundException("[" + MapperSettings.INDEX_MAPPER_DYNAMIC_SETTING.getKey() + "] is [false]", index);
        }
        if (autoCreate.expressions.isEmpty()) {
            return true;
        }
        for (Tuple<String, Boolean> expression : autoCreate.expressions) {
            String indexExpression = (String)expression.v1();
            boolean include = (Boolean)expression.v2();
            if (!Regex.simpleMatch((String)indexExpression, (String)index)) continue;
            if (include) {
                return true;
            }
            throw new IndexNotFoundException("[" + AUTO_CREATE_INDEX_SETTING.getKey() + "] contains [-" + indexExpression + "] which forbids automatic creation of the index", index);
        }
        throw new IndexNotFoundException("[" + AUTO_CREATE_INDEX_SETTING.getKey() + "] ([" + String.valueOf(autoCreate) + "]) doesn't match", index);
    }

    AutoCreate getAutoCreate() {
        return this.autoCreate;
    }

    void setAutoCreate(AutoCreate autoCreate) {
        this.autoCreate = autoCreate;
    }

    private ComposableIndexTemplate findTemplate(String indexName, Metadata metadata) {
        String templateName = MetadataIndexTemplateUtility.findV2Template((Metadata)metadata, (String)indexName, (boolean)false);
        return (ComposableIndexTemplate)metadata.templatesV2().get(templateName);
    }

    static class AutoCreate {
        private final boolean autoCreateIndex;
        private final List<Tuple<String, Boolean>> expressions;
        private final String string;

        private AutoCreate(String value) {
            boolean autoCreateIndex;
            ArrayList<Tuple<String, Boolean>> expressions = new ArrayList<Tuple<String, Boolean>>();
            try {
                autoCreateIndex = Booleans.parseBoolean((String)value);
            }
            catch (IllegalArgumentException ex) {
                try {
                    String[] patterns;
                    for (String pattern : patterns = Strings.commaDelimitedListToStringArray((String)value)) {
                        Tuple expression;
                        if (pattern == null || pattern.trim().length() == 0) {
                            throw new IllegalArgumentException("Can't parse [" + value + "] for setting [action.auto_create_index] must be either [true, false, or a comma separated list of index patterns]");
                        }
                        if ((pattern = pattern.trim()).startsWith("-")) {
                            if (pattern.length() == 1) {
                                throw new IllegalArgumentException("Can't parse [" + value + "] for setting [action.auto_create_index] must contain an index name after [-]");
                            }
                            expression = new Tuple((Object)pattern.substring(1), (Object)false);
                        } else if (pattern.startsWith("+")) {
                            if (pattern.length() == 1) {
                                throw new IllegalArgumentException("Can't parse [" + value + "] for setting [action.auto_create_index] must contain an index name after [+]");
                            }
                            expression = new Tuple((Object)pattern.substring(1), (Object)true);
                        } else {
                            expression = new Tuple((Object)pattern, (Object)true);
                        }
                        expressions.add((Tuple<String, Boolean>)expression);
                    }
                    autoCreateIndex = true;
                }
                catch (IllegalArgumentException ex1) {
                    ex1.addSuppressed(ex);
                    throw ex1;
                }
            }
            this.expressions = expressions;
            this.autoCreateIndex = autoCreateIndex;
            this.string = value;
        }

        boolean isAutoCreateIndex() {
            return this.autoCreateIndex;
        }

        List<Tuple<String, Boolean>> getExpressions() {
            return this.expressions;
        }

        public String toString() {
            return this.string;
        }
    }

    public static final class SettingsProviderImpl
    implements SettingsProvider {
        public List<? extends Setting<?>> getSettings() {
            return Collections.singletonList(AUTO_CREATE_INDEX_SETTING);
        }
    }
}

