/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.support.nodes;

import io.skylite.common.action.ActionListener;
import io.skylite.common.action.ActionRunnable;
import io.skylite.common.transport.TransportRequestOptions;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.FailedNodeException;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.action.support.nodes.BaseNodeResponse;
import io.skylite.core.action.support.nodes.BaseNodesRequest;
import io.skylite.core.action.support.nodes.BaseNodesResponse;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.node.DiscoveryNodes;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.tasks.Task;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.NodeShouldNotConnectException;
import io.skylite.core.transport.TransportChannel;
import io.skylite.core.transport.TransportException;
import io.skylite.core.transport.TransportRequest;
import io.skylite.core.transport.TransportRequestHandler;
import io.skylite.core.transport.TransportResponseHandler;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;

public abstract class TransportNodesAction<NodesRequest extends BaseNodesRequest<NodesRequest>, NodesResponse extends BaseNodesResponse, NodeRequest extends TransportRequest, NodeResponse extends BaseNodeResponse>
extends HandledTransportAction<NodesRequest, NodesResponse> {
    protected final ThreadPool threadPool;
    protected final ClusterService clusterService;
    protected final TransportService transportService;
    protected final Class<NodeResponse> nodeResponseClass;
    protected final String transportNodeAction;
    private final String finalExecutor;

    protected TransportNodesAction(String actionName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, Writeable.Reader<NodesRequest> request, Writeable.Reader<NodeRequest> nodeRequest, String nodeExecutor, String finalExecutor, Class<NodeResponse> nodeResponseClass) {
        super(actionName, transportService, actionFilters, request);
        this.threadPool = threadPool;
        this.clusterService = Objects.requireNonNull(clusterService);
        this.transportService = Objects.requireNonNull(transportService);
        this.nodeResponseClass = Objects.requireNonNull(nodeResponseClass);
        this.transportNodeAction = actionName + "[n]";
        this.finalExecutor = finalExecutor;
        transportService.registerRequestHandler(this.transportNodeAction, nodeExecutor, nodeRequest, (TransportRequestHandler)new NodeTransportHandler());
    }

    protected TransportNodesAction(String actionName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, Writeable.Reader<NodesRequest> request, Writeable.Reader<NodeRequest> nodeRequest, String nodeExecutor, Class<NodeResponse> nodeResponseClass) {
        this(actionName, threadPool, clusterService, transportService, actionFilters, request, nodeRequest, nodeExecutor, "same", nodeResponseClass);
    }

    public void doExecute(Task task, NodesRequest request, ActionListener<NodesResponse> listener) {
        new AsyncAction(this, task, request, listener).start();
    }

    protected NodesResponse newResponse(NodesRequest request, AtomicReferenceArray<?> nodesResponses) {
        ArrayList<BaseNodeResponse> responses = new ArrayList<BaseNodeResponse>();
        ArrayList<FailedNodeException> failures = new ArrayList<FailedNodeException>();
        for (int i = 0; i < nodesResponses.length(); ++i) {
            Object response = nodesResponses.get(i);
            if (response instanceof FailedNodeException) {
                failures.add((FailedNodeException)response);
                continue;
            }
            responses.add((BaseNodeResponse)this.nodeResponseClass.cast(response));
        }
        return this.newResponse(request, responses, failures);
    }

    protected abstract NodesResponse newResponse(NodesRequest var1, List<NodeResponse> var2, List<FailedNodeException> var3);

    protected abstract NodeRequest newNodeRequest(NodesRequest var1);

    protected abstract NodeResponse newNodeResponse(StreamInput var1) throws IOException;

    protected abstract NodeResponse nodeOperation(NodeRequest var1);

    protected NodeResponse nodeOperation(NodeRequest request, Task task) {
        return this.nodeOperation(request);
    }

    protected void resolveRequest(NodesRequest request, ClusterState clusterState) {
        assert (request.concreteNodes() == null) : "request concreteNodes shouldn't be set";
        String[] nodesIds = clusterState.nodes().resolveNodes(request.nodesIds());
        request.setConcreteNodes((DiscoveryNode[])Arrays.stream(nodesIds).map(arg_0 -> ((DiscoveryNodes)clusterState.nodes()).get(arg_0)).toArray(DiscoveryNode[]::new));
    }

    protected String getTransportNodeAction(DiscoveryNode node) {
        return this.transportNodeAction;
    }

    class NodeTransportHandler
    implements TransportRequestHandler<NodeRequest> {
        NodeTransportHandler() {
        }

        public void messageReceived(NodeRequest request, TransportChannel channel, Task task) throws Exception {
            channel.sendResponse(TransportNodesAction.this.nodeOperation(request, task));
        }
    }

    static class AsyncAction {
        private final NodesRequest request;
        private final ActionListener<NodesResponse> listener;
        private final AtomicReferenceArray<Object> responses;
        private final AtomicInteger counter = new AtomicInteger();
        private final Task task;
        final /* synthetic */ TransportNodesAction this$0;

        AsyncAction(Task task, NodesRequest request, ActionListener<NodesResponse> listener) {
            this.this$0 = this$0;
            this.task = task;
            this.request = request;
            this.listener = listener;
            if (request.concreteNodes() == null) {
                this$0.resolveRequest(request, this$0.clusterService.state());
                assert (request.concreteNodes() != null);
            }
            this.responses = new AtomicReferenceArray(request.concreteNodes().length);
        }

        void start() {
            DiscoveryNode[] nodes = this.request.concreteNodes();
            if (nodes.length == 0) {
                this.this$0.threadPool.generic().execute(() -> this.listener.onResponse(this.this$0.newResponse(this.request, this.responses)));
                return;
            }
            TransportRequestOptions.Builder builder = TransportRequestOptions.builder();
            if (this.request.timeout() != null) {
                builder.withTimeout(this.request.timeout());
            }
            for (int i = 0; i < nodes.length; ++i) {
                final int idx = i;
                final DiscoveryNode node = nodes[i];
                String nodeId = node.getId();
                try {
                    Object nodeRequest = this.this$0.newNodeRequest(this.request);
                    if (this.task != null) {
                        nodeRequest.setParentTask(this.this$0.clusterService.localNode().getId(), this.task.getId());
                    }
                    this.this$0.transportService.sendRequest(node, this.this$0.getTransportNodeAction(node), nodeRequest, builder.build(), new TransportResponseHandler<NodeResponse>(){

                        public NodeResponse read(StreamInput in) throws IOException {
                            return AsyncAction.this.this$0.newNodeResponse(in);
                        }

                        public void handleResponse(NodeResponse response) {
                            AsyncAction.this.onOperation(idx, response);
                        }

                        public void handleException(TransportException exp) {
                            AsyncAction.this.onFailure(idx, node.getId(), (Throwable)exp);
                        }

                        public String executor() {
                            return "same";
                        }
                    });
                    continue;
                }
                catch (Exception e) {
                    this.onFailure(idx, nodeId, e);
                }
            }
        }

        private void onOperation(int idx, NodeResponse nodeResponse) {
            this.responses.set(idx, nodeResponse);
            if (this.counter.incrementAndGet() == this.responses.length()) {
                this.finishHim();
            }
        }

        private void onFailure(int idx, String nodeId, Throwable t) {
            if (this.this$0.logger.isDebugEnabled() && !(t instanceof NodeShouldNotConnectException)) {
                this.this$0.logger.debug((Message)new ParameterizedMessage("failed to execute on node [{}]", (Object)nodeId), t);
            }
            this.responses.set(idx, new FailedNodeException(nodeId, "Failed node [" + nodeId + "]", t));
            if (this.counter.incrementAndGet() == this.responses.length()) {
                this.finishHim();
            }
        }

        private void finishHim() {
            this.this$0.threadPool.executor(this.this$0.finalExecutor).execute((Runnable)ActionRunnable.supply(this.listener, () -> this.this$0.newResponse(this.request, this.responses)));
        }
    }
}

