/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.termvectors;

import io.lucenia.action.termvectors.TransportShardMultiTermsVectorAction;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.IndicesRequest;
import io.skylite.core.action.RoutingMissingException;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.action.termvectors.MultiTermVectorsItemResponse;
import io.skylite.core.action.termvectors.MultiTermVectorsRequest;
import io.skylite.core.action.termvectors.MultiTermVectorsResponse;
import io.skylite.core.action.termvectors.MultiTermVectorsShardRequest;
import io.skylite.core.action.termvectors.MultiTermVectorsShardResponse;
import io.skylite.core.action.termvectors.TermVectorsRequest;
import io.skylite.core.action.termvectors.TermVectorsResponse;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.concurrent.AtomicArray;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class TransportMultiTermVectorsAction
extends HandledTransportAction<MultiTermVectorsRequest, MultiTermVectorsResponse> {
    private final ClusterService clusterService;
    private final TransportShardMultiTermsVectorAction shardAction;
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    @Inject
    public TransportMultiTermVectorsAction(TransportService transportService, ClusterService clusterService, TransportShardMultiTermsVectorAction shardAction, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:data/read/mtv", transportService, actionFilters, MultiTermVectorsRequest::new);
        this.clusterService = clusterService;
        this.shardAction = shardAction;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }

    protected void doExecute(Task task, MultiTermVectorsRequest request, ActionListener<MultiTermVectorsResponse> listener) {
        ClusterState clusterState = this.clusterService.state();
        clusterState.blocks().globalBlockedRaiseException(ClusterBlockLevel.READ);
        AtomicArray responses = new AtomicArray(request.getRequests().size());
        HashMap<ShardId, MultiTermVectorsShardRequest> shardRequests = new HashMap<ShardId, MultiTermVectorsShardRequest>();
        for (int i = 0; i < request.getRequests().size(); ++i) {
            TermVectorsRequest termVectorsRequest = (TermVectorsRequest)request.getRequests().get(i);
            termVectorsRequest.routing(clusterState.metadata().resolveIndexRouting(termVectorsRequest.routing(), termVectorsRequest.index()));
            if (!clusterState.metadata().hasConcreteIndex(termVectorsRequest.index())) {
                responses.set(i, (Object)new MultiTermVectorsItemResponse(null, new MultiTermVectorsResponse.Failure(termVectorsRequest.index(), termVectorsRequest.id(), (Exception)((Object)new IndexNotFoundException(termVectorsRequest.index())))));
                continue;
            }
            String concreteSingleIndex = this.indexNameExpressionResolver.concreteSingleIndex(clusterState, (IndicesRequest)termVectorsRequest).getName();
            if (termVectorsRequest.routing() == null && clusterState.getMetadata().routingRequired(concreteSingleIndex)) {
                responses.set(i, (Object)new MultiTermVectorsItemResponse(null, new MultiTermVectorsResponse.Failure(concreteSingleIndex, termVectorsRequest.id(), (Exception)((Object)new RoutingMissingException(concreteSingleIndex, termVectorsRequest.id())))));
                continue;
            }
            ShardId shardId = this.clusterService.operationRouting().shardId(clusterState, concreteSingleIndex, termVectorsRequest.id(), termVectorsRequest.routing());
            MultiTermVectorsShardRequest shardRequest = (MultiTermVectorsShardRequest)shardRequests.get(shardId);
            if (shardRequest == null) {
                shardRequest = new MultiTermVectorsShardRequest(shardId.getIndexName(), shardId.id());
                shardRequest.preference(request.getPreference());
                shardRequests.put(shardId, shardRequest);
            }
            shardRequest.add(i, termVectorsRequest);
        }
        if (shardRequests.size() == 0) {
            listener.onResponse((Object)new MultiTermVectorsResponse((MultiTermVectorsItemResponse[])responses.toArray((Object[])new MultiTermVectorsItemResponse[responses.length()])));
        }
        this.executeShardAction(listener, (AtomicArray<MultiTermVectorsItemResponse>)responses, shardRequests);
    }

    protected void executeShardAction(final ActionListener<MultiTermVectorsResponse> listener, final AtomicArray<MultiTermVectorsItemResponse> responses, Map<ShardId, MultiTermVectorsShardRequest> shardRequests) {
        final AtomicInteger counter = new AtomicInteger(shardRequests.size());
        for (final MultiTermVectorsShardRequest shardRequest : shardRequests.values()) {
            this.shardAction.execute((ActionRequest)shardRequest, (ActionListener)new ActionListener<MultiTermVectorsShardResponse>(){

                public void onResponse(MultiTermVectorsShardResponse response) {
                    for (int i = 0; i < response.getLocations().size(); ++i) {
                        responses.set(((Integer)response.getLocations().get(i)).intValue(), (Object)new MultiTermVectorsItemResponse((TermVectorsResponse)response.getResponses().get(i), (MultiTermVectorsResponse.Failure)response.getFailures().get(i)));
                    }
                    if (counter.decrementAndGet() == 0) {
                        this.finishHim();
                    }
                }

                public void onFailure(Exception e) {
                    for (int i = 0; i < shardRequest.getLocations().size(); ++i) {
                        TermVectorsRequest termVectorsRequest = (TermVectorsRequest)shardRequest.getRequests().get(i);
                        responses.set(((Integer)shardRequest.getLocations().get(i)).intValue(), (Object)new MultiTermVectorsItemResponse(null, new MultiTermVectorsResponse.Failure(shardRequest.index(), termVectorsRequest.id(), e)));
                    }
                    if (counter.decrementAndGet() == 0) {
                        this.finishHim();
                    }
                }

                private void finishHim() {
                    listener.onResponse((Object)new MultiTermVectorsResponse((MultiTermVectorsItemResponse[])responses.toArray((Object[])new MultiTermVectorsItemResponse[responses.length()])));
                }
            });
        }
    }
}

