/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.bootstrap;

import io.lucenia.bootstrap.LuceniaUncaughtExceptionHandler;
import io.lucenia.bootstrap.Security;
import io.lucenia.bootstrap.Spawner;
import io.lucenia.bootstrap.StartupException;
import io.skylite.SkyliteException;
import io.skylite.bootstrap.JarHell;
import io.skylite.common.SecureString;
import io.skylite.common.SuppressForbidden;
import io.skylite.common.posix.UserException;
import io.skylite.common.util.ArrayUtils;
import io.skylite.common.util.io.IOUtils;
import io.skylite.core.bootstrap.BootstrapCheck;
import io.skylite.core.bootstrap.BootstrapChecks;
import io.skylite.core.bootstrap.BootstrapContext;
import io.skylite.core.bootstrap.BootstrapException;
import io.skylite.core.bootstrap.BootstrapInfo;
import io.skylite.core.bootstrap.BootstrapSettings;
import io.skylite.core.bootstrap.ConsoleCtrlHandler;
import io.skylite.core.bootstrap.JNAKernel32Library;
import io.skylite.core.bootstrap.Natives;
import io.skylite.core.cluster.node.InternalSettingsPreparer;
import io.skylite.core.common.PidFile;
import io.skylite.core.common.inject.CreationException;
import io.skylite.core.common.logging.LogConfigurator;
import io.skylite.core.common.logging.Loggers;
import io.skylite.core.common.network.IfConfig;
import io.skylite.core.common.transport.BoundTransportAddress;
import io.skylite.core.env.Environment;
import io.skylite.core.monitor.JvmInfo;
import io.skylite.core.monitor.os.OsProbe;
import io.skylite.core.monitor.process.ProcessProbe;
import io.skylite.core.node.NodeValidationException;
import io.skylite.core.settings.CommonSettings;
import io.skylite.core.settings.KeyStoreWrapper;
import io.skylite.core.settings.SecureSettings;
import io.skylite.core.settings.Settings;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.Version;
import org.opensearch.node.Node;

final class Bootstrap {
    private static volatile Bootstrap INSTANCE;
    private volatile Node node;
    private final CountDownLatch keepAliveLatch = new CountDownLatch(1);
    private final Thread keepAliveThread;
    private final Spawner spawner = new Spawner();

    Bootstrap() {
        this.keepAliveThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Bootstrap.this.keepAliveLatch.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }, "lucenia[keepAlive/" + String.valueOf(io.skylite.Version.CURRENT) + "]");
        this.keepAliveThread.setDaemon(false);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Bootstrap.this.keepAliveLatch.countDown();
            }
        });
    }

    public static void initializeNatives(Path tmpFile, boolean mlockAll, boolean systemCallFilter, boolean ctrlHandler) {
        final Logger logger = LogManager.getLogger(Bootstrap.class);
        if (Natives.definitelyRunningAsRoot()) {
            throw new RuntimeException("can not run opensearch as root");
        }
        if (systemCallFilter) {
            Natives.tryInstallSystemCallFilter((Path)tmpFile);
        }
        if (mlockAll) {
            if (Constants.WINDOWS) {
                Natives.tryVirtualLock();
            } else {
                Natives.tryMlockall();
            }
        }
        if (ctrlHandler) {
            Natives.addConsoleCtrlHandler((ConsoleCtrlHandler)new ConsoleCtrlHandler(){

                public boolean handle(int code) {
                    if (2 == code) {
                        logger.info("running graceful exit on windows");
                        try {
                            Bootstrap.stop();
                        }
                        catch (IOException e) {
                            throw new SkyliteException("failed to stop node", (Throwable)e, new Object[0]);
                        }
                        return true;
                    }
                    return false;
                }
            });
        }
        try {
            JNAKernel32Library.getInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Natives.trySetMaxNumberOfThreads();
        Natives.trySetMaxSizeVirtualMemory();
        Natives.trySetMaxFileSize();
        StringHelper.randomId();
    }

    static void initializeProbes() {
        ProcessProbe.getInstance();
        OsProbe.getInstance();
        JvmInfo.jvmInfo();
    }

    private void setup(boolean addShutdownHook, Environment environment) throws BootstrapException {
        Settings settings = environment.settings();
        try {
            this.spawner.spawnNativeControllers(environment, true);
        }
        catch (IOException e) {
            throw new BootstrapException((Exception)e);
        }
        Bootstrap.initializeNatives(environment.tmpDir(), (Boolean)BootstrapSettings.MEMORY_LOCK_SETTING.get(settings), (Boolean)BootstrapSettings.SYSTEM_CALL_FILTER_SETTING.get(settings), (Boolean)BootstrapSettings.CTRLHANDLER_SETTING.get(settings));
        Bootstrap.initializeProbes();
        if (addShutdownHook) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        IOUtils.close((Closeable[])new Closeable[]{Bootstrap.this.node, Bootstrap.this.spawner});
                        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
                        Configurator.shutdown((LoggerContext)context);
                        if (Bootstrap.this.node != null && !Bootstrap.this.node.awaitClose(10L, TimeUnit.SECONDS)) {
                            throw new IllegalStateException("Node didn't stop within 10 seconds. Any outstanding requests or tasks might get killed.");
                        }
                    }
                    catch (IOException ex) {
                        throw new SkyliteException("failed to stop node", (Throwable)ex, new Object[0]);
                    }
                    catch (InterruptedException e) {
                        LogManager.getLogger(Bootstrap.class).warn("Thread got interrupted while waiting for the node to shutdown.");
                        Thread.currentThread().interrupt();
                    }
                }
            });
        }
        try {
            Logger logger = LogManager.getLogger(JarHell.class);
            JarHell.checkJarHell(arg_0 -> ((Logger)logger).debug(arg_0));
        }
        catch (IOException | URISyntaxException e) {
            throw new BootstrapException(e);
        }
        IfConfig.logIfNecessary();
        try {
            Security.configure(environment, (Boolean)BootstrapSettings.SECURITY_FILTER_BAD_DEFAULTS_SETTING.get(settings));
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new BootstrapException(e);
        }
        this.node = new Node(this, environment){

            @Override
            protected void validateNodeBeforeAcceptingRequests(BootstrapContext context, BoundTransportAddress boundTransportAddress, List<BootstrapCheck> checks) throws NodeValidationException {
                BootstrapChecks.check((BootstrapContext)context, (BoundTransportAddress)boundTransportAddress, checks);
            }
        };
    }

    static SecureSettings loadSecureSettings(Environment initialEnv) throws BootstrapException {
        SecureString password;
        KeyStoreWrapper keystore;
        try {
            keystore = KeyStoreWrapper.load((Path)initialEnv.configDir());
        }
        catch (IOException e) {
            throw new BootstrapException((Exception)e);
        }
        try {
            password = keystore != null && keystore.hasPassword() ? Bootstrap.readPassphrase(System.in, 128) : new SecureString(new char[0]);
        }
        catch (IOException e) {
            throw new BootstrapException((Exception)e);
        }
        try {
            if (keystore == null) {
                KeyStoreWrapper keyStoreWrapper = KeyStoreWrapper.create();
                keyStoreWrapper.save(initialEnv.configDir(), new char[0]);
                KeyStoreWrapper keyStoreWrapper2 = keyStoreWrapper;
                return keyStoreWrapper2;
            }
            keystore.decrypt(password.getChars());
            KeyStoreWrapper.upgrade((KeyStoreWrapper)keystore, (Path)initialEnv.configDir(), (char[])password.getChars());
        }
        catch (Exception e) {
            throw new BootstrapException(e);
        }
        finally {
            password.close();
        }
        return keystore;
    }

    static SecureString readPassphrase(InputStream stream, int maxLength) throws IOException {
        SecureString passphrase;
        try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
            passphrase = new SecureString(ArrayUtils.readLineToCharArray((Reader)reader, (int)maxLength));
        }
        catch (RuntimeException e) {
            if (e.getMessage().startsWith("Input exceeded maximum length")) {
                throw new IllegalStateException("Password exceeded maximum length of " + maxLength, e);
            }
            throw e;
        }
        if (passphrase.length() == 0) {
            passphrase.close();
            throw new IllegalStateException("Keystore passphrase required but none provided.");
        }
        return passphrase;
    }

    private static Environment createEnvironment(Path pidFile, SecureSettings secureSettings, Settings initialSettings, Path configPath) {
        Settings.Builder builder = Settings.builder();
        if (pidFile != null) {
            builder.put(Environment.NODE_PIDFILE_SETTING.getKey(), pidFile);
        }
        builder.put(initialSettings);
        if (secureSettings != null) {
            builder.setSecureSettings(secureSettings);
        }
        return InternalSettingsPreparer.prepareEnvironment((Settings)builder.build(), Collections.emptyMap(), (Path)configPath, () -> System.getenv("HOSTNAME"));
    }

    private void start() throws NodeValidationException {
        this.node.start();
        this.keepAliveThread.start();
    }

    static void stop() throws IOException {
        try {
            IOUtils.close((Closeable[])new Closeable[]{Bootstrap.INSTANCE.node, Bootstrap.INSTANCE.spawner});
            if (Bootstrap.INSTANCE.node != null && !Bootstrap.INSTANCE.node.awaitClose(10L, TimeUnit.SECONDS)) {
                throw new IllegalStateException("Node didn't stop within 10 seconds. Any outstanding requests or tasks might get killed.");
            }
        }
        catch (InterruptedException e) {
            LogManager.getLogger(Bootstrap.class).warn("Thread got interrupted while waiting for the node to shutdown.");
            Thread.currentThread().interrupt();
        }
        finally {
            Bootstrap.INSTANCE.keepAliveLatch.countDown();
        }
    }

    static void init(boolean foreground, Path pidFile, boolean quiet, Environment initialEnv) throws BootstrapException, NodeValidationException, UserException {
        BootstrapInfo.init();
        INSTANCE = new Bootstrap();
        SecureSettings keystore = Bootstrap.loadSecureSettings(initialEnv);
        Environment environment = Bootstrap.createEnvironment(pidFile, keystore, initialEnv.settings(), initialEnv.configDir());
        LogConfigurator.setNodeName((String)((String)CommonSettings.NODE_NAME_SETTING.get(environment.settings())));
        try {
            LogConfigurator.configure((Environment)environment);
        }
        catch (IOException e) {
            throw new BootstrapException((Exception)e);
        }
        if (environment.pidFile() != null) {
            try {
                PidFile.create((Path)environment.pidFile(), (boolean)true);
            }
            catch (IOException e) {
                throw new BootstrapException((Exception)e);
            }
        }
        boolean closeStandardStreams = !foreground || quiet;
        try {
            if (closeStandardStreams) {
                Logger rootLogger = LogManager.getRootLogger();
                Appender maybeConsoleAppender = Loggers.findAppender((Logger)rootLogger, ConsoleAppender.class);
                if (maybeConsoleAppender != null) {
                    Loggers.removeAppender((Logger)rootLogger, (Appender)maybeConsoleAppender);
                }
                Bootstrap.closeSystOut();
            }
            Bootstrap.checkLucene();
            Thread.setDefaultUncaughtExceptionHandler(new LuceniaUncaughtExceptionHandler());
            INSTANCE.setup(true, environment);
            try {
                IOUtils.close((Closeable)keystore);
            }
            catch (IOException e) {
                throw new BootstrapException((Exception)e);
            }
            INSTANCE.start();
            if (!foreground) {
                Bootstrap.closeSysError();
            }
        }
        catch (NodeValidationException | RuntimeException e) {
            Logger rootLogger = LogManager.getRootLogger();
            Appender maybeConsoleAppender = Loggers.findAppender((Logger)rootLogger, ConsoleAppender.class);
            if (foreground && maybeConsoleAppender != null) {
                Loggers.removeAppender((Logger)rootLogger, (Appender)maybeConsoleAppender);
            }
            Logger logger = LogManager.getLogger(Bootstrap.class);
            if (e instanceof CreationException) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                PrintStream ps = null;
                try {
                    ps = new PrintStream((OutputStream)os, false, "UTF-8");
                }
                catch (UnsupportedEncodingException uee) {
                    assert (false);
                    e.addSuppressed(uee);
                }
                new StartupException(e).printStackTrace(ps);
                ps.flush();
                try {
                    logger.error("Guice Exception: {}", (Object)os.toString("UTF-8"));
                }
                catch (UnsupportedEncodingException uee) {
                    assert (false);
                    e.addSuppressed(uee);
                }
            } else if (e instanceof NodeValidationException) {
                logger.error("node validation exception\n{}", (Object)e.getMessage());
            } else {
                logger.error("Exception", e);
            }
            if (foreground && maybeConsoleAppender != null) {
                Loggers.addAppender((Logger)rootLogger, (Appender)maybeConsoleAppender);
            }
            throw e;
        }
    }

    @SuppressForbidden(reason="System#out")
    private static void closeSystOut() {
        System.out.close();
    }

    @SuppressForbidden(reason="System#err")
    private static void closeSysError() {
        System.err.close();
    }

    private static void checkLucene() {
        if (!io.skylite.Version.CURRENT.luceneVersion.equals((Object)Version.LATEST)) {
            throw new AssertionError((Object)("Lucene version mismatch this version of OpenSearch requires lucene version [" + String.valueOf(io.skylite.Version.CURRENT.luceneVersion) + "]  but the current lucene version is [" + String.valueOf(Version.LATEST) + "]"));
        }
    }
}

