/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.bootstrap;

import io.lucenia.bootstrap.Bootstrap;
import io.lucenia.bootstrap.StartupException;
import io.lucenia.cli.EnvironmentAwareCommand;
import io.skylite.Build;
import io.skylite.cli.Terminal;
import io.skylite.common.posix.UserException;
import io.skylite.core.bootstrap.BootstrapException;
import io.skylite.core.common.logging.LogConfigurator;
import io.skylite.core.env.Environment;
import io.skylite.core.monitor.JvmInfo;
import io.skylite.core.node.NodeValidationException;
import java.io.IOException;
import java.nio.file.Path;
import java.security.Permission;
import java.security.Security;
import java.util.Arrays;
import java.util.Locale;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import joptsimple.ValueConverter;
import joptsimple.util.PathConverter;
import joptsimple.util.PathProperties;

class Lucenia
extends EnvironmentAwareCommand {
    private final OptionSpecBuilder versionOption;
    private final OptionSpecBuilder daemonizeOption;
    private final OptionSpec<Path> pidfileOption;
    private final OptionSpecBuilder quietOption;

    Lucenia() {
        super("Starts Lucenia", () -> {});
        this.versionOption = this.parser.acceptsAll(Arrays.asList("V", "version"), "Prints Lucenia version information and exits");
        this.daemonizeOption = this.parser.acceptsAll(Arrays.asList("d", "daemonize"), "Starts Lucenia in the background").availableUnless((OptionSpec)this.versionOption, new OptionSpec[0]);
        this.pidfileOption = this.parser.acceptsAll(Arrays.asList("p", "pidfile"), "Creates a pid file in the specified path on start").availableUnless((OptionSpec)this.versionOption, new OptionSpec[0]).withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[0]));
        this.quietOption = this.parser.acceptsAll(Arrays.asList("q", "quiet"), "Turns off standard output/error streams logging in console").availableUnless((OptionSpec)this.versionOption, new OptionSpec[0]).availableUnless((OptionSpec)this.daemonizeOption, new OptionSpec[0]);
    }

    public static void main(String[] args) throws Exception {
        Lucenia.overrideDnsCachePolicyProperties();
        System.setSecurityManager(new SecurityManager(){

            @Override
            public void checkPermission(Permission perm) {
            }
        });
        LogConfigurator.registerErrorListener();
        Lucenia lucenia = new Lucenia();
        int status = Lucenia.main(args, lucenia, Terminal.DEFAULT);
        if (status != 0) {
            String basePath = System.getProperty("lucenia.logs.base_path");
            if (basePath != null) {
                Terminal.DEFAULT.errorPrintln("ERROR: Lucenia did not exit normally - check the logs at " + basePath + System.getProperty("file.separator") + System.getProperty("lucenia.logs.cluster_name") + ".log");
            }
            Lucenia.exit((int)status);
        }
    }

    private static void overrideDnsCachePolicyProperties() {
        for (String property : new String[]{"networkaddress.cache.ttl", "networkaddress.cache.negative.ttl"}) {
            String overrideProperty = "lucenia." + property;
            String overrideValue = System.getProperty(overrideProperty);
            if (overrideValue == null) continue;
            try {
                Security.setProperty(property, Integer.toString(Integer.valueOf(overrideValue)));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("failed to parse [" + overrideProperty + "] with value [" + overrideValue + "]", e);
            }
        }
    }

    static int main(String[] args, Lucenia lucenia, Terminal terminal) throws Exception {
        return lucenia.main(args, terminal);
    }

    @Override
    protected void execute(Terminal terminal, OptionSet options, Environment env) throws UserException {
        if (!options.nonOptionArguments().isEmpty()) {
            throw new UserException(64, "Positional arguments not allowed, found " + String.valueOf(options.nonOptionArguments()));
        }
        if (options.has((OptionSpec)this.versionOption)) {
            String versionOutput = String.format(Locale.ROOT, "Version: %s, Build: %s/%s/%s, JVM: %s", Build.CURRENT.getQualifiedVersion(), Build.CURRENT.type().displayName(), Build.CURRENT.hash(), Build.CURRENT.date(), JvmInfo.jvmInfo().version());
            terminal.println(versionOutput);
            return;
        }
        boolean daemonize = options.has((OptionSpec)this.daemonizeOption);
        Path pidFile = (Path)this.pidfileOption.value(options);
        boolean quiet = options.has((OptionSpec)this.quietOption);
        try {
            env.validateTmpDir();
        }
        catch (IOException e) {
            throw new UserException(78, e.getMessage());
        }
        try {
            this.init(daemonize, pidFile, quiet, env);
        }
        catch (NodeValidationException e) {
            throw new UserException(78, e.getMessage());
        }
    }

    void init(boolean daemonize, Path pidFile, boolean quiet, Environment initialEnv) throws NodeValidationException, UserException {
        try {
            Bootstrap.init(!daemonize, pidFile, quiet, initialEnv);
        }
        catch (BootstrapException | RuntimeException e) {
            throw new StartupException(e);
        }
    }

    static void close(String[] args) throws IOException {
        Bootstrap.stop();
    }
}

