/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.plugins;

import io.skylite.common.rest.RestHeaderDefinition;
import io.skylite.core.action.ActionFilter;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.RequestValidators;
import io.skylite.core.action.admin.indices.alias.IndicesAliasesRequest;
import io.skylite.core.action.admin.indices.mapping.put.PutMappingRequest;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.node.DiscoveryNodes;
import io.skylite.core.common.Strings;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.IndexScopedSettings;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.SettingsFilter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.opensearch.rest.RestController;

public interface ActionPlugin {
    default public List<ActionHandler> getActions() {
        return Collections.emptyList();
    }

    default public List<ActionType<? extends ActionResponse>> getClientActions() {
        return this.getActions().stream().map(a -> a.action).collect(Collectors.toList());
    }

    default public List<ActionFilter> getActionFilters() {
        return Collections.emptyList();
    }

    default public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return Collections.emptyList();
    }

    default public Collection<RestHeaderDefinition> getRestHeaders() {
        return Collections.emptyList();
    }

    default public Collection<String> getTaskHeaders() {
        return Collections.emptyList();
    }

    default public UnaryOperator<RestHandler> getRestHandlerWrapper(ThreadContext threadContext) {
        return null;
    }

    default public Collection<RequestValidators.RequestValidator<PutMappingRequest>> mappingRequestValidators() {
        return Collections.emptyList();
    }

    default public Collection<RequestValidators.RequestValidator<IndicesAliasesRequest>> indicesAliasesRequestValidators() {
        return Collections.emptyList();
    }

    public static final class ActionHandler {
        private final ActionType<? extends ActionResponse> action;
        private final Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> transportAction;
        private final Class<?>[] supportTransportActions;

        public ActionHandler(ActionType<? extends ActionResponse> action, Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> transportAction, Class<?> ... supportTransportActions) {
            this.action = action;
            this.transportAction = transportAction;
            this.supportTransportActions = supportTransportActions;
        }

        public ActionType<? extends ActionResponse> getAction() {
            return this.action;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return this.transportAction;
        }

        public Class<?>[] getSupportTransportActions() {
            return this.supportTransportActions;
        }

        public String toString() {
            StringBuilder b = new StringBuilder().append(this.action.name()).append(" is handled by ").append(this.transportAction.getName());
            if (this.supportTransportActions.length > 0) {
                b.append('[').append(Strings.arrayToCommaDelimitedString((Object[])this.supportTransportActions)).append(']');
            }
            return b.toString();
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != ActionHandler.class) {
                return false;
            }
            ActionHandler other = (ActionHandler)obj;
            return Objects.equals(this.action, other.action) && Objects.equals(this.transportAction, other.transportAction) && Objects.deepEquals(this.supportTransportActions, other.supportTransportActions);
        }

        public int hashCode() {
            return Objects.hash(this.action, this.transportAction, this.supportTransportActions);
        }
    }
}

