/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.plugins;

import io.skylite.common.CheckedFunction;
import io.skylite.core.ParseField;
import io.skylite.core.aggregations.AggregationBuilder;
import io.skylite.core.aggregations.AggregationRegistry;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.aggregations.PipelineAggregationBuilder;
import io.skylite.core.common.io.stream.NamedWriteable;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.functionscore.ScoreFunctionBuilder;
import io.skylite.core.search.SearchExtBuilder;
import io.skylite.core.search.query.QueryPhaseSearcher;
import io.skylite.core.search.rescore.RescorerBuilder;
import io.skylite.core.search.sort.BaseSortBuilder;
import io.skylite.core.search.suggest.Suggest;
import io.skylite.core.search.suggest.SuggestionBuilder;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.xcontent.ContextParser;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.opensearch.index.query.QueryParser;
import org.opensearch.index.query.functionscore.ScoreFunctionParser;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregationParsingFunction;
import org.opensearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.terms.heuristic.SignificanceHeuristic;
import org.opensearch.search.aggregations.pipeline.MovAvgModel;
import org.opensearch.search.fetch.FetchSubPhase;
import org.opensearch.search.fetch.subphase.highlight.Highlighter;

public interface SearchPlugin {
    default public List<ScoreFunctionSpec<?>> getScoreFunctions() {
        return Collections.emptyList();
    }

    default public List<SignificanceHeuristicSpec<?>> getSignificanceHeuristics() {
        return Collections.emptyList();
    }

    default public List<SearchExtensionSpec<MovAvgModel, MovAvgModel.AbstractModelParser>> getMovingAverageModels() {
        return Collections.emptyList();
    }

    default public List<FetchSubPhase> getFetchSubPhases(FetchPhaseConstructionContext context) {
        return Collections.emptyList();
    }

    default public List<SearchExtSpec<?>> getSearchExts() {
        return Collections.emptyList();
    }

    default public Map<String, Highlighter> getHighlighters() {
        return Collections.emptyMap();
    }

    default public List<SuggesterSpec<?>> getSuggesters() {
        return Collections.emptyList();
    }

    default public List<QuerySpec<?>> getQueries() {
        return Collections.emptyList();
    }

    default public List<SortSpec<?>> getSorts() {
        return Collections.emptyList();
    }

    default public List<AggregationSpec> getAggregations() {
        return Collections.emptyList();
    }

    default public List<Consumer<AggregationRegistry.Builder>> getAggregationExtentions() {
        return Collections.emptyList();
    }

    default public List<CompositeAggregationSpec> getCompositeAggregations() {
        return Collections.emptyList();
    }

    default public List<PipelineAggregationSpec> getPipelineAggregations() {
        return Collections.emptyList();
    }

    default public List<RescorerSpec<?>> getRescorers() {
        return Collections.emptyList();
    }

    default public Optional<QueryPhaseSearcher> getQueryPhaseSearcher() {
        return Optional.empty();
    }

    default public Optional<ExecutorServiceProvider> getIndexSearcherExecutorProvider() {
        return Optional.empty();
    }

    public static class FetchPhaseConstructionContext {
        private final Map<String, Highlighter> highlighters;

        public FetchPhaseConstructionContext(Map<String, Highlighter> highlighters) {
            this.highlighters = highlighters;
        }

        public Map<String, Highlighter> getHighlighters() {
            return this.highlighters;
        }
    }

    public static class SearchExtensionSpec<W extends NamedWriteable, P> {
        private final ParseField name;
        private final Writeable.Reader<? extends W> reader;
        private final P parser;

        public SearchExtensionSpec(ParseField name, Writeable.Reader<? extends W> reader, P parser) {
            this.name = name;
            this.reader = reader;
            this.parser = parser;
        }

        public SearchExtensionSpec(String name, Writeable.Reader<? extends W> reader, P parser) {
            this(new ParseField(name, new String[0]), reader, parser);
        }

        public ParseField getName() {
            return this.name;
        }

        public Writeable.Reader<? extends W> getReader() {
            return this.reader;
        }

        public P getParser() {
            return this.parser;
        }
    }

    public static class RescorerSpec<T extends RescorerBuilder<T>>
    extends SearchExtensionSpec<T, CheckedFunction<XContentParser, T, IOException>> {
        public RescorerSpec(ParseField name, Writeable.Reader<? extends T> reader, CheckedFunction<XContentParser, T, IOException> parser) {
            super(name, reader, parser);
        }

        public RescorerSpec(String name, Writeable.Reader<? extends T> reader, CheckedFunction<XContentParser, T, IOException> parser) {
            super(name, reader, parser);
        }
    }

    public static class SearchExtSpec<T extends SearchExtBuilder>
    extends SearchExtensionSpec<T, CheckedFunction<XContentParser, T, IOException>> {
        public SearchExtSpec(ParseField name, Writeable.Reader<? extends T> reader, CheckedFunction<XContentParser, T, IOException> parser) {
            super(name, reader, parser);
        }

        public SearchExtSpec(String name, Writeable.Reader<? extends T> reader, CheckedFunction<XContentParser, T, IOException> parser) {
            super(name, reader, parser);
        }
    }

    public static class PipelineAggregationSpec
    extends SearchExtensionSpec<PipelineAggregationBuilder, ContextParser<String, ? extends PipelineAggregationBuilder>>
    implements AggregationSpecInterface {
        private final Map<String, Writeable.Reader<? extends InternalAggregation>> resultReaders = new TreeMap<String, Writeable.Reader<? extends InternalAggregation>>();

        public PipelineAggregationSpec(ParseField name, Writeable.Reader<? extends PipelineAggregationBuilder> builderReader, ContextParser<String, ? extends PipelineAggregationBuilder> parser) {
            super(name, builderReader, parser);
        }

        public PipelineAggregationSpec(String name, Writeable.Reader<? extends PipelineAggregationBuilder> builderReader, ContextParser<String, ? extends PipelineAggregationBuilder> parser) {
            super(name, builderReader, parser);
        }

        @Deprecated
        public PipelineAggregationSpec(ParseField name, Writeable.Reader<? extends PipelineAggregationBuilder> builderReader, PipelineAggregationBuilder.Parser parser) {
            super(name, builderReader, (p, n) -> parser.parse(n, p));
        }

        @Deprecated
        public PipelineAggregationSpec(String name, Writeable.Reader<? extends PipelineAggregationBuilder> builderReader, PipelineAggregationBuilder.Parser parser) {
            super(name, builderReader, (p, n) -> parser.parse(n, p));
        }

        @Override
        public PipelineAggregationSpec addResultReader(Writeable.Reader<? extends InternalAggregation> resultReader) {
            return this.addResultReader(this.getName().getPreferredName(), (Writeable.Reader)resultReader);
        }

        @Override
        public PipelineAggregationSpec addResultReader(String writeableName, Writeable.Reader<? extends InternalAggregation> resultReader) {
            this.resultReaders.put(writeableName, resultReader);
            return this;
        }

        public Map<String, Writeable.Reader<? extends InternalAggregation>> getResultReaders() {
            return this.resultReaders;
        }
    }

    public static class CompositeAggregationSpec {
        private final Consumer<AggregationRegistry.Builder> aggregatorRegistrar;
        private final Class<?> valueSourceBuilderClass;
        @Deprecated
        private Byte byteCode;
        private final CompositeAggregationParsingFunction parsingFunction;
        private final String aggregationType;
        private final Writeable.Reader<? extends CompositeValuesSourceBuilder<?>> reader;

        public CompositeAggregationSpec(Consumer<AggregationRegistry.Builder> aggregatorRegistrar, Class<? extends CompositeValuesSourceBuilder<?>> valueSourceBuilderClass, Byte byteCode, Writeable.Reader<? extends CompositeValuesSourceBuilder<?>> reader, CompositeAggregationParsingFunction parsingFunction, String aggregationType) {
            this.aggregatorRegistrar = aggregatorRegistrar;
            this.valueSourceBuilderClass = valueSourceBuilderClass;
            this.byteCode = byteCode;
            this.parsingFunction = parsingFunction;
            this.aggregationType = aggregationType;
            this.reader = reader;
        }

        public Consumer<AggregationRegistry.Builder> getAggregatorRegistrar() {
            return this.aggregatorRegistrar;
        }

        public Class<?> getValueSourceBuilderClass() {
            return this.valueSourceBuilderClass;
        }

        public Byte getByteCode() {
            return this.byteCode;
        }

        public CompositeAggregationParsingFunction getParsingFunction() {
            return this.parsingFunction;
        }

        public String getAggregationType() {
            return this.aggregationType;
        }

        public Writeable.Reader<? extends CompositeValuesSourceBuilder<?>> getReader() {
            return this.reader;
        }
    }

    public static class AggregationSpec
    extends SearchExtensionSpec<AggregationBuilder, ContextParser<String, ? extends AggregationBuilder>>
    implements AggregationSpecInterface {
        private final Map<String, Writeable.Reader<? extends InternalAggregation>> resultReaders = new TreeMap<String, Writeable.Reader<? extends InternalAggregation>>();
        private Consumer<AggregationRegistry.Builder> aggregatorRegistrar;

        public <T extends AggregationBuilder> AggregationSpec(ParseField name, Writeable.Reader<T> reader, ContextParser<String, T> parser) {
            super(name, reader, parser);
        }

        public <T extends AggregationBuilder> AggregationSpec(String name, Writeable.Reader<T> reader, ContextParser<String, T> parser) {
            super(name, reader, parser);
        }

        @Deprecated
        public AggregationSpec(ParseField name, Writeable.Reader<? extends AggregationBuilder> reader, Aggregator.Parser parser) {
            super(name, reader, (p, aggName) -> parser.parse(aggName, p));
        }

        @Deprecated
        public AggregationSpec(String name, Writeable.Reader<? extends AggregationBuilder> reader, Aggregator.Parser parser) {
            super(name, reader, (p, aggName) -> parser.parse(aggName, p));
        }

        @Override
        public AggregationSpec addResultReader(Writeable.Reader<? extends InternalAggregation> resultReader) {
            return this.addResultReader(this.getName().getPreferredName(), (Writeable.Reader)resultReader);
        }

        @Override
        public AggregationSpec addResultReader(String writeableName, Writeable.Reader<? extends InternalAggregation> resultReader) {
            this.resultReaders.put(writeableName, resultReader);
            return this;
        }

        public Map<String, Writeable.Reader<? extends InternalAggregation>> getResultReaders() {
            return this.resultReaders;
        }

        public Consumer<AggregationRegistry.Builder> getAggregatorRegistrar() {
            return this.aggregatorRegistrar;
        }

        public AggregationSpec setAggregatorRegistrar(Consumer<AggregationRegistry.Builder> aggregatorRegistrar) {
            this.aggregatorRegistrar = aggregatorRegistrar;
            return this;
        }
    }

    public static interface AggregationSpecInterface {
        public AggregationSpecInterface addResultReader(String var1, Writeable.Reader<? extends InternalAggregation> var2);

        public AggregationSpecInterface addResultReader(Writeable.Reader<? extends InternalAggregation> var1);
    }

    public static class SortSpec<T extends BaseSortBuilder>
    extends SearchExtensionSpec<T, ContextParser<String, ? extends BaseSortBuilder>> {
        public SortSpec(ParseField name, Writeable.Reader<T> reader, ContextParser<String, T> parser) {
            super(name, reader, parser);
        }

        public SortSpec(String name, Writeable.Reader<T> reader, ContextParser<String, T> parser) {
            super(name, reader, parser);
        }
    }

    public static class QuerySpec<T extends QueryBuilder>
    extends SearchExtensionSpec<T, QueryParser<T>> {
        public QuerySpec(ParseField name, Writeable.Reader<T> reader, QueryParser<T> parser) {
            super(name, reader, parser);
        }

        public QuerySpec(String name, Writeable.Reader<T> reader, QueryParser<T> parser) {
            super(name, reader, parser);
        }
    }

    public static class SuggesterSpec<T extends SuggestionBuilder<T>>
    extends SearchExtensionSpec<T, CheckedFunction<XContentParser, T, IOException>> {
        private Writeable.Reader<? extends Suggest.Suggestion> suggestionReader;

        public SuggesterSpec(ParseField name, Writeable.Reader<T> builderReader, CheckedFunction<XContentParser, T, IOException> builderParser, Writeable.Reader<? extends Suggest.Suggestion> suggestionReader) {
            super(name, builderReader, builderParser);
            this.setSuggestionReader(suggestionReader);
        }

        public SuggesterSpec(String name, Writeable.Reader<T> builderReader, CheckedFunction<XContentParser, T, IOException> builderParser, Writeable.Reader<? extends Suggest.Suggestion> suggestionReader) {
            super(name, builderReader, builderParser);
            this.setSuggestionReader(suggestionReader);
        }

        private void setSuggestionReader(Writeable.Reader<? extends Suggest.Suggestion> reader) {
            this.suggestionReader = reader;
        }

        public Writeable.Reader<? extends Suggest.Suggestion> getSuggestionReader() {
            return this.suggestionReader;
        }
    }

    public static class SignificanceHeuristicSpec<T extends SignificanceHeuristic>
    extends SearchExtensionSpec<T, BiFunction<XContentParser, Void, T>> {
        public SignificanceHeuristicSpec(ParseField name, Writeable.Reader<T> reader, BiFunction<XContentParser, Void, T> parser) {
            super(name, reader, parser);
        }

        public SignificanceHeuristicSpec(String name, Writeable.Reader<T> reader, BiFunction<XContentParser, Void, T> parser) {
            super(name, reader, parser);
        }
    }

    public static class ScoreFunctionSpec<T extends ScoreFunctionBuilder<T>>
    extends SearchExtensionSpec<T, ScoreFunctionParser<T>> {
        public ScoreFunctionSpec(ParseField name, Writeable.Reader<T> reader, ScoreFunctionParser<T> parser) {
            super(name, reader, parser);
        }

        public ScoreFunctionSpec(String name, Writeable.Reader<T> reader, ScoreFunctionParser<T> parser) {
            super(name, reader, parser);
        }
    }

    public static interface ExecutorServiceProvider {
        public ExecutorService getExecutor(ThreadPool var1);
    }
}

