/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.action.index;

import io.skylite.core.action.IndicesRequest;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.EmptyTransportResponseHandler;
import io.skylite.core.transport.TransportChannel;
import io.skylite.core.transport.TransportRequest;
import io.skylite.core.transport.TransportRequestHandler;
import io.skylite.core.transport.TransportResponse;
import io.skylite.core.transport.TransportResponseHandler;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.metadata.MetadataMappingService;

public class NodeMappingRefreshAction {
    private static final Logger logger = LogManager.getLogger(NodeMappingRefreshAction.class);
    public static final String ACTION_NAME = "internal:cluster/node/mapping/refresh";
    private final TransportService transportService;
    private final MetadataMappingService metadataMappingService;

    @Inject
    public NodeMappingRefreshAction(TransportService transportService, MetadataMappingService metadataMappingService) {
        this.transportService = transportService;
        this.metadataMappingService = metadataMappingService;
        transportService.registerRequestHandler(ACTION_NAME, "same", NodeMappingRefreshRequest::new, (TransportRequestHandler)new NodeMappingRefreshTransportHandler());
    }

    public void nodeMappingRefresh(DiscoveryNode clusterManagerNode, NodeMappingRefreshRequest request) {
        if (clusterManagerNode == null) {
            logger.warn("can't send mapping refresh for [{}], no cluster-manager known.", (Object)request.index());
            return;
        }
        this.transportService.sendRequest(clusterManagerNode, ACTION_NAME, (TransportRequest)request, (TransportResponseHandler)EmptyTransportResponseHandler.INSTANCE_SAME);
    }

    private class NodeMappingRefreshTransportHandler
    implements TransportRequestHandler<NodeMappingRefreshRequest> {
        private NodeMappingRefreshTransportHandler() {
        }

        public void messageReceived(NodeMappingRefreshRequest request, TransportChannel channel, Task task) throws Exception {
            NodeMappingRefreshAction.this.metadataMappingService.refreshMapping(request.index(), request.indexUUID());
            channel.sendResponse((TransportResponse)TransportResponse.Empty.INSTANCE);
        }
    }

    public static class NodeMappingRefreshRequest
    extends TransportRequest
    implements IndicesRequest {
        private String index;
        private String indexUUID = "_na_";
        private String nodeId;

        public NodeMappingRefreshRequest(StreamInput in) throws IOException {
            super(in);
            this.index = in.readString();
            this.nodeId = in.readString();
            this.indexUUID = in.readString();
        }

        public NodeMappingRefreshRequest(String index, String indexUUID, String nodeId) {
            this.index = index;
            this.indexUUID = indexUUID;
            this.nodeId = nodeId;
        }

        public String[] indices() {
            return new String[]{this.index};
        }

        public IndicesOptions indicesOptions() {
            return IndicesOptions.strictSingleIndexNoExpandForbidClosed();
        }

        public String index() {
            return this.index;
        }

        public String indexUUID() {
            return this.indexUUID;
        }

        public String nodeId() {
            return this.nodeId;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.index);
            out.writeString(this.nodeId);
            out.writeString(this.indexUUID);
        }
    }
}

