/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.coordination;

import io.skylite.common.Nullable;
import io.skylite.common.unit.TimeValue;
import io.skylite.common.util.concurrent.AbstractRunnable;
import io.skylite.core.cluster.coordination.ClusterBootstrapService;
import io.skylite.core.cluster.coordination.CoordinationMetadata;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.transport.TransportAddress;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.spi.SettingsProvider;
import io.skylite.core.threadpool.ThreadPool;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.coordination.CoordinationState;
import org.opensearch.cluster.coordination.ElectionStrategy;
import org.opensearch.monitor.StatusInfo;

public class ClusterFormationFailureHelper {
    private static final Logger logger = LogManager.getLogger(ClusterFormationFailureHelper.class);
    public static final Setting<TimeValue> DISCOVERY_CLUSTER_FORMATION_WARNING_TIMEOUT_SETTING = Setting.timeSetting((String)"discovery.cluster_formation_warning_timeout", (TimeValue)TimeValue.timeValueMillis((long)10000L), (TimeValue)TimeValue.timeValueMillis((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final Supplier<ClusterFormationState> clusterFormationStateSupplier;
    private final ThreadPool threadPool;
    private final TimeValue clusterFormationWarningTimeout;
    private final Runnable logLastFailedJoinAttempt;
    @Nullable
    private volatile WarningScheduler warningScheduler;

    public ClusterFormationFailureHelper(Settings settings, Supplier<ClusterFormationState> clusterFormationStateSupplier, ThreadPool threadPool, Runnable logLastFailedJoinAttempt) {
        this.clusterFormationStateSupplier = clusterFormationStateSupplier;
        this.threadPool = threadPool;
        this.clusterFormationWarningTimeout = (TimeValue)DISCOVERY_CLUSTER_FORMATION_WARNING_TIMEOUT_SETTING.get(settings);
        this.logLastFailedJoinAttempt = logLastFailedJoinAttempt;
    }

    public boolean isRunning() {
        return this.warningScheduler != null;
    }

    public void start() {
        assert (this.warningScheduler == null);
        this.warningScheduler = new WarningScheduler();
        this.warningScheduler.scheduleNextWarning();
    }

    public void stop() {
        this.warningScheduler = null;
    }

    private class WarningScheduler {
        private WarningScheduler() {
        }

        private boolean isActive() {
            return ClusterFormationFailureHelper.this.warningScheduler == this;
        }

        void scheduleNextWarning() {
            ClusterFormationFailureHelper.this.threadPool.scheduleUnlessShuttingDown(ClusterFormationFailureHelper.this.clusterFormationWarningTimeout, "generic", (Runnable)new AbstractRunnable(){

                public void onFailure(Exception e) {
                    logger.debug("unexpected exception scheduling cluster formation warning", (Throwable)e);
                }

                public void doRun() {
                    if (WarningScheduler.this.isActive()) {
                        ClusterFormationFailureHelper.this.logLastFailedJoinAttempt.run();
                        logger.warn(ClusterFormationFailureHelper.this.clusterFormationStateSupplier.get().getDescription());
                    }
                }

                public void onAfter() {
                    if (WarningScheduler.this.isActive()) {
                        WarningScheduler.this.scheduleNextWarning();
                    }
                }

                public String toString() {
                    return "emit warning if cluster not formed";
                }
            });
        }
    }

    public static final class SettingsProviderImpl
    implements SettingsProvider {
        public List<? extends Setting<?>> getSettings() {
            return Collections.singletonList(DISCOVERY_CLUSTER_FORMATION_WARNING_TIMEOUT_SETTING);
        }
    }

    static class ClusterFormationState {
        private final Settings settings;
        private final ClusterState clusterState;
        private final List<TransportAddress> resolvedAddresses;
        private final List<DiscoveryNode> foundPeers;
        private final long currentTerm;
        private final ElectionStrategy electionStrategy;
        private final StatusInfo statusInfo;

        ClusterFormationState(Settings settings, ClusterState clusterState, List<TransportAddress> resolvedAddresses, List<DiscoveryNode> foundPeers, long currentTerm, ElectionStrategy electionStrategy, StatusInfo statusInfo) {
            this.settings = settings;
            this.clusterState = clusterState;
            this.resolvedAddresses = resolvedAddresses;
            this.foundPeers = foundPeers;
            this.currentTerm = currentTerm;
            this.electionStrategy = electionStrategy;
            this.statusInfo = statusInfo;
        }

        String getDescription() {
            if (this.statusInfo.getStatus() == StatusInfo.Status.UNHEALTHY) {
                return String.format(Locale.ROOT, "this node is unhealthy: %s", this.statusInfo.getInfo());
            }
            List clusterStateNodes = StreamSupport.stream(this.clusterState.nodes().getClusterManagerNodes().values().spliterator(), false).map(n -> n.toString()).collect(Collectors.toList());
            String discoveryWillContinueDescription = String.format(Locale.ROOT, "discovery will continue using %s from hosts providers and %s from last-known cluster state; node term %d, last-accepted version %d in term %d", this.resolvedAddresses, clusterStateNodes, this.currentTerm, this.clusterState.version(), this.clusterState.term());
            String discoveryStateIgnoringQuorum = String.format(Locale.ROOT, "have discovered %s; %s", this.foundPeers, discoveryWillContinueDescription);
            if (!this.clusterState.nodes().getLocalNode().isClusterManagerNode()) {
                return String.format(Locale.ROOT, "cluster-manager not discovered yet: %s", discoveryStateIgnoringQuorum);
            }
            if (this.clusterState.getLastAcceptedConfiguration().isEmpty()) {
                Object bootstrappingDescription = ((List)ClusterBootstrapService.INITIAL_CLUSTER_MANAGER_NODES_SETTING.get(Settings.EMPTY)).equals(ClusterBootstrapService.INITIAL_CLUSTER_MANAGER_NODES_SETTING.get(this.settings)) ? "[" + ClusterBootstrapService.INITIAL_CLUSTER_MANAGER_NODES_SETTING.getKey() + "] is empty on this node" : String.format(Locale.ROOT, "this node must discover cluster-manager-eligible nodes %s to bootstrap a cluster", ClusterBootstrapService.INITIAL_CLUSTER_MANAGER_NODES_SETTING.get(this.settings));
                return String.format(Locale.ROOT, "cluster-manager not discovered yet, this node has not previously joined a bootstrapped cluster, and %s: %s", bootstrappingDescription, discoveryStateIgnoringQuorum);
            }
            assert (!this.clusterState.getLastCommittedConfiguration().isEmpty());
            if (this.clusterState.getLastCommittedConfiguration().equals((Object)CoordinationMetadata.VotingConfiguration.MUST_JOIN_ELECTED_CLUSTER_MANAGER)) {
                return String.format(Locale.ROOT, "cluster-manager not discovered yet and this node was detached from its previous cluster, have discovered %s; %s", this.foundPeers, discoveryWillContinueDescription);
            }
            Object quorumDescription = this.clusterState.getLastAcceptedConfiguration().equals((Object)this.clusterState.getLastCommittedConfiguration()) ? this.describeQuorum(this.clusterState.getLastAcceptedConfiguration()) : this.describeQuorum(this.clusterState.getLastAcceptedConfiguration()) + " and " + this.describeQuorum(this.clusterState.getLastCommittedConfiguration());
            CoordinationState.VoteCollection voteCollection = new CoordinationState.VoteCollection();
            this.foundPeers.forEach(voteCollection::addVote);
            String isQuorumOrNot = this.electionStrategy.isElectionQuorum(this.clusterState.nodes().getLocalNode(), this.currentTerm, this.clusterState.term(), this.clusterState.version(), this.clusterState.getLastCommittedConfiguration(), this.clusterState.getLastAcceptedConfiguration(), voteCollection) ? "is a quorum" : "is not a quorum";
            return String.format(Locale.ROOT, "cluster-manager not discovered or elected yet, an election requires %s, have discovered %s which %s; %s", quorumDescription, this.foundPeers, isQuorumOrNot, discoveryWillContinueDescription);
        }

        private String describeQuorum(CoordinationMetadata.VotingConfiguration votingConfiguration) {
            Set nodeIds = votingConfiguration.getNodeIds();
            assert (!nodeIds.isEmpty());
            int requiredNodes = nodeIds.size() / 2 + 1;
            HashSet<String> realNodeIds = new HashSet<String>(nodeIds);
            realNodeIds.removeIf(ClusterBootstrapService::isBootstrapPlaceholder);
            assert (requiredNodes <= realNodeIds.size()) : nodeIds;
            if (nodeIds.size() == 1) {
                if (nodeIds.contains("STALE_STATE_CONFIG")) {
                    return "one or more nodes that have already participated as cluster-manager-eligible nodes in the cluster but this node was not cluster-manager-eligible the last time it joined the cluster";
                }
                return "a node with id " + String.valueOf(realNodeIds);
            }
            if (nodeIds.size() == 2) {
                return "two nodes with ids " + String.valueOf(realNodeIds);
            }
            if (requiredNodes < realNodeIds.size()) {
                return "at least " + requiredNodes + " nodes with ids from " + String.valueOf(realNodeIds);
            }
            return requiredNodes + " nodes with ids " + String.valueOf(realNodeIds);
        }
    }
}

