/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.coordination;

import io.skylite.Version;
import io.skylite.common.CheckedConsumer;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.io.stream.BytesStreamOutput;
import io.skylite.core.common.io.stream.InputStreamStreamInput;
import io.skylite.core.common.io.stream.NamedWriteableAwareStreamInput;
import io.skylite.core.common.io.stream.NamedWriteableRegistry;
import io.skylite.core.common.io.stream.OutputStreamStreamOutput;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.compress.Compressor;
import io.skylite.core.compress.CompressorRegistry;
import io.skylite.core.transport.BytesTransportRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class CompressedStreamUtils {
    private static final Logger logger = LogManager.getLogger(CompressedStreamUtils.class);

    public static BytesReference createCompressedStream(Version version, CheckedConsumer<StreamOutput, IOException> outputConsumer) throws IOException {
        BytesStreamOutput bStream = new BytesStreamOutput();
        try (OutputStreamStreamOutput stream = new OutputStreamStreamOutput(CompressorRegistry.defaultCompressor().threadLocalOutputStream((OutputStream)bStream));){
            stream.setVersion(version);
            outputConsumer.accept((Object)stream);
        }
        BytesReference serializedByteRef = bStream.bytes();
        logger.trace("serialized writable object for node version [{}] with size [{}]", (Object)version, (Object)serializedByteRef.length());
        return serializedByteRef;
    }

    public static StreamInput decompressBytes(BytesTransportRequest request, NamedWriteableRegistry namedWriteableRegistry) throws IOException {
        Compressor compressor = CompressorRegistry.compressor((BytesReference)request.bytes());
        Object in = compressor != null ? new InputStreamStreamInput(compressor.threadLocalInputStream((InputStream)request.bytes().streamInput())) : request.bytes().streamInput();
        in.setVersion(request.version());
        return new NamedWriteableAwareStreamInput(in, namedWriteableRegistry);
    }
}

