/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.coordination;

import io.skylite.cli.Terminal;
import io.skylite.core.cluster.coordination.CoordinationMetadata;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.PersistedClusterStateService;
import io.skylite.core.env.Environment;
import java.io.IOException;
import java.nio.file.Path;
import joptsimple.OptionSet;
import org.opensearch.cluster.coordination.LuceniaNodeCommand;

public class DetachClusterCommand
extends LuceniaNodeCommand {
    static final String NODE_DETACHED_MSG = "Node was successfully detached from the cluster";
    static final String CONFIRMATION_MSG = "------------------------------------------------------------------------\n\nYou should only run this tool if you have permanently lost all of the\ncluster-manager-eligible nodes in this cluster and you cannot restore the cluster\nfrom a snapshot, or you have already unsafely bootstrapped a new cluster\nby running `lucenia-node unsafe-bootstrap` on a cluster-manager-eligible\nnode that belonged to the same cluster as this node. This tool can cause\narbitrary data loss and its use should be your last resort.\n\nDo you want to proceed?\n";

    public DetachClusterCommand() {
        super("Detaches this node from its cluster, allowing it to unsafely join a new cluster");
    }

    @Override
    protected void processNodePaths(Terminal terminal, Path[] dataPaths, int nodeLockId, OptionSet options, Environment env) throws IOException {
        PersistedClusterStateService persistedClusterStateService = DetachClusterCommand.createPersistedClusterStateService(env.settings(), dataPaths);
        terminal.println(Terminal.Verbosity.VERBOSE, "Loading cluster state");
        ClusterState oldClusterState = (ClusterState)DetachClusterCommand.loadTermAndClusterState(persistedClusterStateService, env).v2();
        ClusterState newClusterState = ClusterState.builder((ClusterState)oldClusterState).metadata(DetachClusterCommand.updateMetadata(oldClusterState.metadata())).build();
        terminal.println(Terminal.Verbosity.VERBOSE, "[old cluster state = " + String.valueOf(oldClusterState) + ", new cluster state = " + String.valueOf(newClusterState) + "]");
        this.confirm(terminal, CONFIRMATION_MSG);
        try (PersistedClusterStateService.Writer writer = persistedClusterStateService.createWriter();){
            writer.writeFullStateAndCommit(DetachClusterCommand.updateCurrentTerm(), newClusterState);
        }
        terminal.println(NODE_DETACHED_MSG);
    }

    static Metadata updateMetadata(Metadata oldMetadata) {
        CoordinationMetadata coordinationMetadata = CoordinationMetadata.builder().lastAcceptedConfiguration(CoordinationMetadata.VotingConfiguration.MUST_JOIN_ELECTED_CLUSTER_MANAGER).lastCommittedConfiguration(CoordinationMetadata.VotingConfiguration.MUST_JOIN_ELECTED_CLUSTER_MANAGER).term(0L).build();
        return Metadata.builder((Metadata)oldMetadata).coordinationMetadata(coordinationMetadata).clusterUUIDCommitted(false).build();
    }

    static long updateCurrentTerm() {
        return 0L;
    }
}

