/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.coordination;

import io.skylite.common.SuppressForbidden;
import io.skylite.common.lease.Releasable;
import io.skylite.common.unit.TimeValue;
import io.skylite.common.util.concurrent.AbstractRunnable;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.spi.SettingsProvider;
import io.skylite.core.threadpool.ThreadPool;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;

public class ElectionSchedulerFactory {
    private static final Logger logger = LogManager.getLogger(ElectionSchedulerFactory.class);
    private static final String ELECTION_INITIAL_TIMEOUT_SETTING_KEY = "cluster.election.initial_timeout";
    private static final String ELECTION_BACK_OFF_TIME_SETTING_KEY = "cluster.election.back_off_time";
    private static final String ELECTION_MAX_TIMEOUT_SETTING_KEY = "cluster.election.max_timeout";
    private static final String ELECTION_DURATION_SETTING_KEY = "cluster.election.duration";
    public static final Setting<TimeValue> ELECTION_INITIAL_TIMEOUT_SETTING = Setting.timeSetting((String)"cluster.election.initial_timeout", (TimeValue)TimeValue.timeValueMillis((long)100L), (TimeValue)TimeValue.timeValueMillis((long)1L), (TimeValue)TimeValue.timeValueSeconds((long)10L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<TimeValue> ELECTION_BACK_OFF_TIME_SETTING = Setting.timeSetting((String)"cluster.election.back_off_time", (TimeValue)TimeValue.timeValueMillis((long)100L), (TimeValue)TimeValue.timeValueMillis((long)1L), (TimeValue)TimeValue.timeValueSeconds((long)60L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<TimeValue> ELECTION_MAX_TIMEOUT_SETTING = Setting.timeSetting((String)"cluster.election.max_timeout", (TimeValue)TimeValue.timeValueSeconds((long)10L), (TimeValue)TimeValue.timeValueMillis((long)200L), (TimeValue)TimeValue.timeValueSeconds((long)300L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<TimeValue> ELECTION_DURATION_SETTING = Setting.timeSetting((String)"cluster.election.duration", (TimeValue)TimeValue.timeValueMillis((long)500L), (TimeValue)TimeValue.timeValueMillis((long)1L), (TimeValue)TimeValue.timeValueSeconds((long)300L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final TimeValue initialTimeout;
    private final TimeValue backoffTime;
    private final TimeValue maxTimeout;
    private final TimeValue duration;
    private final ThreadPool threadPool;
    private final Random random;

    public ElectionSchedulerFactory(Settings settings, Random random, ThreadPool threadPool) {
        this.random = random;
        this.threadPool = threadPool;
        this.initialTimeout = (TimeValue)ELECTION_INITIAL_TIMEOUT_SETTING.get(settings);
        this.backoffTime = (TimeValue)ELECTION_BACK_OFF_TIME_SETTING.get(settings);
        this.maxTimeout = (TimeValue)ELECTION_MAX_TIMEOUT_SETTING.get(settings);
        this.duration = (TimeValue)ELECTION_DURATION_SETTING.get(settings);
        if (this.maxTimeout.millis() < this.initialTimeout.millis()) {
            throw new IllegalArgumentException(new ParameterizedMessage("[{}] is [{}], but must be at least [{}] which is [{}]", new Object[]{ELECTION_MAX_TIMEOUT_SETTING_KEY, this.maxTimeout, ELECTION_INITIAL_TIMEOUT_SETTING_KEY, this.initialTimeout}).getFormattedMessage());
        }
    }

    public Releasable startElectionScheduler(TimeValue gracePeriod, Runnable scheduledRunnable) {
        ElectionScheduler scheduler = new ElectionScheduler();
        scheduler.scheduleNextElection(gracePeriod, scheduledRunnable);
        return scheduler;
    }

    @SuppressForbidden(reason="Argument to Math.abs() is definitely not Long.MIN_VALUE")
    private static long nonNegative(long n) {
        return n == Long.MIN_VALUE ? 0L : Math.abs(n);
    }

    static long toPositiveLongAtMost(long randomNumber, long upperBound) {
        assert (0L < upperBound) : upperBound;
        return ElectionSchedulerFactory.nonNegative(randomNumber) % upperBound + 1L;
    }

    public String toString() {
        return "ElectionSchedulerFactory{initialTimeout=" + String.valueOf(this.initialTimeout) + ", backoffTime=" + String.valueOf(this.backoffTime) + ", maxTimeout=" + String.valueOf(this.maxTimeout) + "}";
    }

    private class ElectionScheduler
    implements Releasable {
        private final AtomicBoolean isClosed = new AtomicBoolean();
        private final AtomicLong attempt = new AtomicLong();

        private ElectionScheduler() {
        }

        void scheduleNextElection(final TimeValue gracePeriod, final Runnable scheduledRunnable) {
            if (this.isClosed.get()) {
                logger.debug("{} not scheduling election", (Object)this);
                return;
            }
            final long thisAttempt = this.attempt.getAndIncrement();
            final long maxDelayMillis = Math.min(ElectionSchedulerFactory.this.maxTimeout.millis(), ElectionSchedulerFactory.this.initialTimeout.millis() + thisAttempt * ElectionSchedulerFactory.this.backoffTime.millis());
            final long delayMillis = ElectionSchedulerFactory.toPositiveLongAtMost(ElectionSchedulerFactory.this.random.nextLong(), maxDelayMillis) + gracePeriod.millis();
            AbstractRunnable runnable = new AbstractRunnable(){

                public void onFailure(Exception e) {
                    logger.debug((Message)new ParameterizedMessage("unexpected exception in wakeup of {}", (Object)this), (Throwable)e);
                    assert (false) : e;
                }

                public void doRun() {
                    if (ElectionScheduler.this.isClosed.get()) {
                        logger.debug("{} not starting election", (Object)this);
                    } else {
                        logger.debug("{} starting election", (Object)this);
                        ElectionScheduler.this.scheduleNextElection(ElectionSchedulerFactory.this.duration, scheduledRunnable);
                        scheduledRunnable.run();
                    }
                }

                public String toString() {
                    return "scheduleNextElection{gracePeriod=" + String.valueOf(gracePeriod) + ", thisAttempt=" + thisAttempt + ", maxDelayMillis=" + maxDelayMillis + ", delayMillis=" + delayMillis + ", " + String.valueOf(ElectionScheduler.this) + "}";
                }
            };
            logger.debug("scheduling {}", (Object)runnable);
            ElectionSchedulerFactory.this.threadPool.scheduleUnlessShuttingDown(TimeValue.timeValueMillis((long)delayMillis), "generic", (Runnable)runnable);
        }

        public String toString() {
            return "ElectionScheduler{attempt=" + String.valueOf(this.attempt) + ", " + String.valueOf(ElectionSchedulerFactory.this) + "}";
        }

        public void close() {
            boolean wasNotPreviouslyClosed = this.isClosed.compareAndSet(false, true);
            assert (wasNotPreviouslyClosed);
        }
    }

    public static final class SettingsProviderImpl
    implements SettingsProvider {
        public List<? extends Setting<?>> getSettings() {
            return Arrays.asList(ELECTION_INITIAL_TIMEOUT_SETTING, ELECTION_BACK_OFF_TIME_SETTING, ELECTION_MAX_TIMEOUT_SETTING, ELECTION_DURATION_SETTING);
        }
    }
}

