/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.coordination;

import io.skylite.core.cluster.block.ClusterBlock;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.spi.SettingsProvider;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;

public class NoClusterManagerBlockService {
    public static final int NO_CLUSTER_MANAGER_BLOCK_ID = 2;
    public static final ClusterBlock NO_CLUSTER_MANAGER_BLOCK_WRITES = new ClusterBlock(2, "no cluster-manager", true, false, false, RestStatus.SERVICE_UNAVAILABLE, EnumSet.of(ClusterBlockLevel.WRITE, ClusterBlockLevel.METADATA_WRITE));
    public static final ClusterBlock NO_CLUSTER_MANAGER_BLOCK_ALL = new ClusterBlock(2, "no cluster-manager", true, true, false, RestStatus.SERVICE_UNAVAILABLE, ClusterBlockLevel.ALL);
    public static final ClusterBlock NO_CLUSTER_MANAGER_BLOCK_METADATA_WRITES = new ClusterBlock(2, "no cluster-manager", true, false, false, RestStatus.SERVICE_UNAVAILABLE, EnumSet.of(ClusterBlockLevel.METADATA_WRITE));
    @Deprecated
    public static final int NO_MASTER_BLOCK_ID = 2;
    @Deprecated
    public static final ClusterBlock NO_MASTER_BLOCK_WRITES = NO_CLUSTER_MANAGER_BLOCK_WRITES;
    @Deprecated
    public static final ClusterBlock NO_MASTER_BLOCK_ALL = NO_CLUSTER_MANAGER_BLOCK_ALL;
    @Deprecated
    public static final ClusterBlock NO_MASTER_BLOCK_METADATA_WRITES = NO_CLUSTER_MANAGER_BLOCK_METADATA_WRITES;
    public static final Setting<ClusterBlock> NO_MASTER_BLOCK_SETTING = new Setting("cluster.no_master_block", "metadata_write", NoClusterManagerBlockService::parseNoClusterManagerBlock, new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.Deprecated});
    public static final Setting<ClusterBlock> NO_CLUSTER_MANAGER_BLOCK_SETTING = new Setting("cluster.no_cluster_manager_block", NO_MASTER_BLOCK_SETTING, NoClusterManagerBlockService::parseNoClusterManagerBlock, new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private volatile ClusterBlock noClusterManagerBlock;

    public NoClusterManagerBlockService(Settings settings, ClusterSettings clusterSettings) {
        this.noClusterManagerBlock = (ClusterBlock)NO_CLUSTER_MANAGER_BLOCK_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(NO_CLUSTER_MANAGER_BLOCK_SETTING, this::setNoClusterManagerBlock);
    }

    private static ClusterBlock parseNoClusterManagerBlock(String value) {
        switch (value) {
            case "all": {
                return NO_CLUSTER_MANAGER_BLOCK_ALL;
            }
            case "write": {
                return NO_CLUSTER_MANAGER_BLOCK_WRITES;
            }
            case "metadata_write": {
                return NO_CLUSTER_MANAGER_BLOCK_METADATA_WRITES;
            }
        }
        throw new IllegalArgumentException("invalid no-cluster-manager block [" + value + "], must be one of [all, write, metadata_write]");
    }

    public ClusterBlock getNoClusterManagerBlock() {
        return this.noClusterManagerBlock;
    }

    @Deprecated
    public ClusterBlock getNoMasterBlock() {
        return this.noClusterManagerBlock;
    }

    private void setNoClusterManagerBlock(ClusterBlock noClusterManagerBlock) {
        this.noClusterManagerBlock = noClusterManagerBlock;
    }

    public static final class SettingsProviderImpl
    implements SettingsProvider {
        public List<? extends Setting<?>> getSettings() {
            return Arrays.asList(NO_MASTER_BLOCK_SETTING, NO_CLUSTER_MANAGER_BLOCK_SETTING);
        }
    }
}

