/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.coordination;

import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.node.DiscoveryNodes;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateTaskExecutor;
import io.skylite.core.cluster.state.ClusterStateTaskListener;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.cluster.routing.allocation.AllocationService;
import org.opensearch.persistent.PersistentTasksCustomMetadata;

public class NodeRemovalClusterStateTaskExecutor
implements ClusterStateTaskExecutor<Task>,
ClusterStateTaskListener {
    private final AllocationService allocationService;
    private final Logger logger;

    public NodeRemovalClusterStateTaskExecutor(AllocationService allocationService, Logger logger) {
        this.allocationService = allocationService;
        this.logger = logger;
    }

    public ClusterStateTaskExecutor.ClusterStateTasksResult<Task> execute(ClusterState currentState, List<Task> tasks) throws Exception {
        DiscoveryNodes.Builder remainingNodesBuilder = DiscoveryNodes.builder((DiscoveryNodes)currentState.nodes());
        boolean removed = false;
        for (Task task : tasks) {
            if (currentState.nodes().nodeExists(task.node())) {
                remainingNodesBuilder.remove(task.node());
                removed = true;
                continue;
            }
            this.logger.debug("node [{}] does not exist in cluster state, ignoring", (Object)task);
        }
        if (!removed) {
            return ClusterStateTaskExecutor.ClusterStateTasksResult.builder().successes(tasks).build(currentState);
        }
        ClusterState remainingNodesClusterState = this.remainingNodesClusterState(currentState, remainingNodesBuilder);
        return this.getTaskClusterTasksResult(currentState, tasks, remainingNodesClusterState);
    }

    protected ClusterStateTaskExecutor.ClusterStateTasksResult<Task> getTaskClusterTasksResult(ClusterState currentState, List<Task> tasks, ClusterState remainingNodesClusterState) {
        ClusterState ptasksDisassociatedState = PersistentTasksCustomMetadata.disassociateDeadNodes(remainingNodesClusterState);
        ClusterStateTaskExecutor.ClusterStateTasksResult.Builder resultBuilder = ClusterStateTaskExecutor.ClusterStateTasksResult.builder().successes(tasks);
        return resultBuilder.build(this.allocationService.disassociateDeadNodes(ptasksDisassociatedState, true, this.describeTasks(tasks)));
    }

    protected ClusterState remainingNodesClusterState(ClusterState currentState, DiscoveryNodes.Builder remainingNodesBuilder) {
        return ClusterState.builder((ClusterState)currentState).nodes(remainingNodesBuilder).build();
    }

    public void onFailure(String source, Exception e) {
        this.logger.error(() -> new ParameterizedMessage("unexpected failure during [{}]", (Object)source), (Throwable)e);
    }

    public void onNoLongerClusterManager(String source) {
        this.logger.debug("no longer cluster-manager while processing node removal [{}]", (Object)source);
    }

    public static class Task {
        private final DiscoveryNode node;
        private final String reason;

        public Task(DiscoveryNode node, String reason) {
            this.node = node;
            this.reason = reason;
        }

        public DiscoveryNode node() {
            return this.node;
        }

        public String reason() {
            return this.reason;
        }

        public String toString() {
            return String.valueOf(this.node) + " reason: " + this.reason;
        }
    }
}

