/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.coordination;

import io.skylite.cli.Terminal;
import io.skylite.common.collect.Tuple;
import io.skylite.common.posix.UserException;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.PersistedClusterStateService;
import io.skylite.core.common.regex.Regex;
import io.skylite.core.env.Environment;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.opensearch.cluster.coordination.LuceniaNodeCommand;

public class RemoveCustomsCommand
extends LuceniaNodeCommand {
    static final String CUSTOMS_REMOVED_MSG = "Customs were successfully removed from the cluster state";
    static final String CONFIRMATION_MSG = "------------------------------------------------------------------------\n\nYou should only run this tool if you have broken custom metadata in the\ncluster state that prevents the cluster state from being loaded.\nThis tool can cause data loss and its use should be your last resort.\n\nDo you want to proceed?\n";
    private final OptionSpec<String> arguments;

    public RemoveCustomsCommand() {
        super("Removes custom metadata from the cluster state");
        this.arguments = this.parser.nonOptions("custom metadata names");
    }

    @Override
    protected void processNodePaths(Terminal terminal, Path[] dataPaths, int nodeLockId, OptionSet options, Environment env) throws IOException, UserException {
        List customsToRemove = this.arguments.values(options);
        if (customsToRemove.isEmpty()) {
            throw new UserException(64, "Must supply at least one custom metadata name to remove");
        }
        PersistedClusterStateService persistedClusterStateService = RemoveCustomsCommand.createPersistedClusterStateService(env.settings(), dataPaths);
        terminal.println(Terminal.Verbosity.VERBOSE, "Loading cluster state");
        Tuple<Long, ClusterState> termAndClusterState = RemoveCustomsCommand.loadTermAndClusterState(persistedClusterStateService, env);
        ClusterState oldClusterState = (ClusterState)termAndClusterState.v2();
        terminal.println(Terminal.Verbosity.VERBOSE, "custom metadata names: " + String.valueOf(oldClusterState.metadata().customs().keySet()));
        Metadata.Builder metadataBuilder = Metadata.builder((Metadata)oldClusterState.metadata());
        for (String customToRemove : customsToRemove) {
            boolean matched = false;
            for (String customKey : oldClusterState.metadata().customs().keySet()) {
                if (!Regex.simpleMatch((String)customToRemove, (String)customKey)) continue;
                metadataBuilder.removeCustom(customKey);
                if (!matched) {
                    terminal.println("The following customs will be removed:");
                }
                matched = true;
                terminal.println(customKey);
            }
            if (matched) continue;
            throw new UserException(64, "No custom metadata matching [" + customToRemove + "] were found on this node");
        }
        ClusterState newClusterState = ClusterState.builder((ClusterState)oldClusterState).metadata(metadataBuilder.build()).build();
        terminal.println(Terminal.Verbosity.VERBOSE, "[old cluster state = " + String.valueOf(oldClusterState) + ", new cluster state = " + String.valueOf(newClusterState) + "]");
        this.confirm(terminal, CONFIRMATION_MSG);
        try (PersistedClusterStateService.Writer writer = persistedClusterStateService.createWriter();){
            writer.writeFullStateAndCommit(((Long)termAndClusterState.v1()).longValue(), newClusterState);
        }
        terminal.println(CUSTOMS_REMOVED_MSG);
    }
}

