/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.coordination;

import io.skylite.SkyliteException;
import io.skylite.cli.Terminal;
import io.skylite.common.UUIDs;
import io.skylite.common.collect.Tuple;
import io.skylite.core.cluster.coordination.CoordinationMetadata;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.PersistedClusterStateService;
import io.skylite.core.cluster.state.remote.RemoteClusterStateSettings;
import io.skylite.core.env.Environment;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.opensearch.cluster.coordination.LuceniaNodeCommand;

public class UnsafeBootstrapClusterManagerCommand
extends LuceniaNodeCommand {
    static final String CLUSTER_STATE_TERM_VERSION_MSG_FORMAT = "Current node cluster state (term, version) pair is (%s, %s)";
    static final String CONFIRMATION_MSG = "------------------------------------------------------------------------\n\nYou should only run this tool if you have permanently lost half or more\nof the cluster-manager-eligible nodes in this cluster, and you cannot restore the\ncluster from a snapshot. This tool can cause arbitrary data loss and its\nuse should be your last resort. If you have multiple surviving cluster-manager\neligible nodes, you should run this tool on the node with the highest\ncluster state (term, version) pair.\n\nDo you want to proceed?\n";
    static final String NOT_CLUSTER_MANAGER_NODE_MSG = "unsafe-bootstrap tool can only be run on cluster-manager eligible node";
    static final String EMPTY_LAST_COMMITTED_VOTING_CONFIG_MSG = "last committed voting voting configuration is empty, cluster has never been bootstrapped?";
    static final String CLUSTER_MANAGER_NODE_BOOTSTRAPPED_MSG = "Cluster-manager node was successfully bootstrapped";
    static final Setting<String> UNSAFE_BOOTSTRAP = ClusterService.USER_DEFINED_METADATA.getConcreteSetting("cluster.metadata.unsafe-bootstrap");
    static final String REMOTE_CLUSTER_STATE_ENABLED_NODE = "Unsafe bootstrap cannot be performed when remote cluster state is enabled. The cluster state in the remote store is considered the source of truth. In case, you still wish to do best effort recovery with unsafe-bootstrap, then please disable the " + RemoteClusterStateSettings.REMOTE_CLUSTER_STATE_ENABLED_SETTING.getKey() + ". For more details, please check the OpenSearch documentation.";
    private OptionSpec<Boolean> applyClusterReadOnlyBlockOption;

    UnsafeBootstrapClusterManagerCommand() {
        super("Forces the successful election of the current node after the permanent loss of the half or more cluster-manager-eligible nodes");
        this.applyClusterReadOnlyBlockOption = this.parser.accepts("apply-cluster-read-only-block", "Optional cluster.blocks.read_only setting").withOptionalArg().ofType(Boolean.class);
    }

    @Override
    protected boolean validateBeforeLock(Terminal terminal, Environment env) {
        Settings settings = env.settings();
        terminal.println(Terminal.Verbosity.VERBOSE, "Checking node.roles setting");
        Boolean clusterManager = DiscoveryNode.isClusterManagerNode((Settings)settings);
        if (!clusterManager.booleanValue()) {
            throw new SkyliteException(NOT_CLUSTER_MANAGER_NODE_MSG, new Object[0]);
        }
        if (((Boolean)RemoteClusterStateSettings.REMOTE_CLUSTER_STATE_ENABLED_SETTING.get(settings)).booleanValue()) {
            throw new SkyliteException(REMOTE_CLUSTER_STATE_ENABLED_NODE, new Object[0]);
        }
        return true;
    }

    @Override
    protected void processNodePaths(Terminal terminal, Path[] dataPaths, int nodeLockId, OptionSet options, Environment env) throws IOException {
        PersistedClusterStateService persistedClusterStateService = UnsafeBootstrapClusterManagerCommand.createPersistedClusterStateService(env.settings(), dataPaths);
        Tuple<Long, ClusterState> state = UnsafeBootstrapClusterManagerCommand.loadTermAndClusterState(persistedClusterStateService, env);
        ClusterState oldClusterState = (ClusterState)state.v2();
        Metadata metadata = oldClusterState.metadata();
        CoordinationMetadata coordinationMetadata = metadata.coordinationMetadata();
        if (coordinationMetadata == null || coordinationMetadata.getLastCommittedConfiguration() == null || coordinationMetadata.getLastCommittedConfiguration().isEmpty()) {
            throw new SkyliteException(EMPTY_LAST_COMMITTED_VOTING_CONFIG_MSG, new Object[0]);
        }
        terminal.println(String.format(Locale.ROOT, CLUSTER_STATE_TERM_VERSION_MSG_FORMAT, coordinationMetadata.term(), metadata.version()));
        CoordinationMetadata newCoordinationMetadata = CoordinationMetadata.builder((CoordinationMetadata)coordinationMetadata).clearVotingConfigExclusions().lastAcceptedConfiguration(new CoordinationMetadata.VotingConfiguration(Collections.singleton(persistedClusterStateService.getNodeId()))).lastCommittedConfiguration(new CoordinationMetadata.VotingConfiguration(Collections.singleton(persistedClusterStateService.getNodeId()))).build();
        Settings persistentSettings = Settings.builder().put(metadata.persistentSettings()).put(UNSAFE_BOOTSTRAP.getKey(), true).build();
        Boolean applyClusterReadOnlyBlock = (Boolean)this.applyClusterReadOnlyBlockOption.value(options);
        if (Objects.nonNull(applyClusterReadOnlyBlock)) {
            persistentSettings = Settings.builder().put(persistentSettings).put(Metadata.SETTING_READ_ONLY_SETTING.getKey(), applyClusterReadOnlyBlock.booleanValue()).build();
        }
        Metadata.Builder newMetadata = Metadata.builder((Metadata)metadata).clusterUUID("_na_").generateClusterUuidIfNeeded().clusterUUIDCommitted(true).persistentSettings(persistentSettings).coordinationMetadata(newCoordinationMetadata);
        for (IndexMetadata indexMetadata : metadata.indices().values()) {
            newMetadata.put(IndexMetadata.builder((IndexMetadata)indexMetadata).settings(Settings.builder().put(indexMetadata.getSettings()).put("index.history.uuid", UUIDs.randomBase64UUID())));
        }
        ClusterState newClusterState = ClusterState.builder((ClusterState)oldClusterState).metadata(newMetadata).build();
        terminal.println(Terminal.Verbosity.VERBOSE, "[old cluster state = " + String.valueOf(oldClusterState) + ", new cluster state = " + String.valueOf(newClusterState) + "]");
        this.confirm(terminal, CONFIRMATION_MSG);
        try (PersistedClusterStateService.Writer writer = persistedClusterStateService.createWriter();){
            writer.writeFullStateAndCommit(((Long)state.v1()).longValue(), newClusterState);
        }
        terminal.println(CLUSTER_MANAGER_NODE_BOOTSTRAPPED_MSG);
    }
}

