/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.metadata;

import io.skylite.common.Nullable;
import io.skylite.core.action.admin.indices.alias.Alias;
import io.skylite.core.cluster.metadata.AliasMetadata;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.common.Strings;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.QueryRewriteContext;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.index.query.Rewriteable;
import io.skylite.core.indices.InvalidAliasNameException;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContent;
import io.skylite.core.xcontent.XContentHelper;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Function;
import org.opensearch.cluster.metadata.MetadataCreateIndexService;

public class AliasValidator {
    public void validateAlias(Alias alias, String index, Metadata metadata) {
        this.validateAlias(alias.name(), index, alias.indexRouting(), arg_0 -> ((Metadata)metadata).index(arg_0));
    }

    public void validateAliasMetadata(AliasMetadata aliasMetadata, String index, Metadata metadata) {
        this.validateAlias(aliasMetadata.alias(), index, aliasMetadata.indexRouting(), arg_0 -> ((Metadata)metadata).index(arg_0));
    }

    public void validateAliasStandalone(Alias alias) {
        this.validateAliasStandalone(alias.name(), alias.indexRouting());
        if (Strings.hasLength((String)alias.filter())) {
            try {
                XContentHelper.convertToMap((XContent)MediaTypeRegistry.xContent((CharSequence)alias.filter()).xContent(), (String)alias.filter(), (boolean)false);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("failed to parse filter for alias [" + alias.name() + "]", e);
            }
        }
    }

    public void validateAlias(String alias, String index, @Nullable String indexRouting, Function<String, IndexMetadata> indexLookup) {
        this.validateAliasStandalone(alias, indexRouting);
        if (!Strings.hasText((String)index)) {
            throw new IllegalArgumentException("index name is required");
        }
        IndexMetadata indexNamedSameAsAlias = indexLookup.apply(alias);
        if (indexNamedSameAsAlias != null) {
            throw new InvalidAliasNameException(indexNamedSameAsAlias.getIndex(), alias, "an index exists with the same name as the alias");
        }
    }

    void validateAliasStandalone(String alias, String indexRouting) {
        if (!Strings.hasText((String)alias)) {
            throw new IllegalArgumentException("alias name is required");
        }
        MetadataCreateIndexService.validateIndexOrAliasName(alias, InvalidAliasNameException::new);
        if (indexRouting != null && indexRouting.indexOf(44) != -1) {
            throw new IllegalArgumentException("alias [" + alias + "] has several index routing values associated with it");
        }
    }

    public void validateAliasFilter(String alias, String filter, QueryShardContext queryShardContext, NamedXContentRegistry xContentRegistry) {
        assert (queryShardContext != null);
        try (XContentParser parser = MediaTypeRegistry.xContent((CharSequence)filter).xContent().createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, filter);){
            AliasValidator.validateAliasFilter(parser, queryShardContext);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to parse filter for alias [" + alias + "]", e);
        }
    }

    public void validateAliasFilter(String alias, BytesReference filter, QueryShardContext queryShardContext, NamedXContentRegistry xContentRegistry) {
        assert (queryShardContext != null);
        try (StreamInput inputStream = filter.streamInput();
             XContentParser parser = MediaTypeRegistry.xContentType((InputStream)inputStream).xContent().createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)filter.streamInput());){
            AliasValidator.validateAliasFilter(parser, queryShardContext);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to parse filter for alias [" + alias + "]", e);
        }
    }

    private static void validateAliasFilter(XContentParser parser, QueryShardContext queryShardContext) throws IOException {
        QueryBuilder parseInnerQueryBuilder = QueryBuilder.parseInnerQueryBuilder((XContentParser)parser);
        QueryBuilder queryBuilder = (QueryBuilder)Rewriteable.rewrite((Rewriteable)parseInnerQueryBuilder, (QueryRewriteContext)queryShardContext, (boolean)true);
        queryBuilder.toQuery((QueryRewriteContext)queryShardContext);
    }
}

