/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.metadata;

import io.skylite.common.action.ActionListener;
import io.skylite.common.util.set.Sets;
import io.skylite.core.action.admin.indices.delete.DeleteIndexClusterStateUpdateRequest;
import io.skylite.core.cluster.AckedRequest;
import io.skylite.core.cluster.RestoreInProgress;
import io.skylite.core.cluster.block.ClusterBlocks;
import io.skylite.core.cluster.metadata.DataStream;
import io.skylite.core.cluster.metadata.IndexAbstraction;
import io.skylite.core.cluster.metadata.IndexGraveyard;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.routing.RoutingTable;
import io.skylite.core.cluster.service.ClusterManagerTaskThrottler;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.AckedClusterStateUpdateTask;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateTaskConfig;
import io.skylite.core.cluster.state.ClusterStateUpdateResponse;
import io.skylite.core.common.Priority;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.index.Index;
import io.skylite.core.settings.Settings;
import io.skylite.core.snapshots.SnapshotsService;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.routing.allocation.AllocationService;
import org.opensearch.snapshots.RestoreService;
import org.opensearch.snapshots.SnapshotInProgressException;

public class MetadataDeleteIndexService {
    private static final Logger logger = LogManager.getLogger(MetadataDeleteIndexService.class);
    private final Settings settings;
    private final ClusterService clusterService;
    private final AllocationService allocationService;
    private final ClusterManagerTaskThrottler.ThrottlingKey deleteIndexTaskKey;

    @Inject
    public MetadataDeleteIndexService(Settings settings, ClusterService clusterService, AllocationService allocationService) {
        this.settings = settings;
        this.clusterService = clusterService;
        this.allocationService = allocationService;
        this.deleteIndexTaskKey = clusterService.registerClusterManagerTask("delete-index", true);
    }

    public void deleteIndices(final DeleteIndexClusterStateUpdateRequest request, ActionListener<ClusterStateUpdateResponse> listener) {
        if (request.indices() == null || request.indices().length == 0) {
            throw new IllegalArgumentException("Index name is required");
        }
        this.clusterService.submitStateUpdateTask("delete-index " + Arrays.toString(request.indices()), (ClusterStateTaskConfig)new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>(Priority.URGENT, (AckedRequest)request, listener){

            protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                return new ClusterStateUpdateResponse(acknowledged);
            }

            public ClusterManagerTaskThrottler.ThrottlingKey getClusterManagerThrottlingKey() {
                return MetadataDeleteIndexService.this.deleteIndexTaskKey;
            }

            public ClusterState execute(ClusterState currentState) {
                return MetadataDeleteIndexService.this.deleteIndices(currentState, Sets.newHashSet((Object[])request.indices()));
            }
        });
    }

    public ClusterState deleteIndices(ClusterState currentState, Set<Index> indices) {
        Metadata meta = currentState.metadata();
        HashSet<Index> indicesToDelete = new HashSet<Index>();
        HashMap<Index, DataStream> backingIndices = new HashMap<Index, DataStream>();
        for (Index index : indices) {
            IndexMetadata im = meta.getIndexSafe(index);
            IndexAbstraction.DataStream parent = ((IndexAbstraction)meta.getIndicesLookup().get(im.getIndex().getName())).getParentDataStream();
            if (parent != null) {
                if (parent.getWriteIndex().equals((Object)im)) {
                    throw new IllegalArgumentException("index [" + index.getName() + "] is the write index for data stream [" + parent.getName() + "] and cannot be deleted");
                }
                backingIndices.put(index, parent.getDataStream());
            }
            indicesToDelete.add(im.getIndex());
        }
        Set snapshottingIndices = SnapshotsService.snapshottingIndices((ClusterState)currentState, indicesToDelete);
        if (!snapshottingIndices.isEmpty()) {
            throw new SnapshotInProgressException("Cannot delete indices that are being snapshotted: " + String.valueOf(snapshottingIndices) + ". Try again after snapshot finishes or cancel the currently running snapshot.");
        }
        RoutingTable.Builder routingTableBuilder = RoutingTable.builder((RoutingTable)currentState.routingTable());
        Metadata.Builder metadataBuilder = Metadata.builder((Metadata)meta);
        ClusterBlocks.Builder clusterBlocksBuilder = ClusterBlocks.builder().blocks(currentState.blocks());
        IndexGraveyard.Builder graveyardBuilder = IndexGraveyard.builder((IndexGraveyard)metadataBuilder.indexGraveyard());
        int previousGraveyardSize = graveyardBuilder.tombstones().size();
        for (Index index : indices) {
            String indexName = index.getName();
            logger.info("{} deleting index", (Object)index);
            routingTableBuilder.remove(indexName);
            clusterBlocksBuilder.removeIndexBlocks(indexName);
            metadataBuilder.remove(indexName);
            if (!backingIndices.containsKey(index)) continue;
            DataStream parent = metadataBuilder.dataStream(((DataStream)backingIndices.get(index)).getName());
            metadataBuilder.put(parent.removeBackingIndex(index));
        }
        IndexGraveyard currentGraveyard = graveyardBuilder.addTombstones(indices).build(this.settings);
        metadataBuilder.indexGraveyard(currentGraveyard);
        logger.trace("{} tombstones purged from the cluster state. Previous tombstone size: {}. Current tombstone size: {}.", (Object)graveyardBuilder.getNumPurged(), (Object)previousGraveyardSize, (Object)currentGraveyard.getTombstones().size());
        Metadata newMetadata = metadataBuilder.build();
        ClusterBlocks blocks = clusterBlocksBuilder.build();
        Map customs = currentState.getCustoms();
        RestoreInProgress restoreInProgress = (RestoreInProgress)currentState.custom("restore", (ClusterState.Custom)RestoreInProgress.EMPTY);
        RestoreInProgress updatedRestoreInProgress = RestoreService.updateRestoreStateWithDeletedIndices(restoreInProgress, indices);
        if (updatedRestoreInProgress != restoreInProgress) {
            HashMap<String, RestoreInProgress> builder = new HashMap<String, RestoreInProgress>(customs);
            builder.put("restore", updatedRestoreInProgress);
            customs = Collections.unmodifiableMap(builder);
        }
        return this.allocationService.reroute(ClusterState.builder((ClusterState)currentState).routingTable(routingTableBuilder.build()).metadata(newMetadata).blocks(blocks).customs(customs).build(), "deleted indices [" + String.valueOf(indices) + "]");
    }
}

