/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.metadata;

import io.skylite.SkyliteException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.admin.indices.alias.IndicesAliasesClusterStateUpdateRequest;
import io.skylite.core.cluster.AckedRequest;
import io.skylite.core.cluster.metadata.AliasAction;
import io.skylite.core.cluster.metadata.IndexAbstraction;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.service.ClusterManagerTaskThrottler;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.AckedClusterStateUpdateTask;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateTaskConfig;
import io.skylite.core.cluster.state.ClusterStateUpdateResponse;
import io.skylite.core.common.Priority;
import io.skylite.core.common.Strings;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.index.Index;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.indices.cluster.AllocatedIndicesInterface;
import io.skylite.core.mapper.MergeReason;
import io.skylite.core.xcontent.NamedXContentRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.function.Function;
import org.opensearch.cluster.metadata.AliasValidator;
import org.opensearch.cluster.metadata.MetadataDeleteIndexService;
import org.opensearch.index.IndexService;
import org.opensearch.indices.IndicesService;

public class MetadataIndexAliasesService {
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final AliasValidator aliasValidator;
    private final MetadataDeleteIndexService deleteIndexService;
    private final NamedXContentRegistry xContentRegistry;
    private final ClusterManagerTaskThrottler.ThrottlingKey indexAliasTaskKey;

    @Inject
    public MetadataIndexAliasesService(ClusterService clusterService, IndicesService indicesService, AliasValidator aliasValidator, MetadataDeleteIndexService deleteIndexService, NamedXContentRegistry xContentRegistry) {
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.aliasValidator = aliasValidator;
        this.deleteIndexService = deleteIndexService;
        this.xContentRegistry = xContentRegistry;
        this.indexAliasTaskKey = clusterService.registerClusterManagerTask("index-aliases", true);
    }

    public void indicesAliases(final IndicesAliasesClusterStateUpdateRequest request, ActionListener<ClusterStateUpdateResponse> listener) {
        this.clusterService.submitStateUpdateTask("index-aliases", (ClusterStateTaskConfig)new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>(Priority.URGENT, (AckedRequest)request, listener){

            protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                return new ClusterStateUpdateResponse(acknowledged);
            }

            public ClusterManagerTaskThrottler.ThrottlingKey getClusterManagerThrottlingKey() {
                return MetadataIndexAliasesService.this.indexAliasTaskKey;
            }

            public ClusterState execute(ClusterState currentState) {
                return MetadataIndexAliasesService.this.applyAliasActions(currentState, request.actions());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterState applyAliasActions(ClusterState currentState, Iterable<AliasAction> actions) {
        ArrayList indicesToClose = new ArrayList();
        HashMap indices = new HashMap();
        try {
            ClusterState updatedState;
            boolean changed = false;
            HashSet<Index> indicesToDelete = new HashSet<Index>();
            for (AliasAction action : actions) {
                if (!action.removeIndex()) continue;
                IndexMetadata index = (IndexMetadata)currentState.metadata().getIndices().get(action.getIndex());
                if (index == null) {
                    throw new IndexNotFoundException(action.getIndex());
                }
                this.validateAliasTargetIsNotDSBackingIndex(currentState, action);
                indicesToDelete.add(index.getIndex());
                changed = true;
            }
            if (changed) {
                currentState = this.deleteIndexService.deleteIndices(currentState, indicesToDelete);
            }
            Metadata.Builder metadata = Metadata.builder((Metadata)currentState.metadata());
            HashSet<String> maybeModifiedIndices = new HashSet<String>();
            for (AliasAction action : actions) {
                if (action.removeIndex()) continue;
                IndexMetadata index = metadata.get(action.getIndex());
                if (index == null) {
                    throw new IndexNotFoundException(action.getIndex());
                }
                this.validateAliasTargetIsNotDSBackingIndex(currentState, action);
                AliasAction.NewAliasValidator newAliasValidator = (alias, indexRouting, filter, writeIndex) -> {
                    Function<String, IndexMetadata> indexLookup = name -> metadata.get(name);
                    this.aliasValidator.validateAlias(alias, action.getIndex(), indexRouting, indexLookup);
                    if (Strings.hasLength((String)filter)) {
                        IndexService indexService = (IndexService)((Object)((Object)indices.get(index.getIndex().getName())));
                        if (indexService == null) {
                            indexService = this.indicesService.indexService(index.getIndex());
                            if (indexService == null) {
                                try {
                                    indexService = this.indicesService.createIndex(index, Collections.emptyList(), false);
                                    indicesToClose.add(index.getIndex());
                                }
                                catch (IOException e) {
                                    throw new SkyliteException("Failed to create temporary index for parsing the alias", (Throwable)e, new Object[0]);
                                }
                                indexService.mapperService().merge(index, MergeReason.MAPPING_RECOVERY);
                            }
                            indices.put(action.getIndex(), indexService);
                        }
                        this.aliasValidator.validateAliasFilter(alias, filter, indexService.newQueryShardContext(0, null, () -> System.currentTimeMillis(), null), this.xContentRegistry);
                    }
                };
                if (!action.apply(newAliasValidator, metadata, index)) continue;
                changed = true;
                maybeModifiedIndices.add(index.getIndex().getName());
            }
            for (String maybeModifiedIndex : maybeModifiedIndices) {
                IndexMetadata currentIndexMetadata = currentState.metadata().index(maybeModifiedIndex);
                IndexMetadata newIndexMetadata = metadata.get(maybeModifiedIndex);
                if (currentIndexMetadata.getAliases().equals(newIndexMetadata.getAliases())) continue;
                assert (currentIndexMetadata.getAliasesVersion() == newIndexMetadata.getAliasesVersion());
                metadata.put(new IndexMetadata.Builder(newIndexMetadata).aliasesVersion(1L + currentIndexMetadata.getAliasesVersion()));
            }
            if (changed && !(updatedState = ClusterState.builder((ClusterState)currentState).metadata(metadata).build()).metadata().equalsAliases(currentState.metadata())) {
                ClusterState clusterState = updatedState;
                return clusterState;
            }
            ClusterState clusterState = currentState;
            return clusterState;
        }
        finally {
            for (Index index : indicesToClose) {
                this.indicesService.removeIndex(index, AllocatedIndicesInterface.IndexRemovalReason.NO_LONGER_ASSIGNED, "created for alias processing");
            }
        }
    }

    private void validateAliasTargetIsNotDSBackingIndex(ClusterState currentState, AliasAction action) {
        IndexAbstraction indexAbstraction = (IndexAbstraction)currentState.metadata().getIndicesLookup().get(action.getIndex());
        assert (indexAbstraction != null) : "invalid cluster metadata. index [" + action.getIndex() + "] was not found";
        if (indexAbstraction.getParentDataStream() != null) {
            throw new IllegalArgumentException("The provided index [ " + action.getIndex() + "] is a backing index belonging to data stream [" + indexAbstraction.getParentDataStream().getName() + "]. Data streams and their backing indices don't support alias operations.");
        }
    }
}

