/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.metadata;

import io.lucenia.action.admin.indices.close.TransportVerifyShardBeforeCloseAction;
import io.lucenia.action.admin.indices.readonly.TransportVerifyShardIndexBlockAction;
import io.skylite.SkyliteException;
import io.skylite.Version;
import io.skylite.common.UUIDs;
import io.skylite.common.action.ActionListener;
import io.skylite.common.action.ActionRunnable;
import io.skylite.common.action.NotifyOnceListener;
import io.skylite.common.collect.Tuple;
import io.skylite.common.unit.TimeValue;
import io.skylite.common.util.concurrent.ConcurrentCollections;
import io.skylite.common.util.concurrent.CountDown;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.admin.indices.close.CloseIndexClusterStateUpdateRequest;
import io.skylite.core.action.admin.indices.close.CloseIndexResponse;
import io.skylite.core.action.admin.indices.open.OpenIndexClusterStateUpdateRequest;
import io.skylite.core.action.admin.indices.readonly.AddIndexBlockClusterStateUpdateRequest;
import io.skylite.core.action.admin.indices.readonly.AddIndexBlockResponse;
import io.skylite.core.action.replication.ReplicationResponse;
import io.skylite.core.action.support.ActiveShardsObserver;
import io.skylite.core.cluster.AckedRequest;
import io.skylite.core.cluster.block.ClusterBlock;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.block.ClusterBlocks;
import io.skylite.core.cluster.metadata.IndexAbstraction;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.IndexMetadataAPIBlock;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.routing.IndexRoutingTable;
import io.skylite.core.cluster.routing.IndexShardRoutingTable;
import io.skylite.core.cluster.routing.RoutingTable;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.AckedClusterStateUpdateTask;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateTaskConfig;
import io.skylite.core.cluster.state.ClusterStateUpdateResponse;
import io.skylite.core.cluster.state.ClusterStateUpdateTask;
import io.skylite.core.cluster.state.OpenIndexClusterStateUpdateResponse;
import io.skylite.core.common.Priority;
import io.skylite.core.common.Strings;
import io.skylite.core.common.concurrent.AtomicArray;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.index.Index;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.settings.Settings;
import io.skylite.core.snapshots.SnapshotsService;
import io.skylite.core.tasks.TaskId;
import io.skylite.core.threadpool.ThreadPool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.cluster.metadata.MetadataIndexUpgradeService;
import org.opensearch.cluster.routing.allocation.AllocationService;
import org.opensearch.indices.IndicesService;
import org.opensearch.indices.ShardLimitValidator;
import org.opensearch.snapshots.RestoreService;
import org.opensearch.snapshots.SnapshotInProgressException;

public class MetadataIndexStateService {
    private static final Logger logger = LogManager.getLogger(MetadataIndexStateService.class);
    public static final int INDEX_CLOSED_BLOCK_ID = 4;
    private final ClusterService clusterService;
    private final AllocationService allocationService;
    private final MetadataIndexUpgradeService metadataIndexUpgradeService;
    private final IndicesService indicesService;
    private final ShardLimitValidator shardLimitValidator;
    private final ThreadPool threadPool;
    private final TransportVerifyShardBeforeCloseAction transportVerifyShardBeforeCloseAction;
    private final TransportVerifyShardIndexBlockAction transportVerifyShardIndexBlockAction;
    private final ActiveShardsObserver activeShardsObserver;

    @Inject
    public MetadataIndexStateService(ClusterService clusterService, AllocationService allocationService, MetadataIndexUpgradeService metadataIndexUpgradeService, IndicesService indicesService, ShardLimitValidator shardLimitValidator, ThreadPool threadPool, TransportVerifyShardBeforeCloseAction transportVerifyShardBeforeCloseAction, TransportVerifyShardIndexBlockAction transportVerifyShardIndexBlockAction) {
        this.indicesService = indicesService;
        this.clusterService = clusterService;
        this.allocationService = allocationService;
        this.threadPool = threadPool;
        this.transportVerifyShardBeforeCloseAction = transportVerifyShardBeforeCloseAction;
        this.transportVerifyShardIndexBlockAction = transportVerifyShardIndexBlockAction;
        this.metadataIndexUpgradeService = metadataIndexUpgradeService;
        this.shardLimitValidator = shardLimitValidator;
        this.activeShardsObserver = new ActiveShardsObserver(clusterService, threadPool);
    }

    public void closeIndices(CloseIndexClusterStateUpdateRequest request, ActionListener<CloseIndexResponse> listener) {
        Object[] concreteIndices = request.indices();
        if (concreteIndices == null || concreteIndices.length == 0) {
            throw new IllegalArgumentException("Index name is required");
        }
        ArrayList<String> writeIndices = new ArrayList<String>();
        SortedMap lookup = this.clusterService.state().metadata().getIndicesLookup();
        for (Index index : concreteIndices) {
            IndexAbstraction ia = (IndexAbstraction)lookup.get(index.getName());
            if (ia == null || ia.getParentDataStream() == null || !ia.getParentDataStream().getWriteIndex().getIndex().equals((Object)index)) continue;
            writeIndices.add(index.getName());
        }
        if (writeIndices.size() > 0) {
            throw new IllegalArgumentException("cannot close the following data stream write indices [" + Strings.collectionToCommaDelimitedString(writeIndices) + "]");
        }
        this.clusterService.submitStateUpdateTask("add-block-index-to-close " + Arrays.toString(concreteIndices), (ClusterStateTaskConfig)new ClusterStateUpdateTask(Priority.URGENT, (Index[])concreteIndices, listener, request){
            private final Map<Index, ClusterBlock> blockedIndices;
            final /* synthetic */ Index[] val$concreteIndices;
            final /* synthetic */ ActionListener val$listener;
            final /* synthetic */ CloseIndexClusterStateUpdateRequest val$request;
            {
                this.val$concreteIndices = indexArray;
                this.val$listener = actionListener;
                this.val$request = closeIndexClusterStateUpdateRequest;
                super(priority);
                this.blockedIndices = new HashMap<Index, ClusterBlock>();
            }

            public ClusterState execute(ClusterState currentState) {
                return MetadataIndexStateService.addIndexClosedBlocks(this.val$concreteIndices, this.blockedIndices, currentState);
            }

            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                if (oldState == newState) {
                    assert (this.blockedIndices.isEmpty()) : "List of blocked indices is not empty but cluster state wasn't changed";
                    this.val$listener.onResponse((Object)new CloseIndexResponse(true, false, Collections.emptyList()));
                } else {
                    assert (!this.blockedIndices.isEmpty()) : "List of blocked indices is empty but cluster state was changed";
                    MetadataIndexStateService.this.threadPool.executor("management").execute((Runnable)((Object)new WaitForClosedBlocksApplied(this.blockedIndices, this.val$request, (ActionListener<Map<Index, CloseIndexResponse.IndexResult>>)ActionListenerHelper.wrap(verifyResults -> MetadataIndexStateService.this.clusterService.submitStateUpdateTask("close-indices", (ClusterStateTaskConfig)new ClusterStateUpdateTask(Priority.URGENT, (Map)verifyResults, this.val$listener, this.val$request){
                        private final List<CloseIndexResponse.IndexResult> indices;
                        final /* synthetic */ Map val$verifyResults;
                        final /* synthetic */ ActionListener val$listener;
                        final /* synthetic */ CloseIndexClusterStateUpdateRequest val$request;
                        {
                            this.val$verifyResults = map;
                            this.val$listener = actionListener;
                            this.val$request = closeIndexClusterStateUpdateRequest;
                            super(priority);
                            this.indices = new ArrayList<CloseIndexResponse.IndexResult>();
                        }

                        public ClusterState execute(ClusterState currentState) throws Exception {
                            Tuple<ClusterState, Collection<CloseIndexResponse.IndexResult>> closingResult = MetadataIndexStateService.closeRoutingTable(currentState, blockedIndices, this.val$verifyResults);
                            assert (this.val$verifyResults.size() == ((Collection)closingResult.v2()).size());
                            this.indices.addAll((Collection)closingResult.v2());
                            return MetadataIndexStateService.this.allocationService.reroute((ClusterState)closingResult.v1(), "indices closed");
                        }

                        public void onFailure(String source, Exception e) {
                            this.val$listener.onFailure(e);
                        }

                        public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                            boolean acknowledged = this.indices.stream().noneMatch(CloseIndexResponse.IndexResult::hasFailures);
                            String[] waitForIndices = (String[])this.indices.stream().filter(result -> !result.hasFailures()).filter(result -> newState.routingTable().hasIndex(result.getIndex())).map(result -> result.getIndex().getName()).toArray(String[]::new);
                            if (waitForIndices.length > 0) {
                                MetadataIndexStateService.this.activeShardsObserver.waitForActiveShards(waitForIndices, this.val$request.waitForActiveShards(), this.val$request.ackTimeout(), shardsAcknowledged -> {
                                    if (!shardsAcknowledged.booleanValue()) {
                                        logger.debug("[{}] indices closed, but the operation timed out while waiting for enough shards to be started.", (Object)Arrays.toString(waitForIndices));
                                    }
                                    boolean shardsAcked = acknowledged ? shardsAcknowledged : false;
                                    this.val$listener.onResponse((Object)new CloseIndexResponse(acknowledged, shardsAcked, this.indices));
                                }, arg_0 -> ((ActionListener)this.val$listener).onFailure(arg_0));
                            } else {
                                this.val$listener.onResponse((Object)new CloseIndexResponse(acknowledged, false, this.indices));
                            }
                        }
                    }), arg_0 -> ((ActionListener)this.val$listener).onFailure(arg_0)))));
                }
            }

            public void onFailure(String source, Exception e) {
                this.val$listener.onFailure(e);
            }

            public TimeValue timeout() {
                return this.val$request.masterNodeTimeout();
            }
        });
    }

    static ClusterState addIndexClosedBlocks(Index[] indices, Map<Index, ClusterBlock> blockedIndices, ClusterState currentState) {
        Metadata.Builder metadata = Metadata.builder((Metadata)currentState.metadata());
        HashSet<Index> indicesToClose = new HashSet<Index>();
        for (Index index : indices) {
            IndexMetadata indexMetadata = metadata.getSafe(index);
            if (indexMetadata.getState() != IndexMetadata.State.CLOSE) {
                indicesToClose.add(index);
                continue;
            }
            logger.debug("index {} is already closed, ignoring", (Object)index);
            assert (currentState.blocks().hasIndexBlock(index.getName(), IndexMetadata.INDEX_CLOSED_BLOCK));
        }
        if (indicesToClose.isEmpty()) {
            return currentState;
        }
        Set<Index> restoringIndices = RestoreService.restoringIndices(currentState, indicesToClose);
        if (!restoringIndices.isEmpty()) {
            throw new IllegalArgumentException("Cannot close indices that are being restored: " + String.valueOf(restoringIndices));
        }
        Set snapshottingIndices = SnapshotsService.snapshottingIndices((ClusterState)currentState, indicesToClose);
        if (!snapshottingIndices.isEmpty()) {
            throw new SnapshotInProgressException("Cannot close indices that are being snapshotted: " + String.valueOf(snapshottingIndices) + ". Try again after snapshot finishes or cancel the currently running snapshot.");
        }
        ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
        RoutingTable.Builder routingTable = RoutingTable.builder((RoutingTable)currentState.routingTable());
        for (Index index : indicesToClose) {
            ClusterBlock indexBlock = null;
            Set clusterBlocks = (Set)currentState.blocks().indices().get(index.getName());
            if (clusterBlocks != null) {
                for (ClusterBlock clusterBlock : clusterBlocks) {
                    if (clusterBlock.id() != 4) continue;
                    indexBlock = clusterBlock;
                    break;
                }
            }
            if (indexBlock == null) {
                indexBlock = MetadataIndexStateService.createIndexClosingBlock();
            }
            assert (Strings.hasLength((String)indexBlock.uuid())) : "Closing block should have a UUID";
            blocks.addIndexBlock(index.getName(), indexBlock);
            blockedIndices.put(index, indexBlock);
        }
        logger.info(() -> new ParameterizedMessage("closing indices {}", (Object)blockedIndices.keySet().stream().map(Object::toString).collect(Collectors.joining(","))));
        return ClusterState.builder((ClusterState)currentState).blocks(blocks).metadata(metadata).routingTable(routingTable.build()).build();
    }

    static Tuple<ClusterState, Map<Index, ClusterBlock>> addIndexBlock(Index[] indices, ClusterState currentState, IndexMetadataAPIBlock block) {
        Metadata.Builder metadata = Metadata.builder((Metadata)currentState.metadata());
        HashSet<Index> indicesToAddBlock = new HashSet<Index>();
        for (Index index : indices) {
            metadata.getSafe(index);
            if (currentState.blocks().hasIndexBlock(index.getName(), block.getBlock())) {
                logger.debug("index {} already has block {}, ignoring", (Object)index, (Object)block.getBlock());
                continue;
            }
            indicesToAddBlock.add(index);
        }
        if (indicesToAddBlock.isEmpty()) {
            return Tuple.tuple((Object)currentState, Collections.emptyMap());
        }
        ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
        RoutingTable.Builder routingTable = RoutingTable.builder((RoutingTable)currentState.routingTable());
        HashMap<Index, ClusterBlock> blockedIndices = new HashMap<Index, ClusterBlock>();
        for (Index index : indicesToAddBlock) {
            ClusterBlock indexBlock = null;
            Set clusterBlocks = (Set)currentState.blocks().indices().get(index.getName());
            if (clusterBlocks != null) {
                for (ClusterBlock clusterBlock : clusterBlocks) {
                    if (clusterBlock.id() != block.getBlock().id()) continue;
                    indexBlock = clusterBlock;
                    break;
                }
            }
            if (indexBlock == null) {
                indexBlock = MetadataIndexStateService.createUUIDBasedBlock(block.getBlock());
            }
            assert (Strings.hasLength((String)indexBlock.uuid())) : "Block should have a UUID";
            blocks.addIndexBlock(index.getName(), indexBlock);
            blockedIndices.put(index, indexBlock);
            IndexMetadata indexMetadata = metadata.getSafe(index);
            if (((Boolean)block.setting().get(indexMetadata.getSettings())).booleanValue()) continue;
            Settings updatedSettings = Settings.builder().put(indexMetadata.getSettings()).put(block.settingName(), true).build();
            metadata.put(IndexMetadata.builder((IndexMetadata)indexMetadata).settings(updatedSettings).settingsVersion(indexMetadata.getSettingsVersion() + 1L));
        }
        logger.info("adding block {} to indices {}", (Object)block.getName(), blockedIndices.keySet().stream().map(Object::toString).collect(Collectors.toList()));
        return Tuple.tuple((Object)ClusterState.builder((ClusterState)currentState).blocks(blocks).metadata(metadata).routingTable(routingTable.build()).build(), blockedIndices);
    }

    public void addIndexBlock(AddIndexBlockClusterStateUpdateRequest request, ActionListener<AddIndexBlockResponse> listener) {
        Object[] concreteIndices = request.indices();
        if (concreteIndices == null || concreteIndices.length == 0) {
            throw new IllegalArgumentException("Index name is required");
        }
        ArrayList<String> writeIndices = new ArrayList<String>();
        SortedMap lookup = this.clusterService.state().metadata().getIndicesLookup();
        for (Index index : concreteIndices) {
            IndexAbstraction ia = (IndexAbstraction)lookup.get(index.getName());
            if (ia == null || ia.getParentDataStream() == null || !ia.getParentDataStream().getWriteIndex().getIndex().equals((Object)index)) continue;
            writeIndices.add(index.getName());
        }
        if (writeIndices.size() > 0) {
            throw new IllegalArgumentException("cannot add a block to the following data stream write indices [" + Strings.collectionToCommaDelimitedString(writeIndices) + "]");
        }
        this.clusterService.submitStateUpdateTask("add-index-block-[" + request.getBlock().getName() + "]-" + Arrays.toString(concreteIndices), (ClusterStateTaskConfig)new ClusterStateUpdateTask(Priority.URGENT, (Index[])concreteIndices, request, listener){
            private Map<Index, ClusterBlock> blockedIndices;
            final /* synthetic */ Index[] val$concreteIndices;
            final /* synthetic */ AddIndexBlockClusterStateUpdateRequest val$request;
            final /* synthetic */ ActionListener val$listener;
            {
                this.val$concreteIndices = indexArray;
                this.val$request = addIndexBlockClusterStateUpdateRequest;
                this.val$listener = actionListener;
                super(priority);
            }

            public ClusterState execute(ClusterState currentState) {
                Tuple<ClusterState, Map<Index, ClusterBlock>> tup = MetadataIndexStateService.addIndexBlock(this.val$concreteIndices, currentState, this.val$request.getBlock());
                this.blockedIndices = (Map)tup.v2();
                return (ClusterState)tup.v1();
            }

            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                if (oldState == newState) {
                    assert (this.blockedIndices.isEmpty()) : "List of blocked indices is not empty but cluster state wasn't changed";
                    this.val$listener.onResponse((Object)new AddIndexBlockResponse(true, false, Collections.emptyList()));
                } else {
                    assert (!this.blockedIndices.isEmpty()) : "List of blocked indices is empty but cluster state was changed";
                    MetadataIndexStateService.this.threadPool.executor("management").execute((Runnable)((Object)new WaitForBlocksApplied(this.blockedIndices, this.val$request, (ActionListener<Map<Index, AddIndexBlockResponse.AddBlockResult>>)ActionListenerHelper.wrap(verifyResults -> MetadataIndexStateService.this.clusterService.submitStateUpdateTask("finalize-index-block-[" + this.val$request.getBlock().getName() + "]-[" + this.blockedIndices.keySet().stream().map(Index::getName).collect(Collectors.joining(", ")) + "]", (ClusterStateTaskConfig)new ClusterStateUpdateTask(Priority.URGENT, (Map)verifyResults, this.val$request, this.val$listener){
                        private final List<AddIndexBlockResponse.AddBlockResult> indices;
                        final /* synthetic */ Map val$verifyResults;
                        final /* synthetic */ AddIndexBlockClusterStateUpdateRequest val$request;
                        final /* synthetic */ ActionListener val$listener;
                        {
                            this.val$verifyResults = map;
                            this.val$request = addIndexBlockClusterStateUpdateRequest;
                            this.val$listener = actionListener;
                            super(priority);
                            this.indices = new ArrayList<AddIndexBlockResponse.AddBlockResult>();
                        }

                        public ClusterState execute(ClusterState currentState) throws Exception {
                            Tuple<ClusterState, Collection<AddIndexBlockResponse.AddBlockResult>> addBlockResult = MetadataIndexStateService.finalizeBlock(currentState, blockedIndices, this.val$verifyResults, this.val$request.getBlock());
                            assert (this.val$verifyResults.size() == ((Collection)addBlockResult.v2()).size());
                            this.indices.addAll((Collection)addBlockResult.v2());
                            return (ClusterState)addBlockResult.v1();
                        }

                        public void onFailure(String source, Exception e) {
                            this.val$listener.onFailure(e);
                        }

                        public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                            boolean acknowledged = this.indices.stream().noneMatch(AddIndexBlockResponse.AddBlockResult::hasFailures);
                            this.val$listener.onResponse((Object)new AddIndexBlockResponse(acknowledged, acknowledged, this.indices));
                        }
                    }), arg_0 -> ((ActionListener)this.val$listener).onFailure(arg_0)))));
                }
            }

            public void onFailure(String source, Exception e) {
                this.val$listener.onFailure(e);
            }

            public TimeValue timeout() {
                return this.val$request.masterNodeTimeout();
            }
        });
    }

    static Tuple<ClusterState, Collection<CloseIndexResponse.IndexResult>> closeRoutingTable(ClusterState currentState, Map<Index, ClusterBlock> blockedIndices, Map<Index, CloseIndexResponse.IndexResult> verifyResult) {
        Metadata.Builder metadata = Metadata.builder((Metadata)currentState.metadata());
        ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
        RoutingTable.Builder routingTable = RoutingTable.builder((RoutingTable)currentState.routingTable());
        HashSet<String> closedIndices = new HashSet<String>();
        HashMap<Index, CloseIndexResponse.IndexResult> closingResults = new HashMap<Index, CloseIndexResponse.IndexResult>(verifyResult);
        for (Map.Entry<Index, CloseIndexResponse.IndexResult> result : verifyResult.entrySet()) {
            Index index = result.getKey();
            boolean acknowledged = !result.getValue().hasFailures();
            try {
                if (!acknowledged) {
                    logger.debug("verification of shards before closing {} failed [{}]", (Object)index, result);
                    continue;
                }
                IndexMetadata indexMetadata = metadata.getSafe(index);
                if (indexMetadata.getState() == IndexMetadata.State.CLOSE) {
                    logger.debug("verification of shards before closing {} succeeded but index is already closed", (Object)index);
                    assert (currentState.blocks().hasIndexBlock(index.getName(), IndexMetadata.INDEX_CLOSED_BLOCK));
                    continue;
                }
                ClusterBlock closingBlock = blockedIndices.get(index);
                assert (closingBlock != null);
                if (!currentState.blocks().hasIndexBlock(index.getName(), closingBlock)) {
                    closingResults.put(result.getKey(), new CloseIndexResponse.IndexResult(result.getKey(), (Exception)new IllegalStateException("verification of shards before closing " + String.valueOf(index) + " succeeded but block has been removed in the meantime")));
                    logger.debug("verification of shards before closing {} succeeded but block has been removed in the meantime", (Object)index);
                    continue;
                }
                Set<Index> restoringIndices = RestoreService.restoringIndices(currentState, Collections.singleton(index));
                if (!restoringIndices.isEmpty()) {
                    closingResults.put(result.getKey(), new CloseIndexResponse.IndexResult(result.getKey(), (Exception)new IllegalStateException("verification of shards before closing " + String.valueOf(index) + " succeeded but index is being restored in the meantime")));
                    logger.debug("verification of shards before closing {} succeeded but index is being restored in the meantime", (Object)index);
                    continue;
                }
                Set snapshottingIndices = SnapshotsService.snapshottingIndices((ClusterState)currentState, Collections.singleton(index));
                if (!snapshottingIndices.isEmpty()) {
                    closingResults.put(result.getKey(), new CloseIndexResponse.IndexResult(result.getKey(), (Exception)new IllegalStateException("verification of shards before closing " + String.valueOf(index) + " succeeded but index is being snapshot in the meantime")));
                    logger.debug("verification of shards before closing {} succeeded but index is being snapshot in the meantime", (Object)index);
                    continue;
                }
                blocks.removeIndexBlockWithId(index.getName(), 4);
                blocks.addIndexBlock(index.getName(), IndexMetadata.INDEX_CLOSED_BLOCK);
                IndexMetadata.Builder updatedMetadata = IndexMetadata.builder((IndexMetadata)indexMetadata).state(IndexMetadata.State.CLOSE);
                metadata.put(updatedMetadata.settingsVersion(indexMetadata.getSettingsVersion() + 1L).settings(Settings.builder().put(indexMetadata.getSettings()).put(IndexMetadata.VERIFIED_BEFORE_CLOSE_SETTING.getKey(), true)));
                routingTable.addAsFromOpenToClose(metadata.getSafe(index));
                logger.debug("closing index {} succeeded", (Object)index);
                closedIndices.add(index.getName());
            }
            catch (IndexNotFoundException e) {
                logger.debug("index {} has been deleted since it was blocked before closing, ignoring", (Object)index);
            }
        }
        logger.info("completed closing of indices {}", closedIndices);
        return Tuple.tuple((Object)ClusterState.builder((ClusterState)currentState).blocks(blocks).metadata(metadata).routingTable(routingTable.build()).build(), closingResults.values());
    }

    public void openIndex(OpenIndexClusterStateUpdateRequest request, ActionListener<OpenIndexClusterStateUpdateResponse> listener) {
        this.onlyOpenIndex(request, (ActionListener<ClusterStateUpdateResponse>)ActionListenerHelper.wrap(response -> {
            if (response.isAcknowledged()) {
                String[] indexNames = (String[])Arrays.stream(request.indices()).map(Index::getName).toArray(String[]::new);
                this.activeShardsObserver.waitForActiveShards(indexNames, request.waitForActiveShards(), request.ackTimeout(), shardsAcknowledged -> {
                    if (!shardsAcknowledged.booleanValue()) {
                        logger.debug("[{}] indices opened, but the operation timed out while waiting for enough shards to be started.", (Object)Arrays.toString(indexNames));
                    }
                    listener.onResponse((Object)new OpenIndexClusterStateUpdateResponse(response.isAcknowledged(), shardsAcknowledged.booleanValue()));
                }, arg_0 -> ((ActionListener)listener).onFailure(arg_0));
            } else {
                listener.onResponse((Object)new OpenIndexClusterStateUpdateResponse(false, false));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void onlyOpenIndex(final OpenIndexClusterStateUpdateRequest request, ActionListener<ClusterStateUpdateResponse> listener) {
        if (request.indices() == null || request.indices().length == 0) {
            throw new IllegalArgumentException("Index name is required");
        }
        final String indicesAsString = Arrays.toString(request.indices());
        this.clusterService.submitStateUpdateTask("open-indices " + indicesAsString, (ClusterStateTaskConfig)new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>(Priority.URGENT, (AckedRequest)request, listener){

            protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                return new ClusterStateUpdateResponse(acknowledged);
            }

            public ClusterState execute(ClusterState currentState) {
                ClusterState updatedState = MetadataIndexStateService.this.openIndices(request.indices(), currentState);
                return MetadataIndexStateService.this.allocationService.reroute(updatedState, "indices opened [" + indicesAsString + "]");
            }
        });
    }

    ClusterState openIndices(Index[] indices, ClusterState currentState) {
        ArrayList<IndexMetadata> indicesToOpen = new ArrayList<IndexMetadata>();
        for (Index index : indices) {
            IndexMetadata indexMetadata = currentState.metadata().getIndexSafe(index);
            if (indexMetadata.getState() != IndexMetadata.State.OPEN) {
                indicesToOpen.add(indexMetadata);
                continue;
            }
            if (!currentState.blocks().hasIndexBlockWithId(index.getName(), 4)) continue;
            indicesToOpen.add(indexMetadata);
        }
        this.shardLimitValidator.validateShardLimit(currentState, indices);
        if (indicesToOpen.isEmpty()) {
            return currentState;
        }
        logger.info(() -> new ParameterizedMessage("opening indices [{}]", (Object)String.join((CharSequence)",", indicesToOpen.stream().map(i -> i.getIndex().toString())::iterator)));
        Metadata.Builder metadata = Metadata.builder((Metadata)currentState.metadata());
        ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
        Version minIndexCompatibilityVersion = currentState.getNodes().getMaxNodeVersion().minimumIndexCompatibilityVersion();
        for (IndexMetadata indexMetadata : indicesToOpen) {
            Index index = indexMetadata.getIndex();
            if (indexMetadata.getState() != IndexMetadata.State.OPEN) {
                Settings.Builder updatedSettings = Settings.builder().put(indexMetadata.getSettings());
                updatedSettings.remove(IndexMetadata.VERIFIED_BEFORE_CLOSE_SETTING.getKey());
                IndexMetadata updatedIndexMetadata = IndexMetadata.builder((IndexMetadata)indexMetadata).state(IndexMetadata.State.OPEN).settingsVersion(indexMetadata.getSettingsVersion() + 1L).settings(updatedSettings).build();
                updatedIndexMetadata = this.metadataIndexUpgradeService.upgradeIndexMetadata(updatedIndexMetadata, minIndexCompatibilityVersion);
                try {
                    this.indicesService.verifyIndexMetadata(updatedIndexMetadata, updatedIndexMetadata);
                }
                catch (Exception e) {
                    throw new SkyliteException("Failed to verify index " + String.valueOf(index), (Throwable)e, new Object[0]);
                }
                metadata.put(updatedIndexMetadata, true);
            }
            blocks.removeIndexBlockWithId(index.getName(), 4);
        }
        ClusterState updatedState = ClusterState.builder((ClusterState)currentState).metadata(metadata).blocks(blocks).build();
        RoutingTable.Builder routingTable = RoutingTable.builder((RoutingTable)updatedState.routingTable());
        for (IndexMetadata previousIndexMetadata : indicesToOpen) {
            if (previousIndexMetadata.getState() == IndexMetadata.State.OPEN) continue;
            routingTable.addAsFromCloseToOpen(updatedState.metadata().getIndexSafe(previousIndexMetadata.getIndex()));
        }
        return ClusterState.builder((ClusterState)updatedState).routingTable(routingTable.build()).build();
    }

    static Tuple<ClusterState, Collection<AddIndexBlockResponse.AddBlockResult>> finalizeBlock(ClusterState currentState, Map<Index, ClusterBlock> blockedIndices, Map<Index, AddIndexBlockResponse.AddBlockResult> verifyResult, IndexMetadataAPIBlock block) {
        Metadata.Builder metadata = Metadata.builder((Metadata)currentState.metadata());
        ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
        RoutingTable.Builder routingTable = RoutingTable.builder((RoutingTable)currentState.routingTable());
        HashSet<String> effectivelyBlockedIndices = new HashSet<String>();
        HashMap<Index, AddIndexBlockResponse.AddBlockResult> blockingResults = new HashMap<Index, AddIndexBlockResponse.AddBlockResult>(verifyResult);
        for (Map.Entry<Index, AddIndexBlockResponse.AddBlockResult> result : verifyResult.entrySet()) {
            Index index = result.getKey();
            boolean acknowledged = !result.getValue().hasFailures();
            try {
                if (!acknowledged) {
                    logger.debug("verification of shards before blocking {} failed [{}]", (Object)index, result);
                    continue;
                }
                IndexMetadata indexMetadata = metadata.getSafe(index);
                ClusterBlock tempBlock = blockedIndices.get(index);
                assert (tempBlock != null);
                assert (tempBlock.uuid() != null);
                ClusterBlock currentBlock = currentState.blocks().getIndexBlockWithId(index.getName(), tempBlock.id());
                if (currentBlock != null && currentBlock.equals((Object)block.getBlock())) {
                    logger.debug("verification of shards for {} succeeded, but block finalization already occurred (possibly for another block) [{}]", (Object)index, result);
                    continue;
                }
                if (currentBlock == null || !currentBlock.equals((Object)tempBlock)) {
                    blockingResults.put(result.getKey(), new AddIndexBlockResponse.AddBlockResult(result.getKey(), (Exception)new IllegalStateException("verification of shards before blocking " + String.valueOf(index) + " succeeded but block has been removed in the meantime")));
                    logger.debug("verification of shards before blocking {} succeeded but block has been removed in the meantime", (Object)index);
                    continue;
                }
                assert (currentBlock != null && currentBlock.equals((Object)tempBlock) && currentBlock.id() == block.getBlock().id());
                blocks.removeIndexBlockWithId(index.getName(), tempBlock.id());
                blocks.addIndexBlock(index.getName(), block.getBlock());
                logger.debug("add block {} to index {} succeeded", (Object)block.getBlock(), (Object)index);
                effectivelyBlockedIndices.add(index.getName());
            }
            catch (IndexNotFoundException e) {
                logger.debug("index {} has been deleted since blocking it started, ignoring", (Object)index);
            }
        }
        logger.info("completed adding block {} to indices {}", (Object)block.getName(), effectivelyBlockedIndices);
        return Tuple.tuple((Object)ClusterState.builder((ClusterState)currentState).blocks(blocks).metadata(metadata).routingTable(routingTable.build()).build(), blockingResults.values());
    }

    public static ClusterBlock createIndexClosingBlock() {
        return new ClusterBlock(4, UUIDs.randomBase64UUID(), "index preparing to close. Reopen the index to allow writes again or retry closing the index to fully close the index.", false, false, false, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.WRITE));
    }

    public static ClusterBlock createUUIDBasedBlock(ClusterBlock clusterBlock) {
        assert (clusterBlock.uuid() == null) : "no UUID expected on source block";
        return new ClusterBlock(clusterBlock.id(), UUIDs.randomBase64UUID(), "moving to block " + clusterBlock.description(), clusterBlock.retryable(), clusterBlock.disableStatePersistence(), clusterBlock.isAllowReleaseResources(), clusterBlock.status(), clusterBlock.levels());
    }

    class WaitForBlocksApplied
    extends ActionRunnable<Map<Index, AddIndexBlockResponse.AddBlockResult>> {
        private final Map<Index, ClusterBlock> blockedIndices;
        private final AddIndexBlockClusterStateUpdateRequest request;

        private WaitForBlocksApplied(Map<Index, ClusterBlock> blockedIndices, AddIndexBlockClusterStateUpdateRequest request, ActionListener<Map<Index, AddIndexBlockResponse.AddBlockResult>> listener) {
            super(listener);
            if (blockedIndices == null || blockedIndices.isEmpty()) {
                throw new IllegalArgumentException("Cannot wait for blocks to be applied, list of blocked indices is empty or null");
            }
            this.blockedIndices = blockedIndices;
            this.request = request;
        }

        public void doRun() throws Exception {
            ConcurrentMap results = ConcurrentCollections.newConcurrentMap();
            CountDown countDown = new CountDown(this.blockedIndices.size());
            ClusterState state = MetadataIndexStateService.this.clusterService.state();
            this.blockedIndices.forEach((index, block) -> this.waitForShardsReady((Index)index, (ClusterBlock)block, state, response -> {
                results.put(index, response);
                if (countDown.countDown()) {
                    this.listener.onResponse(Collections.unmodifiableMap(results));
                }
            }));
        }

        private void waitForShardsReady(final Index index, ClusterBlock clusterBlock, ClusterState state, final Consumer<AddIndexBlockResponse.AddBlockResult> onResponse) {
            IndexMetadata indexMetadata = state.metadata().index(index);
            if (indexMetadata == null) {
                logger.debug("index {} has since been deleted, ignoring", (Object)index);
                onResponse.accept(new AddIndexBlockResponse.AddBlockResult(index));
                return;
            }
            IndexRoutingTable indexRoutingTable = state.routingTable().index(index);
            if (indexRoutingTable == null || indexMetadata.getState() == IndexMetadata.State.CLOSE) {
                logger.debug("index {} is closed, no need to wait for shards, ignoring", (Object)index);
                onResponse.accept(new AddIndexBlockResponse.AddBlockResult(index));
                return;
            }
            Map shards = indexRoutingTable.getShards();
            final AtomicArray results = new AtomicArray(shards.size());
            final CountDown countDown = new CountDown(shards.size());
            Iterator iterator = shards.values().iterator();
            while (iterator.hasNext()) {
                IndexShardRoutingTable shard;
                IndexShardRoutingTable shardRoutingTable = shard = (IndexShardRoutingTable)iterator.next();
                final int shardId = shardRoutingTable.shardId().id();
                this.sendVerifyShardBlockRequest(shardRoutingTable, clusterBlock, (ActionListener<ReplicationResponse>)new NotifyOnceListener<ReplicationResponse>(this){

                    public void innerOnResponse(ReplicationResponse replicationResponse) {
                        AddIndexBlockResponse.AddBlockShardResult.Failure[] failures = (AddIndexBlockResponse.AddBlockShardResult.Failure[])Arrays.stream(replicationResponse.getShardInfo().getFailures()).map(f -> new AddIndexBlockResponse.AddBlockShardResult.Failure(f.index(), f.shardId(), f.getCause(), f.nodeId())).toArray(AddIndexBlockResponse.AddBlockShardResult.Failure[]::new);
                        results.setOnce(shardId, (Object)new AddIndexBlockResponse.AddBlockShardResult(shardId, failures));
                        this.processIfFinished();
                    }

                    public void innerOnFailure(Exception e) {
                        AddIndexBlockResponse.AddBlockShardResult.Failure failure = new AddIndexBlockResponse.AddBlockShardResult.Failure(index.getName(), shardId, (Throwable)e);
                        results.setOnce(shardId, (Object)new AddIndexBlockResponse.AddBlockShardResult(shardId, new AddIndexBlockResponse.AddBlockShardResult.Failure[]{failure}));
                        this.processIfFinished();
                    }

                    private void processIfFinished() {
                        if (countDown.countDown()) {
                            onResponse.accept(new AddIndexBlockResponse.AddBlockResult(index, (AddIndexBlockResponse.AddBlockShardResult[])results.toArray((Object[])new AddIndexBlockResponse.AddBlockShardResult[results.length()])));
                        }
                    }
                });
            }
        }

        private void sendVerifyShardBlockRequest(IndexShardRoutingTable shardRoutingTable, ClusterBlock block, ActionListener<ReplicationResponse> listener) {
            ShardId shardId = shardRoutingTable.shardId();
            if (shardRoutingTable.primaryShard().unassigned()) {
                logger.debug("primary shard {} is unassigned, ignoring", (Object)shardId);
                ReplicationResponse response = new ReplicationResponse();
                response.setShardInfo(new ReplicationResponse.ShardInfo(shardRoutingTable.size(), shardRoutingTable.size(), new ReplicationResponse.ShardInfo.Failure[0]));
                listener.onResponse((Object)response);
                return;
            }
            TaskId parentTaskId = new TaskId(MetadataIndexStateService.this.clusterService.localNode().getId(), this.request.taskId());
            TransportVerifyShardIndexBlockAction.ShardRequest shardRequest = new TransportVerifyShardIndexBlockAction.ShardRequest(shardId, block, parentTaskId);
            if (this.request.ackTimeout() != null) {
                shardRequest.timeout(this.request.ackTimeout());
            }
            MetadataIndexStateService.this.transportVerifyShardIndexBlockAction.execute((ActionRequest)shardRequest, listener);
        }
    }

    class WaitForClosedBlocksApplied
    extends ActionRunnable<Map<Index, CloseIndexResponse.IndexResult>> {
        private final Map<Index, ClusterBlock> blockedIndices;
        private final CloseIndexClusterStateUpdateRequest request;

        private WaitForClosedBlocksApplied(Map<Index, ClusterBlock> blockedIndices, CloseIndexClusterStateUpdateRequest request, ActionListener<Map<Index, CloseIndexResponse.IndexResult>> listener) {
            super(listener);
            if (blockedIndices == null || blockedIndices.isEmpty()) {
                throw new IllegalArgumentException("Cannot wait for closed blocks to be applied, list of blocked indices is empty or null");
            }
            this.blockedIndices = blockedIndices;
            this.request = request;
        }

        public void doRun() throws Exception {
            ConcurrentMap results = ConcurrentCollections.newConcurrentMap();
            CountDown countDown = new CountDown(this.blockedIndices.size());
            ClusterState state = MetadataIndexStateService.this.clusterService.state();
            this.blockedIndices.forEach((index, block) -> this.waitForShardsReadyForClosing((Index)index, (ClusterBlock)block, state, response -> {
                results.put(index, response);
                if (countDown.countDown()) {
                    this.listener.onResponse(Collections.unmodifiableMap(results));
                }
            }));
        }

        private void waitForShardsReadyForClosing(final Index index, ClusterBlock closingBlock, ClusterState state, final Consumer<CloseIndexResponse.IndexResult> onResponse) {
            IndexMetadata indexMetadata = state.metadata().index(index);
            if (indexMetadata == null) {
                logger.debug("index {} has been blocked before closing and is now deleted, ignoring", (Object)index);
                onResponse.accept(new CloseIndexResponse.IndexResult(index));
                return;
            }
            IndexRoutingTable indexRoutingTable = state.routingTable().index(index);
            if (indexRoutingTable == null || indexMetadata.getState() == IndexMetadata.State.CLOSE) {
                assert (state.blocks().hasIndexBlock(index.getName(), IndexMetadata.INDEX_CLOSED_BLOCK));
                logger.debug("index {} has been blocked before closing and is already closed, ignoring", (Object)index);
                onResponse.accept(new CloseIndexResponse.IndexResult(index));
                return;
            }
            Map shards = indexRoutingTable.getShards();
            final AtomicArray results = new AtomicArray(shards.size());
            final CountDown countDown = new CountDown(shards.size());
            Iterator iterator = shards.values().iterator();
            while (iterator.hasNext()) {
                IndexShardRoutingTable shard;
                IndexShardRoutingTable shardRoutingTable = shard = (IndexShardRoutingTable)iterator.next();
                final int shardId = shardRoutingTable.shardId().id();
                this.sendVerifyShardBeforeCloseRequest(shardRoutingTable, closingBlock, (ActionListener<ReplicationResponse>)new NotifyOnceListener<ReplicationResponse>(this){

                    public void innerOnResponse(ReplicationResponse replicationResponse) {
                        CloseIndexResponse.ShardResult.Failure[] failures = (CloseIndexResponse.ShardResult.Failure[])Arrays.stream(replicationResponse.getShardInfo().getFailures()).map(f -> new CloseIndexResponse.ShardResult.Failure(f.index(), f.shardId(), f.getCause(), f.nodeId())).toArray(CloseIndexResponse.ShardResult.Failure[]::new);
                        results.setOnce(shardId, (Object)new CloseIndexResponse.ShardResult(shardId, failures));
                        this.processIfFinished();
                    }

                    public void innerOnFailure(Exception e) {
                        CloseIndexResponse.ShardResult.Failure failure = new CloseIndexResponse.ShardResult.Failure(index.getName(), shardId, (Throwable)e);
                        results.setOnce(shardId, (Object)new CloseIndexResponse.ShardResult(shardId, new CloseIndexResponse.ShardResult.Failure[]{failure}));
                        this.processIfFinished();
                    }

                    private void processIfFinished() {
                        if (countDown.countDown()) {
                            onResponse.accept(new CloseIndexResponse.IndexResult(index, (CloseIndexResponse.ShardResult[])results.toArray((Object[])new CloseIndexResponse.ShardResult[results.length()])));
                        }
                    }
                });
            }
        }

        private void sendVerifyShardBeforeCloseRequest(IndexShardRoutingTable shardRoutingTable, final ClusterBlock closingBlock, final ActionListener<ReplicationResponse> listener) {
            final ShardId shardId = shardRoutingTable.shardId();
            if (shardRoutingTable.primaryShard().unassigned()) {
                logger.debug("primary shard {} is unassigned, ignoring", (Object)shardId);
                ReplicationResponse response = new ReplicationResponse();
                response.setShardInfo(new ReplicationResponse.ShardInfo(shardRoutingTable.size(), shardRoutingTable.size(), new ReplicationResponse.ShardInfo.Failure[0]));
                listener.onResponse((Object)response);
                return;
            }
            final TaskId parentTaskId = new TaskId(MetadataIndexStateService.this.clusterService.localNode().getId(), this.request.taskId());
            TransportVerifyShardBeforeCloseAction.ShardRequest shardRequest = new TransportVerifyShardBeforeCloseAction.ShardRequest(shardId, closingBlock, true, parentTaskId);
            if (this.request.ackTimeout() != null) {
                shardRequest.timeout(this.request.ackTimeout());
            }
            MetadataIndexStateService.this.transportVerifyShardBeforeCloseAction.execute((ActionRequest)shardRequest, (ActionListener)new ActionListener<ReplicationResponse>(){

                public void onResponse(ReplicationResponse replicationResponse) {
                    TransportVerifyShardBeforeCloseAction.ShardRequest shardRequest = new TransportVerifyShardBeforeCloseAction.ShardRequest(shardId, closingBlock, false, parentTaskId);
                    if (WaitForClosedBlocksApplied.this.request.ackTimeout() != null) {
                        shardRequest.timeout(WaitForClosedBlocksApplied.this.request.ackTimeout());
                    }
                    MetadataIndexStateService.this.transportVerifyShardBeforeCloseAction.execute((ActionRequest)shardRequest, listener);
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        }
    }
}

