/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.metadata;

import io.skylite.Version;
import io.skylite.common.action.ActionListener;
import io.skylite.common.collect.Tuple;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.admin.indices.template.delete.DeleteIndexTemplateRequest;
import io.skylite.core.action.admin.indices.template.put.PutIndexTemplateRequest;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.block.ClusterBlocks;
import io.skylite.core.cluster.metadata.IndexTemplateMetadata;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateChangedEvent;
import io.skylite.core.cluster.state.ClusterStateListener;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentHelper;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.indices.IndexTemplateMissingException;

public class TemplateUpgradeService
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(TemplateUpgradeService.class);
    private final UnaryOperator<Map<String, IndexTemplateMetadata>> indexTemplateMetadataUpgraders;
    public final ClusterService clusterService;
    public final ThreadPool threadPool;
    public final Client client;
    final AtomicInteger upgradesInProgress = new AtomicInteger();
    private Map<String, IndexTemplateMetadata> lastTemplateMetadata;
    private static final ToXContent.Params PARAMS = new ToXContent.MapParams(Collections.singletonMap("reduce_mappings", "true"));

    public TemplateUpgradeService(Client client, ClusterService clusterService, ThreadPool threadPool, Collection<UnaryOperator<Map<String, IndexTemplateMetadata>>> indexTemplateMetadataUpgraders) {
        this.client = client;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.indexTemplateMetadataUpgraders = templates -> {
            Map upgradedTemplates = new HashMap(templates);
            for (UnaryOperator upgrader : indexTemplateMetadataUpgraders) {
                upgradedTemplates = (Map)upgrader.apply(upgradedTemplates);
            }
            return upgradedTemplates;
        };
        if (DiscoveryNode.isClusterManagerNode((Settings)clusterService.getSettings())) {
            clusterService.addListener((ClusterStateListener)this);
        }
    }

    public void clusterChanged(ClusterStateChangedEvent event) {
        ClusterState state = event.state();
        if (!state.nodes().isLocalNodeElectedClusterManager()) {
            return;
        }
        if (state.blocks().hasGlobalBlock(ClusterBlocks.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        if (this.upgradesInProgress.get() > 0) {
            return;
        }
        Map templates = state.getMetadata().getTemplates();
        if (templates == this.lastTemplateMetadata) {
            return;
        }
        this.lastTemplateMetadata = templates;
        Optional<Tuple<Map<String, BytesReference>, Set<String>>> changes = this.calculateTemplateChanges(templates);
        if (changes.isPresent() && this.upgradesInProgress.compareAndSet(0, ((Map)changes.get().v1()).size() + ((Set)changes.get().v2()).size() + 1)) {
            logger.info("Starting template upgrade to version {}, {} templates will be updated and {} will be removed", (Object)Version.CURRENT, (Object)((Map)changes.get().v1()).size(), (Object)((Set)changes.get().v2()).size());
            assert (this.threadPool.getThreadContext().isSystemContext());
            this.threadPool.generic().execute(() -> this.upgradeTemplates((Map)((Tuple)changes.get()).v1(), (Set)((Tuple)changes.get()).v2()));
        }
    }

    void upgradeTemplates(Map<String, BytesReference> changes, Set<String> deletions) {
        DeleteIndexTemplateRequest request;
        final AtomicBoolean anyUpgradeFailed = new AtomicBoolean(false);
        if (!this.threadPool.getThreadContext().isSystemContext()) {
            throw new IllegalStateException("template updates from the template upgrade service should always happen in a system context");
        }
        for (final Map.Entry<String, BytesReference> change : changes.entrySet()) {
            request = new PutIndexTemplateRequest(change.getKey()).source(change.getValue(), MediaTypeRegistry.JSON);
            request.clusterManagerNodeTimeout(TimeValue.timeValueMinutes((long)1L));
            this.client.admin().indices().putTemplate((PutIndexTemplateRequest)request, (ActionListener)new ActionListener<AcknowledgedResponse>(){

                public void onResponse(AcknowledgedResponse response) {
                    if (!response.isAcknowledged()) {
                        anyUpgradeFailed.set(true);
                        logger.warn("Error updating template [{}], request was not acknowledged", change.getKey());
                    }
                    TemplateUpgradeService.this.tryFinishUpgrade(anyUpgradeFailed);
                }

                public void onFailure(Exception e) {
                    anyUpgradeFailed.set(true);
                    logger.warn((Message)new ParameterizedMessage("Error updating template [{}]", change.getKey()), (Throwable)e);
                    TemplateUpgradeService.this.tryFinishUpgrade(anyUpgradeFailed);
                }
            });
        }
        for (final String template : deletions) {
            request = new DeleteIndexTemplateRequest(template);
            request.clusterManagerNodeTimeout(TimeValue.timeValueMinutes((long)1L));
            this.client.admin().indices().deleteTemplate(request, (ActionListener)new ActionListener<AcknowledgedResponse>(){

                public void onResponse(AcknowledgedResponse response) {
                    if (!response.isAcknowledged()) {
                        anyUpgradeFailed.set(true);
                        logger.warn("Error deleting template [{}], request was not acknowledged", (Object)template);
                    }
                    TemplateUpgradeService.this.tryFinishUpgrade(anyUpgradeFailed);
                }

                public void onFailure(Exception e) {
                    anyUpgradeFailed.set(true);
                    if (!(e instanceof IndexTemplateMissingException)) {
                        logger.warn((Message)new ParameterizedMessage("Error deleting template [{}]", (Object)template), (Throwable)e);
                    }
                    TemplateUpgradeService.this.tryFinishUpgrade(anyUpgradeFailed);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tryFinishUpgrade(AtomicBoolean anyUpgradeFailed) {
        assert (this.upgradesInProgress.get() > 0);
        if (this.upgradesInProgress.decrementAndGet() == 1) {
            try {
                if (anyUpgradeFailed.get()) {
                    logger.info("Templates were partially upgraded to version {}", (Object)Version.CURRENT);
                } else {
                    logger.info("Templates were upgraded successfully to version {}", (Object)Version.CURRENT);
                }
                Map upgradedTemplates = this.clusterService.state().getMetadata().getTemplates();
                boolean changesRequired = this.calculateTemplateChanges(upgradedTemplates).isPresent();
                if (changesRequired) {
                    logger.warn("Templates are still reported as out of date after the upgrade. The template upgrade will be retried.");
                }
            }
            finally {
                int noMoreUpgrades = this.upgradesInProgress.decrementAndGet();
                assert (noMoreUpgrades == 0);
            }
        }
    }

    Optional<Tuple<Map<String, BytesReference>, Set<String>>> calculateTemplateChanges(Map<String, IndexTemplateMetadata> templates) {
        HashMap<String, IndexTemplateMetadata> existingMap = new HashMap<String, IndexTemplateMetadata>();
        for (Map.Entry<String, IndexTemplateMetadata> customCursor : templates.entrySet()) {
            existingMap.put(customCursor.getKey(), customCursor.getValue());
        }
        Map upgradedMap = (Map)this.indexTemplateMetadataUpgraders.apply(existingMap);
        if (!upgradedMap.equals(existingMap)) {
            HashSet deletes = new HashSet();
            HashMap changes = new HashMap();
            existingMap.keySet().forEach(s -> {
                if (!upgradedMap.containsKey(s)) {
                    deletes.add(s);
                }
            });
            upgradedMap.forEach((key, value) -> {
                if (!value.equals(existingMap.get(key))) {
                    changes.put(key, this.toBytesReference((IndexTemplateMetadata)value));
                }
            });
            return Optional.of(new Tuple(changes, deletes));
        }
        return Optional.empty();
    }

    private BytesReference toBytesReference(IndexTemplateMetadata templateMetadata) {
        try {
            return XContentHelper.toXContent((builder, params) -> {
                IndexTemplateMetadata.Builder.toInnerXContentWithTypes((IndexTemplateMetadata)templateMetadata, (XContentBuilder)builder, (ToXContent.Params)params);
                return builder;
            }, (MediaType)MediaTypeRegistry.JSON, (ToXContent.Params)PARAMS, (boolean)false);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot serialize template [" + templateMetadata.getName() + "]", ex);
        }
    }
}

