/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing;

import io.skylite.common.lifecycle.AbstractLifecycleComponent;
import io.skylite.common.unit.TimeValue;
import io.skylite.common.util.concurrent.AbstractRunnable;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.routing.RoutingTable;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.routing.ShardRoutingState;
import io.skylite.core.cluster.routing.UnassignedInfo;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateChangedEvent;
import io.skylite.core.cluster.state.ClusterStateListener;
import io.skylite.core.cluster.state.ClusterStateTaskConfig;
import io.skylite.core.cluster.state.ClusterStateUpdateTask;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.Scheduler;
import io.skylite.core.threadpool.ThreadPool;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.routing.allocation.AllocationService;

public class DelayedAllocationService
extends AbstractLifecycleComponent
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(DelayedAllocationService.class);
    static final String CLUSTER_UPDATE_TASK_SOURCE = "delayed_allocation_reroute";
    final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final AllocationService allocationService;
    AtomicReference<DelayedRerouteTask> delayedRerouteTask = new AtomicReference();

    public static long findNextDelayedAllocation(long currentNanoTime, Metadata metadata, RoutingTable routingTable) {
        long nextDelayNanos = Long.MAX_VALUE;
        for (ShardRouting shard : routingTable.shardsWithState(ShardRoutingState.UNASSIGNED)) {
            Settings indexSettings;
            long newComputedLeftDelayNanos;
            UnassignedInfo unassignedInfo = shard.unassignedInfo();
            if (!unassignedInfo.isDelayed() || (newComputedLeftDelayNanos = unassignedInfo.getRemainingDelay(currentNanoTime, indexSettings = metadata.index(shard.index()).getSettings())) >= nextDelayNanos) continue;
            nextDelayNanos = newComputedLeftDelayNanos;
        }
        return nextDelayNanos == Long.MAX_VALUE ? -1L : nextDelayNanos;
    }

    public static int getNumberOfDelayedUnassigned(RoutingTable routingTable) {
        Predicate<ShardRouting> predicate = s -> s.state() == ShardRoutingState.UNASSIGNED && s.unassignedInfo().isDelayed();
        return routingTable.shardsMatchingPredicateCount(predicate);
    }

    @Inject
    public DelayedAllocationService(ThreadPool threadPool, ClusterService clusterService, AllocationService allocationService) {
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.allocationService = allocationService;
        if (DiscoveryNode.isClusterManagerNode((Settings)clusterService.getSettings())) {
            clusterService.addListener((ClusterStateListener)this);
        }
    }

    protected void doStart() {
    }

    protected void doStop() {
    }

    protected void doClose() {
        this.clusterService.removeListener((ClusterStateListener)this);
        this.removeTaskAndCancel();
    }

    protected long currentNanoTime() {
        return System.nanoTime();
    }

    public void clusterChanged(ClusterStateChangedEvent event) {
        if (event.localNodeClusterManager()) {
            long currentNanoTime = this.currentNanoTime();
            ClusterState state = event.state();
            this.scheduleIfNeeded(currentNanoTime, state.metadata(), state.routingTable());
        }
    }

    private void removeTaskAndCancel() {
        DelayedRerouteTask existingTask = this.delayedRerouteTask.getAndSet(null);
        if (existingTask != null) {
            logger.trace("cancelling existing delayed reroute task");
            existingTask.cancelScheduling();
        }
    }

    private void removeIfSameTask(DelayedRerouteTask expectedTask) {
        this.delayedRerouteTask.compareAndSet(expectedTask, null);
    }

    private synchronized void scheduleIfNeeded(long currentNanoTime, Metadata clusterMetadata, RoutingTable routingTable) {
        this.assertClusterOrClusterManagerStateThread();
        long nextDelayNanos = DelayedAllocationService.findNextDelayedAllocation(currentNanoTime, clusterMetadata, routingTable);
        if (nextDelayNanos < 0L) {
            logger.trace("no need to schedule reroute - no delayed unassigned shards");
            this.removeTaskAndCancel();
        } else {
            boolean earlierRerouteNeeded;
            TimeValue nextDelay = TimeValue.timeValueNanos((long)nextDelayNanos);
            DelayedRerouteTask existingTask = this.delayedRerouteTask.get();
            DelayedRerouteTask newTask = new DelayedRerouteTask(nextDelay, currentNanoTime);
            if (existingTask == null) {
                earlierRerouteNeeded = true;
            } else if (newTask.scheduledTimeToRunInNanos() < existingTask.scheduledTimeToRunInNanos()) {
                logger.trace("cancelling existing delayed reroute task as delayed reroute has to happen [{}] earlier", (Object)TimeValue.timeValueNanos((long)(existingTask.scheduledTimeToRunInNanos() - newTask.scheduledTimeToRunInNanos())));
                existingTask.cancelScheduling();
                earlierRerouteNeeded = true;
            } else {
                earlierRerouteNeeded = false;
            }
            if (earlierRerouteNeeded) {
                logger.info("scheduling reroute for delayed shards in [{}] ({} delayed shards)", (Object)nextDelay, (Object)DelayedAllocationService.getNumberOfDelayedUnassigned(routingTable));
                DelayedRerouteTask currentTask = this.delayedRerouteTask.getAndSet(newTask);
                assert (existingTask == currentTask || currentTask == null);
                newTask.schedule();
            } else {
                logger.trace("no need to reschedule delayed reroute - currently scheduled delayed reroute in [{}] is enough", (Object)nextDelay);
            }
        }
    }

    protected void assertClusterOrClusterManagerStateThread() {
        assert (ClusterService.assertClusterOrClusterManagerStateThread());
    }

    @Deprecated
    protected void assertClusterOrMasterStateThread() {
        this.assertClusterOrClusterManagerStateThread();
    }

    class DelayedRerouteTask
    extends ClusterStateUpdateTask {
        final TimeValue nextDelay;
        final long baseTimestampNanos;
        volatile Scheduler.Cancellable cancellable;
        final AtomicBoolean cancelScheduling = new AtomicBoolean();

        DelayedRerouteTask(TimeValue nextDelay, long baseTimestampNanos) {
            this.nextDelay = nextDelay;
            this.baseTimestampNanos = baseTimestampNanos;
        }

        public long scheduledTimeToRunInNanos() {
            return this.baseTimestampNanos + this.nextDelay.nanos();
        }

        public void cancelScheduling() {
            this.cancelScheduling.set(true);
            if (this.cancellable != null) {
                this.cancellable.cancel();
            }
            DelayedAllocationService.this.removeIfSameTask(this);
        }

        public void schedule() {
            this.cancellable = DelayedAllocationService.this.threadPool.schedule((Runnable)new AbstractRunnable(){

                public void doRun() throws Exception {
                    if (DelayedRerouteTask.this.cancelScheduling.get()) {
                        return;
                    }
                    DelayedAllocationService.this.clusterService.submitStateUpdateTask(DelayedAllocationService.CLUSTER_UPDATE_TASK_SOURCE, (ClusterStateTaskConfig)DelayedRerouteTask.this);
                }

                public void onFailure(Exception e) {
                    logger.warn("failed to submit schedule/execute reroute post unassigned shard", (Throwable)e);
                    DelayedAllocationService.this.removeIfSameTask(DelayedRerouteTask.this);
                }
            }, this.nextDelay, "same");
        }

        public ClusterState execute(ClusterState currentState) throws Exception {
            DelayedAllocationService.this.removeIfSameTask(this);
            return DelayedAllocationService.this.allocationService.reroute(currentState, "assign delayed unassigned shards");
        }

        public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
            if (oldState == newState) {
                DelayedAllocationService.this.scheduleIfNeeded(DelayedAllocationService.this.currentNanoTime(), newState.metadata(), newState.routingTable());
            }
        }

        public void onFailure(String source, Exception e) {
            DelayedAllocationService.this.removeIfSameTask(this);
            logger.warn("failed to schedule/execute reroute post unassigned shard", (Throwable)e);
        }
    }
}

