/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.allocation;

import io.skylite.core.cluster.routing.allocation.RoutingAllocationSettings;
import io.skylite.core.cluster.routing.allocation.decider.AllocationDeciderSettings;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.Settings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opensearch.cluster.metadata.AutoExpandReplicas;

public class AwarenessReplicaBalance {
    private volatile List<String> awarenessAttributes;
    private volatile Map<String, List<String>> forcedAwarenessAttributes;
    private volatile Boolean awarenessBalance;

    public AwarenessReplicaBalance(Settings settings, ClusterSettings clusterSettings) {
        this.awarenessAttributes = (List)AllocationDeciderSettings.CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(AllocationDeciderSettings.CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING, this::setAwarenessAttributes);
        this.setForcedAwarenessAttributes((Settings)AllocationDeciderSettings.CLUSTER_ROUTING_ALLOCATION_AWARENESS_FORCE_GROUP_SETTING.get(settings));
        clusterSettings.addSettingsUpdateConsumer(AllocationDeciderSettings.CLUSTER_ROUTING_ALLOCATION_AWARENESS_FORCE_GROUP_SETTING, this::setForcedAwarenessAttributes);
        this.setAwarenessBalance((Boolean)RoutingAllocationSettings.CLUSTER_ROUTING_ALLOCATION_AWARENESS_BALANCE_SETTING.get(settings));
        clusterSettings.addSettingsUpdateConsumer(RoutingAllocationSettings.CLUSTER_ROUTING_ALLOCATION_AWARENESS_BALANCE_SETTING, this::setAwarenessBalance);
    }

    private void setAwarenessBalance(Boolean awarenessBalance) {
        this.awarenessBalance = awarenessBalance;
    }

    private void setForcedAwarenessAttributes(Settings forceSettings) {
        HashMap<String, List<String>> forcedAwarenessAttributes = new HashMap<String, List<String>>();
        Map forceGroups = forceSettings.getAsGroups();
        for (Map.Entry entry : forceGroups.entrySet()) {
            List aValues = ((Settings)entry.getValue()).getAsList("values");
            if (aValues.size() <= 0) continue;
            forcedAwarenessAttributes.put((String)entry.getKey(), aValues);
        }
        this.forcedAwarenessAttributes = forcedAwarenessAttributes;
    }

    private void setAwarenessAttributes(List<String> awarenessAttributes) {
        this.awarenessAttributes = awarenessAttributes;
    }

    public int maxAwarenessAttributes() {
        int awarenessAttributes = 1;
        if (!this.awarenessBalance.booleanValue()) {
            return awarenessAttributes;
        }
        for (String awarenessAttribute : this.awarenessAttributes) {
            if (!this.forcedAwarenessAttributes.containsKey(awarenessAttribute)) continue;
            awarenessAttributes = Math.max(awarenessAttributes, this.forcedAwarenessAttributes.get(awarenessAttribute).size());
        }
        return awarenessAttributes;
    }

    public Optional<String> validate(int replicaCount, AutoExpandReplicas autoExpandReplica) {
        if (autoExpandReplica.isEnabled()) {
            if (autoExpandReplica.getMaxReplicas() != Integer.MAX_VALUE && (autoExpandReplica.getMaxReplicas() + 1) % this.maxAwarenessAttributes() != 0) {
                String errorMessage = "expected max cap on auto expand to be a multiple of total awareness attributes [" + this.maxAwarenessAttributes() + "]";
                return Optional.of(errorMessage);
            }
        } else if ((replicaCount + 1) % this.maxAwarenessAttributes() != 0) {
            String errorMessage = "expected total copies needs to be a multiple of total awareness attributes [" + this.maxAwarenessAttributes() + "]";
            return Optional.of(errorMessage);
        }
        return Optional.empty();
    }
}

