/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.allocation;

import io.skylite.LuceniaVersion;
import io.skylite.SkyliteParseException;
import io.skylite.Version;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.common.Strings;
import io.skylite.core.common.unit.ByteSizeValue;
import io.skylite.core.common.unit.RatioValue;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.spi.SettingsProvider;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DiskThresholdSettings {
    public static final Setting<Boolean> CLUSTER_ROUTING_ALLOCATION_DISK_THRESHOLD_ENABLED_SETTING = Setting.boolSetting((String)"cluster.routing.allocation.disk.threshold_enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<String> CLUSTER_ROUTING_ALLOCATION_LOW_DISK_WATERMARK_SETTING = new Setting("cluster.routing.allocation.disk.watermark.low", "85%", s -> DiskThresholdSettings.validWatermarkSetting(s, "cluster.routing.allocation.disk.watermark.low"), (Setting.Validator)new LowDiskWatermarkValidator(), new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<String> CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING = new Setting("cluster.routing.allocation.disk.watermark.high", "90%", s -> DiskThresholdSettings.validWatermarkSetting(s, "cluster.routing.allocation.disk.watermark.high"), (Setting.Validator)new HighDiskWatermarkValidator(), new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<String> CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING = new Setting("cluster.routing.allocation.disk.watermark.flood_stage", "95%", s -> DiskThresholdSettings.validWatermarkSetting(s, "cluster.routing.allocation.disk.watermark.flood_stage"), (Setting.Validator)new FloodStageValidator(), new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<Boolean> CLUSTER_ROUTING_ALLOCATION_INCLUDE_RELOCATIONS_SETTING = Setting.boolSetting((String)"cluster.routing.allocation.disk.include_relocations", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.Deprecated});
    public static final Setting<TimeValue> CLUSTER_ROUTING_ALLOCATION_REROUTE_INTERVAL_SETTING = Setting.positiveTimeSetting((String)"cluster.routing.allocation.disk.reroute_interval", (TimeValue)TimeValue.timeValueSeconds((long)60L), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<Boolean> CLUSTER_CREATE_INDEX_BLOCK_AUTO_RELEASE = Setting.boolSetting((String)"cluster.blocks.create_index.auto_release", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private volatile String lowWatermarkRaw;
    private volatile String highWatermarkRaw;
    private volatile Double freeDiskThresholdLow;
    private volatile Double freeDiskThresholdHigh;
    private volatile ByteSizeValue freeBytesThresholdLow;
    private volatile ByteSizeValue freeBytesThresholdHigh;
    private volatile boolean includeRelocations;
    private volatile boolean createIndexBlockAutoReleaseEnabled;
    private volatile boolean enabled;
    private volatile TimeValue rerouteInterval;
    private volatile Double freeDiskThresholdFloodStage;
    private volatile ByteSizeValue freeBytesThresholdFloodStage;

    public DiskThresholdSettings(Settings settings, ClusterSettings clusterSettings) {
        String lowWatermark = (String)CLUSTER_ROUTING_ALLOCATION_LOW_DISK_WATERMARK_SETTING.get(settings);
        String highWatermark = (String)CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING.get(settings);
        String floodStage = (String)CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING.get(settings);
        this.setHighWatermark(highWatermark);
        this.setLowWatermark(lowWatermark);
        this.setFloodStage(floodStage);
        this.includeRelocations = (Boolean)CLUSTER_ROUTING_ALLOCATION_INCLUDE_RELOCATIONS_SETTING.get(settings);
        this.rerouteInterval = (TimeValue)CLUSTER_ROUTING_ALLOCATION_REROUTE_INTERVAL_SETTING.get(settings);
        this.enabled = (Boolean)CLUSTER_ROUTING_ALLOCATION_DISK_THRESHOLD_ENABLED_SETTING.get(settings);
        this.createIndexBlockAutoReleaseEnabled = (Boolean)CLUSTER_CREATE_INDEX_BLOCK_AUTO_RELEASE.get(settings);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_ALLOCATION_LOW_DISK_WATERMARK_SETTING, this::setLowWatermark);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING, this::setHighWatermark);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING, this::setFloodStage);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_ALLOCATION_INCLUDE_RELOCATIONS_SETTING, this::setIncludeRelocations);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_ALLOCATION_REROUTE_INTERVAL_SETTING, this::setRerouteInterval);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_ALLOCATION_DISK_THRESHOLD_ENABLED_SETTING, this::setEnabled);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_CREATE_INDEX_BLOCK_AUTO_RELEASE, this::setCreateIndexBlockAutoReleaseEnabled);
    }

    private static void doValidate(String low, String high, String flood) {
        try {
            DiskThresholdSettings.doValidateAsPercentage(low, high, flood);
            return;
        }
        catch (SkyliteParseException skyliteParseException) {
            try {
                DiskThresholdSettings.doValidateAsBytes(low, high, flood);
            }
            catch (SkyliteParseException e) {
                String message = String.format(Locale.ROOT, "unable to consistently parse [%s=%s], [%s=%s], and [%s=%s] as percentage or bytes", CLUSTER_ROUTING_ALLOCATION_LOW_DISK_WATERMARK_SETTING.getKey(), low, CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING.getKey(), high, CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING.getKey(), flood);
                throw new IllegalArgumentException(message, e);
            }
            return;
        }
    }

    private static void doValidateAsPercentage(String low, String high, String flood) {
        double lowWatermarkThreshold = DiskThresholdSettings.thresholdPercentageFromWatermark(low, false);
        double highWatermarkThreshold = DiskThresholdSettings.thresholdPercentageFromWatermark(high, false);
        double floodThreshold = DiskThresholdSettings.thresholdPercentageFromWatermark(flood, false);
        if (lowWatermarkThreshold > highWatermarkThreshold) {
            throw new IllegalArgumentException("low disk watermark [" + low + "] more than high disk watermark [" + high + "]");
        }
        if (highWatermarkThreshold > floodThreshold) {
            throw new IllegalArgumentException("high disk watermark [" + high + "] more than flood stage disk watermark [" + flood + "]");
        }
    }

    private static void doValidateAsBytes(String low, String high, String flood) {
        ByteSizeValue lowWatermarkBytes = DiskThresholdSettings.thresholdBytesFromWatermark(low, CLUSTER_ROUTING_ALLOCATION_LOW_DISK_WATERMARK_SETTING.getKey(), false);
        ByteSizeValue highWatermarkBytes = DiskThresholdSettings.thresholdBytesFromWatermark(high, CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING.getKey(), false);
        ByteSizeValue floodStageBytes = DiskThresholdSettings.thresholdBytesFromWatermark(flood, CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING.getKey(), false);
        if (lowWatermarkBytes.getBytes() < highWatermarkBytes.getBytes()) {
            throw new IllegalArgumentException("low disk watermark [" + low + "] less than high disk watermark [" + high + "]");
        }
        if (highWatermarkBytes.getBytes() < floodStageBytes.getBytes()) {
            throw new IllegalArgumentException("high disk watermark [" + high + "] less than flood stage disk watermark [" + flood + "]");
        }
    }

    private void setIncludeRelocations(boolean includeRelocations) {
        this.includeRelocations = includeRelocations;
    }

    private void setRerouteInterval(TimeValue rerouteInterval) {
        this.rerouteInterval = rerouteInterval;
    }

    private void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    private void setLowWatermark(String lowWatermark) {
        this.lowWatermarkRaw = lowWatermark;
        this.freeDiskThresholdLow = 100.0 - DiskThresholdSettings.thresholdPercentageFromWatermark(lowWatermark);
        this.freeBytesThresholdLow = DiskThresholdSettings.thresholdBytesFromWatermark(lowWatermark, CLUSTER_ROUTING_ALLOCATION_LOW_DISK_WATERMARK_SETTING.getKey());
    }

    private void setHighWatermark(String highWatermark) {
        this.highWatermarkRaw = highWatermark;
        this.freeDiskThresholdHigh = 100.0 - DiskThresholdSettings.thresholdPercentageFromWatermark(highWatermark);
        this.freeBytesThresholdHigh = DiskThresholdSettings.thresholdBytesFromWatermark(highWatermark, CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING.getKey());
    }

    private void setFloodStage(String floodStageRaw) {
        this.freeDiskThresholdFloodStage = 100.0 - DiskThresholdSettings.thresholdPercentageFromWatermark(floodStageRaw);
        this.freeBytesThresholdFloodStage = DiskThresholdSettings.thresholdBytesFromWatermark(floodStageRaw, CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING.getKey());
    }

    private void setCreateIndexBlockAutoReleaseEnabled(boolean createIndexBlockAutoReleaseEnabled) {
        this.createIndexBlockAutoReleaseEnabled = createIndexBlockAutoReleaseEnabled;
    }

    public String getLowWatermarkRaw() {
        return this.lowWatermarkRaw;
    }

    public String getHighWatermarkRaw() {
        return this.highWatermarkRaw;
    }

    public Double getFreeDiskThresholdLow() {
        return this.freeDiskThresholdLow;
    }

    public Double getFreeDiskThresholdHigh() {
        return this.freeDiskThresholdHigh;
    }

    public ByteSizeValue getFreeBytesThresholdLow() {
        return this.freeBytesThresholdLow;
    }

    public ByteSizeValue getFreeBytesThresholdHigh() {
        return this.freeBytesThresholdHigh;
    }

    public Double getFreeDiskThresholdFloodStage() {
        return this.freeDiskThresholdFloodStage;
    }

    public ByteSizeValue getFreeBytesThresholdFloodStage() {
        return this.freeBytesThresholdFloodStage;
    }

    public boolean includeRelocations() {
        return this.includeRelocations;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public TimeValue getRerouteInterval() {
        return this.rerouteInterval;
    }

    public boolean isCreateIndexBlockAutoReleaseEnabled() {
        return this.createIndexBlockAutoReleaseEnabled;
    }

    String describeLowThreshold() {
        return this.freeBytesThresholdLow.equals((Object)ByteSizeValue.ZERO) ? Strings.format1Decimals((double)(100.0 - this.freeDiskThresholdLow), (String)"%") : this.freeBytesThresholdLow.toString();
    }

    String describeHighThreshold() {
        return this.freeBytesThresholdHigh.equals((Object)ByteSizeValue.ZERO) ? Strings.format1Decimals((double)(100.0 - this.freeDiskThresholdHigh), (String)"%") : this.freeBytesThresholdHigh.toString();
    }

    String describeFloodStageThreshold() {
        return this.freeBytesThresholdFloodStage.equals((Object)ByteSizeValue.ZERO) ? Strings.format1Decimals((double)(100.0 - this.freeDiskThresholdFloodStage), (String)"%") : this.freeBytesThresholdFloodStage.toString();
    }

    private static double thresholdPercentageFromWatermark(String watermark) {
        return DiskThresholdSettings.thresholdPercentageFromWatermark(watermark, true);
    }

    private static double thresholdPercentageFromWatermark(String watermark, boolean lenient) {
        try {
            return RatioValue.parseRatioValue((String)watermark).getAsPercent();
        }
        catch (SkyliteParseException ex) {
            if (lenient) {
                return 100.0;
            }
            throw ex;
        }
    }

    private static ByteSizeValue thresholdBytesFromWatermark(String watermark, String settingName) {
        return DiskThresholdSettings.thresholdBytesFromWatermark(watermark, settingName, true);
    }

    private static ByteSizeValue thresholdBytesFromWatermark(String watermark, String settingName, boolean lenient) {
        try {
            return ByteSizeValue.parseBytesSizeValue((String)watermark, (String)settingName);
        }
        catch (SkyliteParseException ex) {
            if (lenient) {
                return ByteSizeValue.parseBytesSizeValue((String)"0b", (String)settingName);
            }
            throw ex;
        }
    }

    private static String validWatermarkSetting(String watermark, String settingName) {
        try {
            RatioValue.parseRatioValue((String)watermark);
        }
        catch (SkyliteParseException e) {
            try {
                ByteSizeValue.parseBytesSizeValue((String)watermark, (String)settingName);
            }
            catch (SkyliteParseException ex) {
                ex.addSuppressed((Throwable)e);
                throw ex;
            }
        }
        return watermark;
    }

    static {
        assert (Version.CURRENT.major >= LuceniaVersion.V_0_1_0.major);
        String AUTO_RELEASE_INDEX_ENABLED_KEY = "opensearch.disk.auto_release_flood_stage_block";
        String property = System.getProperty("opensearch.disk.auto_release_flood_stage_block");
        if (property != null) {
            throw new IllegalArgumentException("system property [opensearch.disk.auto_release_flood_stage_block] has been removed in 3.0.0 and is not supported anymore");
        }
    }

    static final class LowDiskWatermarkValidator
    implements Setting.Validator<String> {
        LowDiskWatermarkValidator() {
        }

        public void validate(String value) {
        }

        public void validate(String value, Map<Setting<?>, Object> settings) {
            String highWatermarkRaw = (String)settings.get(CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING);
            String floodStageRaw = (String)settings.get(CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING);
            DiskThresholdSettings.doValidate(value, highWatermarkRaw, floodStageRaw);
        }

        public Iterator<Setting<?>> settings() {
            List<Setting> settings = Arrays.asList(CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING, CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING);
            return settings.iterator();
        }
    }

    static final class HighDiskWatermarkValidator
    implements Setting.Validator<String> {
        HighDiskWatermarkValidator() {
        }

        public void validate(String value) {
        }

        public void validate(String value, Map<Setting<?>, Object> settings) {
            String lowWatermarkRaw = (String)settings.get(CLUSTER_ROUTING_ALLOCATION_LOW_DISK_WATERMARK_SETTING);
            String floodStageRaw = (String)settings.get(CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING);
            DiskThresholdSettings.doValidate(lowWatermarkRaw, value, floodStageRaw);
        }

        public Iterator<Setting<?>> settings() {
            List<Setting> settings = Arrays.asList(CLUSTER_ROUTING_ALLOCATION_LOW_DISK_WATERMARK_SETTING, CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING);
            return settings.iterator();
        }
    }

    static final class FloodStageValidator
    implements Setting.Validator<String> {
        FloodStageValidator() {
        }

        public void validate(String value) {
        }

        public void validate(String value, Map<Setting<?>, Object> settings) {
            String lowWatermarkRaw = (String)settings.get(CLUSTER_ROUTING_ALLOCATION_LOW_DISK_WATERMARK_SETTING);
            String highWatermarkRaw = (String)settings.get(CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING);
            DiskThresholdSettings.doValidate(lowWatermarkRaw, highWatermarkRaw, value);
        }

        public Iterator<Setting<?>> settings() {
            List<Setting> settings = Arrays.asList(CLUSTER_ROUTING_ALLOCATION_LOW_DISK_WATERMARK_SETTING, CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING);
            return settings.iterator();
        }
    }

    public static final class SettingsProviderImpl
    implements SettingsProvider {
        public List<? extends Setting<?>> getSettings() {
            return Arrays.asList(CLUSTER_ROUTING_ALLOCATION_LOW_DISK_WATERMARK_SETTING, CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING, CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING, CLUSTER_ROUTING_ALLOCATION_DISK_THRESHOLD_ENABLED_SETTING, CLUSTER_CREATE_INDEX_BLOCK_AUTO_RELEASE, CLUSTER_ROUTING_ALLOCATION_INCLUDE_RELOCATIONS_SETTING, CLUSTER_ROUTING_ALLOCATION_REROUTE_INTERVAL_SETTING);
        }
    }
}

