/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.allocation;

import io.skylite.core.cluster.routing.RoutingNodes;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.routing.allocation.AllocateUnassignedDecision;
import io.skylite.core.cluster.routing.allocation.FailedShard;
import io.skylite.core.cluster.routing.allocation.RoutingAllocation;
import io.skylite.core.cluster.routing.allocation.UnassignedAllocationHandler;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.spi.SettingsProvider;
import java.util.Arrays;
import java.util.List;

public interface ExistingShardsAllocator {
    public static final String GATEWAY_ALLOCATOR_NAME = "gateway_allocator";
    public static final Setting<String> EXISTING_SHARDS_ALLOCATOR_SETTING = Setting.simpleString((String)"index.allocation.existing_shards_allocator", (String)"gateway_allocator", (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.PrivateIndex});
    public static final Setting<Boolean> EXISTING_SHARDS_ALLOCATOR_BATCH_MODE = Setting.boolSetting((String)"cluster.allocator.existing_shards_allocator.batch_enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});

    public void beforeAllocation(RoutingAllocation var1);

    public void afterPrimariesBeforeReplicas(RoutingAllocation var1);

    public void allocateUnassigned(ShardRouting var1, RoutingAllocation var2, UnassignedAllocationHandler var3);

    default public void allocateAllUnassignedShards(RoutingAllocation allocation, boolean primary) {
        RoutingNodes.UnassignedShards.UnassignedIterator iterator = allocation.routingNodes().unassigned().iterator();
        while (iterator.hasNext()) {
            ShardRouting shardRouting = iterator.next();
            if (shardRouting.primary() != primary) continue;
            this.allocateUnassigned(shardRouting, allocation, (UnassignedAllocationHandler)iterator);
        }
    }

    public AllocateUnassignedDecision explainUnassignedShardAllocation(ShardRouting var1, RoutingAllocation var2);

    public void cleanCaches();

    public void applyStartedShards(List<ShardRouting> var1, RoutingAllocation var2);

    public void applyFailedShards(List<FailedShard> var1, RoutingAllocation var2);

    public int getNumberOfInFlightFetches();

    public static class SettingsProviderImpl
    implements SettingsProvider {
        public List<? extends Setting<?>> getSettings() {
            return Arrays.asList(EXISTING_SHARDS_ALLOCATOR_SETTING, EXISTING_SHARDS_ALLOCATOR_BATCH_MODE);
        }
    }
}

