/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.allocation.decider;

import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.routing.RoutingNode;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.routing.allocation.RoutingAllocation;
import io.skylite.core.cluster.routing.allocation.decider.AllocationDecider;
import io.skylite.core.cluster.routing.allocation.decider.AllocationDeciderSettings;
import io.skylite.core.cluster.routing.allocation.decider.Decision;
import io.skylite.core.common.Strings;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.Settings;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AwarenessAllocationDecider
extends AllocationDecider {
    public static final String NAME = "awareness";
    private volatile List<String> awarenessAttributes;
    private volatile Map<String, List<String>> forcedAwarenessAttributes;

    public AwarenessAllocationDecider(Settings settings, ClusterSettings clusterSettings) {
        this.awarenessAttributes = (List)AllocationDeciderSettings.CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(AllocationDeciderSettings.CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING, this::setAwarenessAttributes);
        this.setForcedAwarenessAttributes((Settings)AllocationDeciderSettings.CLUSTER_ROUTING_ALLOCATION_AWARENESS_FORCE_GROUP_SETTING.get(settings));
        clusterSettings.addSettingsUpdateConsumer(AllocationDeciderSettings.CLUSTER_ROUTING_ALLOCATION_AWARENESS_FORCE_GROUP_SETTING, this::setForcedAwarenessAttributes);
    }

    private void setForcedAwarenessAttributes(Settings forceSettings) {
        HashMap<String, List<String>> forcedAwarenessAttributes = new HashMap<String, List<String>>();
        Map forceGroups = forceSettings.getAsGroups();
        for (Map.Entry entry : forceGroups.entrySet()) {
            List aValues = ((Settings)entry.getValue()).getAsList("values");
            if (aValues.size() <= 0) continue;
            forcedAwarenessAttributes.put((String)entry.getKey(), aValues);
        }
        this.forcedAwarenessAttributes = forcedAwarenessAttributes;
    }

    private void setAwarenessAttributes(List<String> awarenessAttributes) {
        this.awarenessAttributes = awarenessAttributes;
    }

    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.underCapacity(shardRouting, node, allocation, true);
    }

    public Decision canRemain(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.underCapacity(shardRouting, node, allocation, false);
    }

    private Decision underCapacity(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation, boolean moveToNode) {
        if (this.awarenessAttributes.isEmpty()) {
            return allocation.decision(Decision.YES, NAME, "allocation awareness is not enabled, set cluster setting [%s] to enable it", new Object[]{AllocationDeciderSettings.CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING.getKey()});
        }
        IndexMetadata indexMetadata = allocation.metadata().getIndexSafe(shardRouting.index());
        int shardCount = indexMetadata.getNumberOfReplicas() + 1;
        for (String awarenessAttribute : this.awarenessAttributes) {
            int maximumNodeCount;
            int currentNodeCount;
            if (!node.node().getAttributes().containsKey(awarenessAttribute)) {
                return allocation.decision(Decision.NO, NAME, "node does not contain the awareness attribute [%s]; required attributes cluster setting [%s=%s]", new Object[]{awarenessAttribute, AllocationDeciderSettings.CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING.getKey(), allocation.debugDecision() ? Strings.collectionToCommaDelimitedString(this.awarenessAttributes) : null});
            }
            Set nodesPerAttribute = allocation.routingNodes().nodesPerAttributesCounts(awarenessAttribute);
            HashMap<String, Integer> shardPerAttribute = new HashMap<String, Integer>();
            for (ShardRouting assignedShard : allocation.routingNodes().assignedShards(shardRouting.shardId())) {
                if (!assignedShard.started() && !assignedShard.initializing()) continue;
                RoutingNode routingNode = allocation.routingNodes().node(assignedShard.currentNodeId());
                shardPerAttribute.merge((String)routingNode.node().getAttributes().get(awarenessAttribute), 1, Integer::sum);
            }
            if (moveToNode) {
                if (shardRouting.assignedToNode()) {
                    String nodeId;
                    String string = nodeId = shardRouting.relocating() ? shardRouting.relocatingNodeId() : shardRouting.currentNodeId();
                    if (!node.nodeId().equals(nodeId)) {
                        shardPerAttribute.compute((String)allocation.routingNodes().node(nodeId).node().getAttributes().get(awarenessAttribute), (k, v) -> v == null ? 0 : v - 1);
                        shardPerAttribute.merge((String)node.node().getAttributes().get(awarenessAttribute), 1, Integer::sum);
                    }
                } else {
                    shardPerAttribute.merge((String)node.node().getAttributes().get(awarenessAttribute), 1, Integer::sum);
                }
            }
            int numberOfAttributes = nodesPerAttribute.size();
            List<String> fullValues = this.forcedAwarenessAttributes.get(awarenessAttribute);
            if (fullValues != null) {
                HashSet<String> attributesSet = new HashSet<String>(fullValues);
                for (String stringObjectCursor : nodesPerAttribute) {
                    attributesSet.add(stringObjectCursor);
                }
                numberOfAttributes = attributesSet.size();
            }
            if ((currentNodeCount = ((Integer)shardPerAttribute.get(node.node().getAttributes().get(awarenessAttribute))).intValue()) <= (maximumNodeCount = (shardCount + numberOfAttributes - 1) / numberOfAttributes)) continue;
            return allocation.decision(Decision.NO, NAME, "there are too many copies of the shard allocated to nodes with attribute [%s], there are [%d] total configured shard copies for this shard id and [%d] total attribute values, expected the allocated shard count per attribute [%d] to be less than or equal to the upper bound of the required number of shards per attribute [%d]", new Object[]{awarenessAttribute, shardCount, numberOfAttributes, currentNodeCount, maximumNodeCount});
        }
        return allocation.decision(Decision.YES, NAME, "node meets all awareness attribute requirements", new Object[0]);
    }
}

