/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.allocation.decider;

import io.skylite.core.cluster.routing.RoutingNode;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.routing.allocation.RoutingAllocation;
import io.skylite.core.cluster.routing.allocation.decider.AllocationDecider;
import io.skylite.core.cluster.routing.allocation.decider.AllocationDeciderSettings;
import io.skylite.core.cluster.routing.allocation.decider.Decision;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.Settings;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConcurrentRecoveriesAllocationDecider
extends AllocationDecider {
    private static final Logger logger = LogManager.getLogger(ConcurrentRecoveriesAllocationDecider.class);
    public static final String NAME = "cluster_concurrent_recoveries";
    private volatile int clusterConcurrentRecoveries;

    public ConcurrentRecoveriesAllocationDecider(Settings settings, ClusterSettings clusterSettings) {
        this.clusterConcurrentRecoveries = (Integer)AllocationDeciderSettings.CLUSTER_ROUTING_ALLOCATION_CLUSTER_CONCURRENT_RECOVERIES_SETTING.get(settings);
        logger.debug("using [cluster_concurrent_rebalance] with [{}]", (Object)this.clusterConcurrentRecoveries);
        clusterSettings.addSettingsUpdateConsumer(AllocationDeciderSettings.CLUSTER_ROUTING_ALLOCATION_CLUSTER_CONCURRENT_RECOVERIES_SETTING, this::setClusterConcurrentRebalance);
    }

    private void setClusterConcurrentRebalance(int clusterConcurrentRecoveries) {
        this.clusterConcurrentRecoveries = clusterConcurrentRecoveries;
    }

    public Decision canMoveAnyShard(RoutingAllocation allocation) {
        if (this.clusterConcurrentRecoveries == -1) {
            return allocation.decision(Decision.YES, NAME, "undefined cluster concurrent recoveries", new Object[0]);
        }
        int relocatingShards = allocation.routingNodes().getRelocatingShardCount();
        if (relocatingShards >= this.clusterConcurrentRecoveries) {
            return allocation.decision(Decision.THROTTLE, NAME, "too many shards are concurrently relocating [%d], limit: [%d] cluster setting [%s=%d]", new Object[]{relocatingShards, this.clusterConcurrentRecoveries, AllocationDeciderSettings.CLUSTER_ROUTING_ALLOCATION_CLUSTER_CONCURRENT_RECOVERIES_SETTING.getKey(), this.clusterConcurrentRecoveries});
        }
        return allocation.decision(Decision.YES, NAME, "below threshold [%d] for concurrent recoveries, current relocating shard count [%d]", new Object[]{this.clusterConcurrentRecoveries, relocatingShards});
    }

    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.canMoveAnyShard(allocation);
    }
}

