/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.allocation.decider;

import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.routing.RecoverySource;
import io.skylite.core.cluster.routing.RoutingNode;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.routing.allocation.RoutingAllocation;
import io.skylite.core.cluster.routing.allocation.decider.AllocationDecider;
import io.skylite.core.cluster.routing.allocation.decider.AllocationDeciderSettings;
import io.skylite.core.cluster.routing.allocation.decider.Decision;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.Settings;
import java.util.Locale;

public class EnableAllocationDecider
extends AllocationDecider {
    public static final String NAME = "enable";
    private volatile AllocationDeciderSettings.Rebalance enableRebalance;
    private volatile AllocationDeciderSettings.Allocation enableAllocation;

    public EnableAllocationDecider(Settings settings, ClusterSettings clusterSettings) {
        this.enableAllocation = (AllocationDeciderSettings.Allocation)AllocationDeciderSettings.CLUSTER_ROUTING_ALLOCATION_ENABLE_SETTING.get(settings);
        this.enableRebalance = (AllocationDeciderSettings.Rebalance)AllocationDeciderSettings.CLUSTER_ROUTING_REBALANCE_ENABLE_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(AllocationDeciderSettings.CLUSTER_ROUTING_ALLOCATION_ENABLE_SETTING, this::setEnableAllocation);
        clusterSettings.addSettingsUpdateConsumer(AllocationDeciderSettings.CLUSTER_ROUTING_REBALANCE_ENABLE_SETTING, this::setEnableRebalance);
    }

    private void setEnableRebalance(AllocationDeciderSettings.Rebalance enableRebalance) {
        this.enableRebalance = enableRebalance;
    }

    private void setEnableAllocation(AllocationDeciderSettings.Allocation enableAllocation) {
        this.enableAllocation = enableAllocation;
    }

    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.canAllocate(shardRouting, allocation);
    }

    public Decision canAllocate(ShardRouting shardRouting, RoutingAllocation allocation) {
        boolean usedIndexSetting;
        AllocationDeciderSettings.Allocation enable;
        if (allocation.ignoreDisable()) {
            return allocation.decision(Decision.YES, NAME, "explicitly ignoring any disabling of allocation due to manual allocation commands via the reroute API", new Object[0]);
        }
        IndexMetadata indexMetadata = allocation.metadata().getIndexSafe(shardRouting.index());
        if (AllocationDeciderSettings.INDEX_ROUTING_ALLOCATION_ENABLE_SETTING.exists(indexMetadata.getSettings())) {
            enable = (AllocationDeciderSettings.Allocation)AllocationDeciderSettings.INDEX_ROUTING_ALLOCATION_ENABLE_SETTING.get(indexMetadata.getSettings());
            usedIndexSetting = true;
        } else {
            enable = this.enableAllocation;
            usedIndexSetting = false;
        }
        switch (enable) {
            case ALL: {
                return allocation.decision(Decision.YES, NAME, "all allocations are allowed", new Object[0]);
            }
            case NONE: {
                return allocation.decision(Decision.NO, NAME, "no allocations are allowed due to %s", new Object[]{EnableAllocationDecider.setting(enable, usedIndexSetting)});
            }
            case NEW_PRIMARIES: {
                if (shardRouting.primary() && !shardRouting.active() && shardRouting.recoverySource().getType() != RecoverySource.Type.EXISTING_STORE) {
                    return allocation.decision(Decision.YES, NAME, "new primary allocations are allowed", new Object[0]);
                }
                return allocation.decision(Decision.NO, NAME, "non-new primary allocations are forbidden due to %s", new Object[]{EnableAllocationDecider.setting(enable, usedIndexSetting)});
            }
            case PRIMARIES: {
                if (shardRouting.primary()) {
                    return allocation.decision(Decision.YES, NAME, "primary allocations are allowed", new Object[0]);
                }
                return allocation.decision(Decision.NO, NAME, "replica allocations are forbidden due to %s", new Object[]{EnableAllocationDecider.setting(enable, usedIndexSetting)});
            }
        }
        throw new IllegalStateException("Unknown allocation option");
    }

    public Decision canRebalance(RoutingAllocation allocation) {
        if (allocation.ignoreDisable()) {
            return allocation.decision(Decision.YES, NAME, "allocation is explicitly ignoring any disabling of rebalancing", new Object[0]);
        }
        if (this.enableRebalance == AllocationDeciderSettings.Rebalance.NONE) {
            for (IndexMetadata indexMetadata : allocation.metadata()) {
                if (!AllocationDeciderSettings.INDEX_ROUTING_REBALANCE_ENABLE_SETTING.exists(indexMetadata.getSettings()) || AllocationDeciderSettings.INDEX_ROUTING_REBALANCE_ENABLE_SETTING.get(indexMetadata.getSettings()) == AllocationDeciderSettings.Rebalance.NONE) continue;
                return allocation.decision(Decision.YES, NAME, "rebalancing is permitted on one or more indices", new Object[0]);
            }
            return allocation.decision(Decision.NO, NAME, "no rebalancing is allowed due to %s", new Object[]{EnableAllocationDecider.setting(this.enableRebalance, false)});
        }
        return allocation.decision(Decision.YES, NAME, "rebalancing is not globally disabled", new Object[0]);
    }

    public Decision canRebalance(ShardRouting shardRouting, RoutingAllocation allocation) {
        boolean usedIndexSetting;
        AllocationDeciderSettings.Rebalance enable;
        if (allocation.ignoreDisable()) {
            return allocation.decision(Decision.YES, NAME, "allocation is explicitly ignoring any disabling of rebalancing", new Object[0]);
        }
        Settings indexSettings = allocation.metadata().getIndexSafe(shardRouting.index()).getSettings();
        if (AllocationDeciderSettings.INDEX_ROUTING_REBALANCE_ENABLE_SETTING.exists(indexSettings)) {
            enable = (AllocationDeciderSettings.Rebalance)AllocationDeciderSettings.INDEX_ROUTING_REBALANCE_ENABLE_SETTING.get(indexSettings);
            usedIndexSetting = true;
        } else {
            enable = this.enableRebalance;
            usedIndexSetting = false;
        }
        switch (enable) {
            case ALL: {
                return allocation.decision(Decision.YES, NAME, "all rebalancing is allowed", new Object[0]);
            }
            case NONE: {
                return allocation.decision(Decision.NO, NAME, "no rebalancing is allowed due to %s", new Object[]{EnableAllocationDecider.setting(enable, usedIndexSetting)});
            }
            case PRIMARIES: {
                if (shardRouting.primary()) {
                    return allocation.decision(Decision.YES, NAME, "primary rebalancing is allowed", new Object[0]);
                }
                return allocation.decision(Decision.NO, NAME, "replica rebalancing is forbidden due to %s", new Object[]{EnableAllocationDecider.setting(enable, usedIndexSetting)});
            }
            case REPLICAS: {
                if (!shardRouting.primary()) {
                    return allocation.decision(Decision.YES, NAME, "replica rebalancing is allowed", new Object[0]);
                }
                return allocation.decision(Decision.NO, NAME, "primary rebalancing is forbidden due to %s", new Object[]{EnableAllocationDecider.setting(enable, usedIndexSetting)});
            }
        }
        throw new IllegalStateException("Unknown rebalance option");
    }

    private static String setting(AllocationDeciderSettings.Allocation allocation, boolean usedIndexSetting) {
        StringBuilder buf = new StringBuilder();
        if (usedIndexSetting) {
            buf.append("index setting [");
            buf.append(AllocationDeciderSettings.INDEX_ROUTING_ALLOCATION_ENABLE_SETTING.getKey());
        } else {
            buf.append("cluster setting [");
            buf.append(AllocationDeciderSettings.CLUSTER_ROUTING_ALLOCATION_ENABLE_SETTING.getKey());
        }
        buf.append("=").append(allocation.toString().toLowerCase(Locale.ROOT)).append("]");
        return buf.toString();
    }

    private static String setting(AllocationDeciderSettings.Rebalance rebalance, boolean usedIndexSetting) {
        StringBuilder buf = new StringBuilder();
        if (usedIndexSetting) {
            buf.append("index setting [");
            buf.append(AllocationDeciderSettings.INDEX_ROUTING_REBALANCE_ENABLE_SETTING.getKey());
        } else {
            buf.append("cluster setting [");
            buf.append(AllocationDeciderSettings.CLUSTER_ROUTING_REBALANCE_ENABLE_SETTING.getKey());
        }
        buf.append("=").append(rebalance.toString().toLowerCase(Locale.ROOT)).append("]");
        return buf.toString();
    }
}

