/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.allocation.decider;

import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.node.DiscoveryNodeFilters;
import io.skylite.core.cluster.routing.RecoverySource;
import io.skylite.core.cluster.routing.RoutingNode;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.routing.allocation.RoutingAllocation;
import io.skylite.core.cluster.routing.allocation.decider.AllocationDecider;
import io.skylite.core.cluster.routing.allocation.decider.AllocationDeciderSettings;
import io.skylite.core.cluster.routing.allocation.decider.Decision;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.Settings;
import java.util.Map;

public class FilterAllocationDecider
extends AllocationDecider {
    public static final String NAME = "filter";
    private volatile DiscoveryNodeFilters clusterRequireFilters;
    private volatile DiscoveryNodeFilters clusterIncludeFilters;
    private volatile DiscoveryNodeFilters clusterExcludeFilters;

    public FilterAllocationDecider(Settings settings, ClusterSettings clusterSettings) {
        this.setClusterRequireFilters(AllocationDeciderSettings.CLUSTER_ROUTING_REQUIRE_GROUP_SETTING.getAsMap(settings));
        this.setClusterExcludeFilters(AllocationDeciderSettings.CLUSTER_ROUTING_EXCLUDE_GROUP_SETTING.getAsMap(settings));
        this.setClusterIncludeFilters(AllocationDeciderSettings.CLUSTER_ROUTING_INCLUDE_GROUP_SETTING.getAsMap(settings));
        clusterSettings.addAffixMapUpdateConsumer(AllocationDeciderSettings.CLUSTER_ROUTING_REQUIRE_GROUP_SETTING, this::setClusterRequireFilters, (a, b) -> {});
        clusterSettings.addAffixMapUpdateConsumer(AllocationDeciderSettings.CLUSTER_ROUTING_EXCLUDE_GROUP_SETTING, this::setClusterExcludeFilters, (a, b) -> {});
        clusterSettings.addAffixMapUpdateConsumer(AllocationDeciderSettings.CLUSTER_ROUTING_INCLUDE_GROUP_SETTING, this::setClusterIncludeFilters, (a, b) -> {});
    }

    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        IndexMetadata indexMd;
        DiscoveryNodeFilters initialRecoveryFilters;
        if (shardRouting.unassigned() && (initialRecoveryFilters = DiscoveryNodeFilters.trimTier((DiscoveryNodeFilters)(indexMd = allocation.metadata().getIndexSafe(shardRouting.index())).getInitialRecoveryFilters())) != null && shardRouting.recoverySource().getType() == RecoverySource.Type.LOCAL_SHARDS && !initialRecoveryFilters.match(node.node().getNodeInfo())) {
            String explanation = "initial allocation of the shrunken index is only allowed on nodes [%s] that hold a copy of every shard in the index";
            return allocation.decision(Decision.NO, NAME, explanation, new Object[]{initialRecoveryFilters});
        }
        return this.shouldFilter(shardRouting, node.node(), allocation);
    }

    public Decision canAllocate(IndexMetadata indexMetadata, RoutingNode node, RoutingAllocation allocation) {
        return this.shouldFilter(indexMetadata, node.node(), allocation);
    }

    public Decision canRemain(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.shouldFilter(shardRouting, node.node(), allocation);
    }

    public Decision shouldAutoExpandToNode(IndexMetadata indexMetadata, DiscoveryNode node, RoutingAllocation allocation) {
        Decision decision = this.shouldClusterFilter(node, allocation);
        if (decision != null) {
            return decision;
        }
        decision = this.shouldIndexFilter(indexMetadata, node, allocation);
        if (decision != null) {
            return decision;
        }
        return allocation.decision(Decision.YES, NAME, "node passes include/exclude/require filters", new Object[0]);
    }

    public Decision canAllocateAnyShardToNode(RoutingNode node, RoutingAllocation allocation) {
        Decision decision = this.shouldClusterFilter(node.node(), allocation);
        return decision != null && decision == Decision.NO ? decision : Decision.ALWAYS;
    }

    private Decision shouldFilter(ShardRouting shardRouting, DiscoveryNode node, RoutingAllocation allocation) {
        Decision decision = this.shouldClusterFilter(node, allocation);
        if (decision != null) {
            return decision;
        }
        decision = this.shouldIndexFilter(allocation.metadata().getIndexSafe(shardRouting.index()), node, allocation);
        if (decision != null) {
            return decision;
        }
        return allocation.decision(Decision.YES, NAME, "node passes include/exclude/require filters", new Object[0]);
    }

    private Decision shouldFilter(IndexMetadata indexMd, DiscoveryNode node, RoutingAllocation allocation) {
        Decision decision = this.shouldClusterFilter(node, allocation);
        if (decision != null) {
            return decision;
        }
        decision = this.shouldIndexFilter(indexMd, node, allocation);
        if (decision != null) {
            return decision;
        }
        return allocation.decision(Decision.YES, NAME, "node passes include/exclude/require filters", new Object[0]);
    }

    private Decision shouldIndexFilter(IndexMetadata indexMd, DiscoveryNode node, RoutingAllocation allocation) {
        DiscoveryNodeFilters indexRequireFilters = DiscoveryNodeFilters.trimTier((DiscoveryNodeFilters)indexMd.requireFilters());
        DiscoveryNodeFilters indexIncludeFilters = DiscoveryNodeFilters.trimTier((DiscoveryNodeFilters)indexMd.includeFilters());
        DiscoveryNodeFilters indexExcludeFilters = DiscoveryNodeFilters.trimTier((DiscoveryNodeFilters)indexMd.excludeFilters());
        if (indexRequireFilters != null && !indexRequireFilters.match(node.getNodeInfo())) {
            return allocation.decision(Decision.NO, NAME, "node does not match index setting [%s] filters [%s]", new Object[]{"index.routing.allocation.require", indexRequireFilters});
        }
        if (indexIncludeFilters != null && !indexIncludeFilters.match(node.getNodeInfo())) {
            return allocation.decision(Decision.NO, NAME, "node does not match index setting [%s] filters [%s]", new Object[]{"index.routing.allocation.include", indexIncludeFilters});
        }
        if (indexExcludeFilters != null && indexExcludeFilters.match(node.getNodeInfo())) {
            return allocation.decision(Decision.NO, NAME, "node matches index setting [%s] filters [%s]", new Object[]{IndexMetadata.INDEX_ROUTING_EXCLUDE_GROUP_SETTING.getKey(), indexExcludeFilters});
        }
        return null;
    }

    private Decision shouldClusterFilter(DiscoveryNode node, RoutingAllocation allocation) {
        if (this.clusterRequireFilters != null && !this.clusterRequireFilters.match(node.getNodeInfo())) {
            return allocation.decision(Decision.NO, NAME, "node does not match cluster setting [%s] filters [%s]", new Object[]{"cluster.routing.allocation.require", this.clusterRequireFilters});
        }
        if (this.clusterIncludeFilters != null && !this.clusterIncludeFilters.match(node.getNodeInfo())) {
            return allocation.decision(Decision.NO, NAME, "node does not cluster setting [%s] filters [%s]", new Object[]{"cluster.routing.allocation.include", this.clusterIncludeFilters});
        }
        if (this.clusterExcludeFilters != null && this.clusterExcludeFilters.match(node.getNodeInfo())) {
            return allocation.decision(Decision.NO, NAME, "node matches cluster setting [%s] filters [%s]", new Object[]{"cluster.routing.allocation.exclude", this.clusterExcludeFilters});
        }
        return null;
    }

    private void setClusterRequireFilters(Map<String, String> filters) {
        this.clusterRequireFilters = DiscoveryNodeFilters.trimTier((DiscoveryNodeFilters)DiscoveryNodeFilters.buildOrUpdateFromKeyValue((DiscoveryNodeFilters)this.clusterRequireFilters, (DiscoveryNodeFilters.OpType)DiscoveryNodeFilters.OpType.AND, filters));
    }

    private void setClusterIncludeFilters(Map<String, String> filters) {
        this.clusterIncludeFilters = DiscoveryNodeFilters.trimTier((DiscoveryNodeFilters)DiscoveryNodeFilters.buildOrUpdateFromKeyValue((DiscoveryNodeFilters)this.clusterIncludeFilters, (DiscoveryNodeFilters.OpType)DiscoveryNodeFilters.OpType.OR, filters));
    }

    private void setClusterExcludeFilters(Map<String, String> filters) {
        this.clusterExcludeFilters = DiscoveryNodeFilters.trimTier((DiscoveryNodeFilters)DiscoveryNodeFilters.buildOrUpdateFromKeyValue((DiscoveryNodeFilters)this.clusterExcludeFilters, (DiscoveryNodeFilters.OpType)DiscoveryNodeFilters.OpType.OR, filters));
    }
}

