/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.allocation.decider;

import io.skylite.core.cluster.routing.RoutingNode;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.routing.allocation.RoutingAllocation;
import io.skylite.core.cluster.routing.allocation.decider.AllocationDecider;
import io.skylite.core.cluster.routing.allocation.decider.AllocationDeciderSettings;
import io.skylite.core.cluster.routing.allocation.decider.Decision;
import io.skylite.core.common.Strings;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.Settings;
import java.util.List;

public class SameShardAllocationDecider
extends AllocationDecider {
    public static final String NAME = "same_shard";
    private volatile boolean sameHost;

    public SameShardAllocationDecider(Settings settings, ClusterSettings clusterSettings) {
        this.sameHost = (Boolean)AllocationDeciderSettings.CLUSTER_ROUTING_ALLOCATION_SAME_HOST_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(AllocationDeciderSettings.CLUSTER_ROUTING_ALLOCATION_SAME_HOST_SETTING, this::setSameHost);
    }

    private void setSameHost(boolean sameHost) {
        this.sameHost = sameHost;
    }

    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        List assignedShards = allocation.routingNodes().assignedShards(shardRouting.shardId());
        Decision decision = this.decideSameNode(shardRouting, node, allocation, assignedShards);
        if (decision.type() == Decision.Type.NO || !this.sameHost) {
            return decision;
        }
        if (node.node() != null) {
            for (RoutingNode checkNode : allocation.routingNodes()) {
                if (checkNode.node() == null) continue;
                boolean checkNodeOnSameHostName = false;
                boolean checkNodeOnSameHostAddress = false;
                if (Strings.hasLength((String)checkNode.node().getHostAddress()) && Strings.hasLength((String)node.node().getHostAddress())) {
                    if (checkNode.node().getHostAddress().equals(node.node().getHostAddress())) {
                        checkNodeOnSameHostAddress = true;
                    }
                } else if (Strings.hasLength((String)checkNode.node().getHostName()) && Strings.hasLength((String)node.node().getHostName()) && checkNode.node().getHostName().equals(node.node().getHostName())) {
                    checkNodeOnSameHostName = true;
                }
                if (!checkNodeOnSameHostAddress && !checkNodeOnSameHostName) continue;
                for (ShardRouting assignedShard : assignedShards) {
                    if (!checkNode.nodeId().equals(assignedShard.currentNodeId())) continue;
                    String hostType = checkNodeOnSameHostAddress ? "address" : "name";
                    String host = checkNodeOnSameHostAddress ? node.node().getHostAddress() : node.node().getHostName();
                    return allocation.decision(Decision.NO, NAME, "a copy of this shard is already allocated to host %s [%s], on node [%s], and [%s] is [true] which forbids more than one node on this host from holding a copy of this shard", new Object[]{hostType, host, node.nodeId(), AllocationDeciderSettings.CLUSTER_ROUTING_ALLOCATION_SAME_HOST_SETTING.getKey()});
                }
            }
        }
        return allocation.decision(Decision.YES, NAME, "none of the nodes on this host hold a copy of this shard", new Object[0]);
    }

    public Decision canForceAllocatePrimary(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        assert (shardRouting.primary()) : "must not call force allocate on a non-primary shard";
        List assignedShards = allocation.routingNodes().assignedShards(shardRouting.shardId());
        return this.decideSameNode(shardRouting, node, allocation, assignedShards);
    }

    private Decision decideSameNode(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation, Iterable<ShardRouting> assignedShards) {
        for (ShardRouting assignedShard : assignedShards) {
            if (!node.nodeId().equals(assignedShard.currentNodeId())) continue;
            if (assignedShard.isSameAllocation(shardRouting)) {
                return allocation.decision(Decision.NO, NAME, "this shard is already allocated to this node [%s]", new Object[]{shardRouting.toString()});
            }
            return allocation.decision(Decision.NO, NAME, "a copy of this shard is already allocated to this node [%s]", new Object[]{assignedShard.toString()});
        }
        return allocation.decision(Decision.YES, NAME, "this node does not hold a copy of this shard", new Object[0]);
    }
}

