/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.allocation.decider;

import io.skylite.core.cluster.SnapshotsInProgress;
import io.skylite.core.cluster.routing.RoutingNode;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.routing.allocation.RoutingAllocation;
import io.skylite.core.cluster.routing.allocation.decider.AllocationDecider;
import io.skylite.core.cluster.routing.allocation.decider.Decision;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SnapshotInProgressAllocationDecider
extends AllocationDecider {
    private static final Logger logger = LogManager.getLogger(SnapshotInProgressAllocationDecider.class);
    public static final String NAME = "snapshot_in_progress";

    public Decision canRebalance(ShardRouting shardRouting, RoutingAllocation allocation) {
        return this.canMove(shardRouting, allocation);
    }

    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.canMove(shardRouting, allocation);
    }

    private Decision canMove(ShardRouting shardRouting, RoutingAllocation allocation) {
        if (shardRouting.primary()) {
            SnapshotsInProgress snapshotsInProgress = (SnapshotsInProgress)allocation.custom("snapshots");
            if (snapshotsInProgress == null || snapshotsInProgress.entries().isEmpty()) {
                return allocation.decision(Decision.YES, NAME, "no snapshots are currently running", new Object[0]);
            }
            for (SnapshotsInProgress.Entry snapshot : snapshotsInProgress.entries()) {
                SnapshotsInProgress.ShardSnapshotStatus shardSnapshotStatus = (SnapshotsInProgress.ShardSnapshotStatus)snapshot.shards().get(shardRouting.shardId());
                if (shardSnapshotStatus == null || shardSnapshotStatus.state().completed() || shardSnapshotStatus.nodeId() == null || !shardSnapshotStatus.nodeId().equals(shardRouting.currentNodeId())) continue;
                if (logger.isTraceEnabled()) {
                    logger.trace("Preventing snapshotted shard [{}] from being moved away from node [{}]", (Object)shardRouting.shardId(), (Object)shardSnapshotStatus.nodeId());
                }
                return allocation.decision(Decision.THROTTLE, NAME, "waiting for snapshotting of shard [%s] to complete on this node [%s]", new Object[]{shardRouting.shardId(), shardSnapshotStatus.nodeId()});
            }
        }
        return allocation.decision(Decision.YES, NAME, "the shard is not being snapshotted", new Object[0]);
    }
}

