/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.allocation.decider;

import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.node.NodeRole;
import io.skylite.core.cluster.routing.RoutingNode;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.routing.allocation.RoutingAllocation;
import io.skylite.core.cluster.routing.allocation.decider.AllocationDecider;
import io.skylite.core.cluster.routing.allocation.decider.Decision;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.routing.RoutingPool;

public class TargetPoolAllocationDecider
extends AllocationDecider {
    private static final Logger logger = LogManager.getLogger(TargetPoolAllocationDecider.class);
    public static final String NAME = "target_pool";

    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        RoutingPool shardPool = RoutingPool.getShardPool(shardRouting, allocation);
        RoutingPool targetNodePool = RoutingPool.getNodePool(node);
        if (RoutingPool.REMOTE_CAPABLE.equals((Object)shardPool) && RoutingPool.LOCAL_ONLY.equals((Object)targetNodePool)) {
            logger.debug("Shard: [{}] has target pool: [{}]. Cannot allocate on node: [{}] with target pool: [{}]", (Object)shardRouting, (Object)shardPool, (Object)node.node(), (Object)targetNodePool);
            return allocation.decision(Decision.NO, NAME, "Routing pools are incompatible. Shard pool: [%s], Node Pool: [%s]", new Object[]{shardPool, targetNodePool});
        }
        if (RoutingPool.LOCAL_ONLY.equals((Object)shardPool) && RoutingPool.REMOTE_CAPABLE.equals((Object)targetNodePool) && !node.node().getRoles().contains(NodeRole.DATA_ROLE)) {
            logger.debug("Shard: [{}] has target pool: [{}]. Cannot allocate on node: [{}] without the [{}] node role", (Object)shardRouting, (Object)shardPool, (Object)node.node(), (Object)NodeRole.DATA_ROLE);
            return allocation.decision(Decision.NO, NAME, "Routing pools are incompatible. Shard pool: [{}], Node Pool: [{}] without [{}] role", new Object[]{shardPool, targetNodePool, NodeRole.DATA_ROLE});
        }
        return allocation.decision(Decision.YES, NAME, "Routing pools are compatible. Shard pool: [%s], Node Pool: [%s]", new Object[]{shardPool, targetNodePool});
    }

    public Decision canAllocate(IndexMetadata indexMetadata, RoutingNode node, RoutingAllocation allocation) {
        return this.canAllocateInTargetPool(indexMetadata, node.node(), allocation);
    }

    public Decision canForceAllocatePrimary(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        logger.debug("Evaluating force allocation for primary shard.");
        return this.canAllocate(shardRouting, node, allocation);
    }

    public Decision shouldAutoExpandToNode(IndexMetadata indexMetadata, DiscoveryNode node, RoutingAllocation allocation) {
        logger.debug("Evaluating node: {} for autoExpandReplica eligibility of index: {}", (Object)node, (Object)indexMetadata.getIndex());
        return this.canAllocateInTargetPool(indexMetadata, node, allocation);
    }

    private Decision canAllocateInTargetPool(IndexMetadata indexMetadata, DiscoveryNode node, RoutingAllocation allocation) {
        RoutingPool indexPool = RoutingPool.getIndexPool(indexMetadata);
        RoutingPool targetNodePool = RoutingPool.getNodePool(node);
        if (RoutingPool.REMOTE_CAPABLE.equals((Object)indexPool) && RoutingPool.LOCAL_ONLY.equals((Object)targetNodePool)) {
            logger.debug("Index: [{}] has target pool: [{}]. Cannot allocate on node: [{}] with target pool: [{}]", (Object)indexMetadata.getIndex().getName(), (Object)indexPool, (Object)node, (Object)targetNodePool);
            return allocation.decision(Decision.NO, NAME, "Routing pools are incompatible. Index pool: [%s], Node Pool: [%s]", new Object[]{indexPool, targetNodePool});
        }
        if (RoutingPool.LOCAL_ONLY.equals((Object)indexPool) && RoutingPool.REMOTE_CAPABLE.equals((Object)targetNodePool) && !node.getRoles().contains(NodeRole.DATA_ROLE)) {
            logger.debug("Index: [{}] has target pool: [{}]. Cannot allocate on node: [{}] without the [{}] node role", (Object)indexMetadata.getIndex().getName(), (Object)indexPool, (Object)node, (Object)NodeRole.DATA_ROLE);
            return allocation.decision(Decision.NO, NAME, "Routing pools are incompatible. Index pool: [{}], Node Pool: [{}] without [{}] role", new Object[]{indexPool, targetNodePool, NodeRole.DATA_ROLE});
        }
        return allocation.decision(Decision.YES, NAME, "Routing pools are compatible. Index pool: [%s], Node Pool: [%s]", new Object[]{indexPool, targetNodePool});
    }
}

