/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.geo;

import io.skylite.SkyliteParseException;
import io.skylite.core.common.io.stream.NamedWriteableRegistry;
import io.skylite.core.common.unit.DistanceUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.locationtech.jts.geom.Coordinate;
import org.opensearch.common.geo.builders.CircleBuilder;
import org.opensearch.common.geo.builders.CoordinatesBuilder;
import org.opensearch.common.geo.builders.EllipseBuilder;
import org.opensearch.common.geo.builders.EnvelopeBuilder;
import org.opensearch.common.geo.builders.GeometryCollectionBuilder;
import org.opensearch.common.geo.builders.LineStringBuilder;
import org.opensearch.common.geo.builders.MultiLineStringBuilder;
import org.opensearch.common.geo.builders.MultiPointBuilder;
import org.opensearch.common.geo.builders.MultiPolygonBuilder;
import org.opensearch.common.geo.builders.PointBuilder;
import org.opensearch.common.geo.builders.PolygonBuilder;
import org.opensearch.common.geo.builders.ShapeBuilder;
import org.opensearch.common.geo.parsers.CoordinateNode;

public enum GeoShapeType {
    POINT("point"){

        public PointBuilder getBuilder(CoordinateNode coordinates, DistanceUnit.Distance radius, ShapeBuilder.Orientation orientation, boolean coerce) {
            return new PointBuilder().coordinate(this.validate((CoordinateNode)coordinates, (boolean)coerce).coordinate);
        }

        @Override
        CoordinateNode validate(CoordinateNode coordinates, boolean coerce) {
            if (coordinates.isEmpty()) {
                throw new SkyliteParseException("invalid number of points (0) provided when expecting a single coordinate ([lat, lng])", new Object[0]);
            }
            if (coordinates.children != null) {
                throw new SkyliteParseException("multipoint data provided when single point data expected.", new Object[0]);
            }
            return coordinates;
        }
    }
    ,
    MULTIPOINT("multipoint"){

        public MultiPointBuilder getBuilder(CoordinateNode coordinates, DistanceUnit.Distance radius, ShapeBuilder.Orientation orientation, boolean coerce) {
            this.validate(coordinates, coerce);
            CoordinatesBuilder coordinatesBuilder = new CoordinatesBuilder();
            for (CoordinateNode node : coordinates.children) {
                coordinatesBuilder.coordinate(node.coordinate);
            }
            return new MultiPointBuilder(coordinatesBuilder.build());
        }

        @Override
        CoordinateNode validate(CoordinateNode coordinates, boolean coerce) {
            if (coordinates.children == null || coordinates.children.isEmpty()) {
                if (coordinates.coordinate != null) {
                    throw new SkyliteParseException("single coordinate found when expecting an array of coordinates. change type to point or change data to an array of >0 coordinates", new Object[0]);
                }
                throw new SkyliteParseException("no data provided for multipoint object when expecting >0 points (e.g., [[lat, lng]] or [[lat, lng], ...])", new Object[0]);
            }
            for (CoordinateNode point : coordinates.children) {
                POINT.validate(point, coerce);
            }
            return coordinates;
        }
    }
    ,
    LINESTRING("linestring"){

        public LineStringBuilder getBuilder(CoordinateNode coordinates, DistanceUnit.Distance radius, ShapeBuilder.Orientation orientation, boolean coerce) {
            this.validate(coordinates, coerce);
            CoordinatesBuilder line = new CoordinatesBuilder();
            for (CoordinateNode node : coordinates.children) {
                line.coordinate(node.coordinate);
            }
            return new LineStringBuilder(line);
        }

        @Override
        CoordinateNode validate(CoordinateNode coordinates, boolean coerce) {
            if (coordinates.children.size() < 2) {
                throw new SkyliteParseException("invalid number of points in LineString (found [{}] - must be >= 2)", new Object[]{coordinates.children.size()});
            }
            return coordinates;
        }
    }
    ,
    MULTILINESTRING("multilinestring"){

        public MultiLineStringBuilder getBuilder(CoordinateNode coordinates, DistanceUnit.Distance radius, ShapeBuilder.Orientation orientation, boolean coerce) {
            this.validate(coordinates, coerce);
            MultiLineStringBuilder multiline = new MultiLineStringBuilder();
            for (CoordinateNode node : coordinates.children) {
                multiline.linestring((LineStringBuilder)LineStringBuilder.class.cast(LINESTRING.getBuilder(node, radius, orientation, coerce)));
            }
            return multiline;
        }

        @Override
        CoordinateNode validate(CoordinateNode coordinates, boolean coerce) {
            if (coordinates.children.size() < 1) {
                throw new SkyliteParseException("invalid number of lines in MultiLineString (found [{}] - must be >= 1)", new Object[]{coordinates.children.size()});
            }
            return coordinates;
        }
    }
    ,
    POLYGON("polygon"){

        public PolygonBuilder getBuilder(CoordinateNode coordinates, DistanceUnit.Distance radius, ShapeBuilder.Orientation orientation, boolean coerce) {
            this.validate(coordinates, coerce);
            LineStringBuilder shell = (LineStringBuilder)LineStringBuilder.class.cast(LINESTRING.getBuilder(coordinates.children.get(0), radius, orientation, coerce));
            PolygonBuilder polygon = new PolygonBuilder(shell, orientation);
            for (int i = 1; i < coordinates.children.size(); ++i) {
                CoordinateNode child = coordinates.children.get(i);
                LineStringBuilder hole = (LineStringBuilder)LineStringBuilder.class.cast(LINESTRING.getBuilder(child, radius, orientation, coerce));
                polygon.hole(hole);
            }
            return polygon;
        }

        void validateLinearRing(CoordinateNode coordinates, boolean coerce) {
            int numValidPts;
            if (coordinates.children == null || coordinates.children.isEmpty()) {
                Object error = "Invalid LinearRing found.";
                error = (String)error + (coordinates.coordinate == null ? " No coordinate array provided" : " Found a single coordinate when expecting a coordinate array");
                throw new SkyliteParseException((String)error, new Object[0]);
            }
            int n = numValidPts = coerce ? 3 : 4;
            if (coordinates.children.size() < numValidPts) {
                throw new SkyliteParseException("invalid number of points in LinearRing (found [{}] - must be >= [{}])", new Object[]{coordinates.children.size(), numValidPts});
            }
            if (!coordinates.children.get((int)0).coordinate.equals((Object)coordinates.children.get((int)(coordinates.children.size() - 1)).coordinate)) {
                if (coerce) {
                    coordinates.children.add(coordinates.children.get(0));
                } else {
                    throw new SkyliteParseException("invalid LinearRing found (coordinates are not closed)", new Object[0]);
                }
            }
        }

        @Override
        CoordinateNode validate(CoordinateNode coordinates, boolean coerce) {
            if (coordinates.children == null || coordinates.children.isEmpty()) {
                throw new SkyliteParseException("invalid LinearRing provided for type polygon. Linear ring must be an array of coordinates", new Object[0]);
            }
            for (CoordinateNode ring : coordinates.children) {
                this.validateLinearRing(ring, coerce);
            }
            return coordinates;
        }
    }
    ,
    MULTIPOLYGON("multipolygon"){

        public MultiPolygonBuilder getBuilder(CoordinateNode coordinates, DistanceUnit.Distance radius, ShapeBuilder.Orientation orientation, boolean coerce) {
            this.validate(coordinates, coerce);
            MultiPolygonBuilder polygons = new MultiPolygonBuilder(orientation);
            for (CoordinateNode node : coordinates.children) {
                polygons.polygon((PolygonBuilder)PolygonBuilder.class.cast(POLYGON.getBuilder(node, radius, orientation, coerce)));
            }
            return polygons;
        }

        @Override
        CoordinateNode validate(CoordinateNode coordinates, boolean coerce) {
            return coordinates;
        }
    }
    ,
    ENVELOPE("envelope"){

        public EnvelopeBuilder getBuilder(CoordinateNode coordinates, DistanceUnit.Distance radius, ShapeBuilder.Orientation orientation, boolean coerce) {
            this.validate(coordinates, coerce);
            Coordinate uL = coordinates.children.get((int)0).coordinate;
            Coordinate lR = coordinates.children.get((int)1).coordinate;
            return new EnvelopeBuilder(uL, lR);
        }

        @Override
        CoordinateNode validate(CoordinateNode coordinates, boolean coerce) {
            if (coordinates.children.size() != 2) {
                throw new SkyliteParseException("invalid number of points [{}] provided for geo_shape [{}] when expecting an array of 2 coordinates", new Object[]{coordinates.children.size(), GeoShapeType.ENVELOPE.shapename});
            }
            return coordinates;
        }

        @Override
        public String wktName() {
            return GeoShapeType.BBOX;
        }
    }
    ,
    CIRCLE("circle"){

        public CircleBuilder getBuilder(CoordinateNode coordinates, DistanceUnit.Distance radius, ShapeBuilder.Orientation orientation, boolean coerce) {
            return new CircleBuilder().center(coordinates.coordinate).radius(radius);
        }

        @Override
        CoordinateNode validate(CoordinateNode coordinates, boolean coerce) {
            return coordinates;
        }
    }
    ,
    ELLIPSE("ellipse"){

        @Override
        public ShapeBuilder<?, ?, ?> getBuilder(CoordinateNode coordinates, DistanceUnit.Distance radius, ShapeBuilder.Orientation orientation, boolean coerce) {
            return null;
        }

        public EllipseBuilder getBuilder(CoordinateNode coordinates, DistanceUnit.Distance semiMajorAxis, DistanceUnit.Distance semiMinorAxis, double orientationDegrees, ShapeBuilder.Orientation orientation, boolean coerce) {
            return new EllipseBuilder().center(coordinates.coordinate).semiMajorAxis(semiMajorAxis).semiMinorAxis(semiMinorAxis).orientationDegrees(orientationDegrees);
        }

        @Override
        CoordinateNode validate(CoordinateNode coordinates, boolean coerce) {
            return coordinates;
        }
    }
    ,
    GEOMETRYCOLLECTION("geometrycollection"){

        @Override
        public ShapeBuilder<?, ?, ?> getBuilder(CoordinateNode coordinates, DistanceUnit.Distance radius, ShapeBuilder.Orientation orientation, boolean coerce) {
            return null;
        }

        @Override
        CoordinateNode validate(CoordinateNode coordinates, boolean coerce) {
            return null;
        }
    };

    private final String shapename;
    private static Map<String, GeoShapeType> shapeTypeMap;
    private static final String BBOX = "BBOX";

    private GeoShapeType(String shapename) {
        this.shapename = shapename;
    }

    public String shapeName() {
        return this.shapename;
    }

    public static GeoShapeType forName(String geoshapename) {
        String typename = geoshapename.toLowerCase(Locale.ROOT);
        if (shapeTypeMap.containsKey(typename)) {
            return shapeTypeMap.get(typename);
        }
        throw new IllegalArgumentException("unknown geo_shape [" + geoshapename + "]");
    }

    public abstract ShapeBuilder<?, ?, ?> getBuilder(CoordinateNode var1, DistanceUnit.Distance var2, ShapeBuilder.Orientation var3, boolean var4);

    public ShapeBuilder<?, ?, ?> getBuilder(CoordinateNode coordinates, DistanceUnit.Distance semiMajorAxis, DistanceUnit.Distance semiMinorAxis, double orientationDegrees, ShapeBuilder.Orientation orientation, boolean coerce) {
        return null;
    }

    abstract CoordinateNode validate(CoordinateNode var1, boolean var2);

    public String wktName() {
        return this.shapename;
    }

    public static List<NamedWriteableRegistry.Entry> getShapeWriteables() {
        ArrayList<NamedWriteableRegistry.Entry> namedWriteables = new ArrayList<NamedWriteableRegistry.Entry>();
        namedWriteables.add(new NamedWriteableRegistry.Entry(ShapeBuilder.class, PointBuilder.TYPE.shapeName(), PointBuilder::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ShapeBuilder.class, CircleBuilder.TYPE.shapeName(), CircleBuilder::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ShapeBuilder.class, EnvelopeBuilder.TYPE.shapeName(), EnvelopeBuilder::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ShapeBuilder.class, MultiPointBuilder.TYPE.shapeName(), MultiPointBuilder::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ShapeBuilder.class, LineStringBuilder.TYPE.shapeName(), LineStringBuilder::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ShapeBuilder.class, MultiLineStringBuilder.TYPE.shapeName(), MultiLineStringBuilder::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ShapeBuilder.class, PolygonBuilder.TYPE.shapeName(), PolygonBuilder::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ShapeBuilder.class, MultiPolygonBuilder.TYPE.shapeName(), MultiPolygonBuilder::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ShapeBuilder.class, GeometryCollectionBuilder.TYPE.shapeName(), GeometryCollectionBuilder::new));
        return namedWriteables;
    }

    public String toString() {
        return this.shapename;
    }

    static {
        shapeTypeMap = new HashMap<String, GeoShapeType>();
        for (GeoShapeType type : GeoShapeType.values()) {
            shapeTypeMap.put(type.shapename, type);
        }
        shapeTypeMap.put(ENVELOPE.wktName().toLowerCase(Locale.ROOT), ENVELOPE);
    }
}

