/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.geo.builders;

import io.skylite.common.geometry.Ellipse;
import io.skylite.core.ParseField;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.unit.DistanceUnit;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.spatial4j.shape.jts.JtsGeometry;
import org.opensearch.common.geo.GeoShapeType;
import org.opensearch.common.geo.builders.ShapeBuilder;

public class EllipseBuilder
extends ShapeBuilder<JtsGeometry, Ellipse, EllipseBuilder> {
    public static final ParseField FIELD_SEMI_MAJOR_AXIS = new ParseField("semiMajorAxis", new String[0]);
    public static final ParseField FIELD_SEMI_MINOR_AXIS = new ParseField("semiMinorAxis", new String[0]);
    public static final ParseField FIELD_ORIENTATION_DEGREES = new ParseField("orientationDegrees", new String[0]);
    public static final GeoShapeType TYPE = GeoShapeType.ELLIPSE;
    private double semiMajorAxis;
    private DistanceUnit semiMajorAxisUnit = DistanceUnit.DEFAULT;
    private double semiMinorAxis;
    private DistanceUnit semiMinorAxisUnit = DistanceUnit.DEFAULT;
    private double orientationDegrees;
    private Coordinate center;

    public EllipseBuilder() {
        this.center = ZERO_ZERO;
        this.semiMajorAxis = -1.0;
        this.semiMinorAxis = -1.0;
        this.orientationDegrees = Double.NaN;
    }

    public EllipseBuilder(StreamInput in) throws IOException {
        this.center(EllipseBuilder.readFromStream(in));
        this.semiMajorAxis(in.readDouble(), DistanceUnit.readFromStream((StreamInput)in));
        this.semiMinorAxis(in.readDouble(), DistanceUnit.readFromStream((StreamInput)in));
        this.orientationDegrees(in.readDouble());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        EllipseBuilder.writeCoordinateTo(this.center, out);
        out.writeDouble(this.semiMajorAxis);
        this.semiMajorAxisUnit.writeTo(out);
        out.writeDouble(this.semiMinorAxis);
        this.semiMajorAxisUnit.writeTo(out);
        out.writeDouble(this.orientationDegrees);
    }

    public EllipseBuilder center(Coordinate center) {
        this.center = center;
        return this;
    }

    public EllipseBuilder center(double lon, double lat) {
        return this.center(new Coordinate(lon, lat));
    }

    public Coordinate center() {
        return this.center;
    }

    public EllipseBuilder semiMajorAxis(String semiMajorAxis) {
        return this.semiMajorAxis(DistanceUnit.Distance.parseDistance((String)semiMajorAxis));
    }

    public EllipseBuilder semiMajorAxis(DistanceUnit.Distance semiMajorAxis) {
        return this.semiMajorAxis(semiMajorAxis.value, semiMajorAxis.unit);
    }

    public EllipseBuilder semiMajorAxis(double semiMajorAxis, String unit) {
        return this.semiMajorAxis(semiMajorAxis, DistanceUnit.fromString((String)unit));
    }

    public EllipseBuilder semiMajorAxis(double semiMajorAxis, DistanceUnit unit) {
        this.semiMajorAxisUnit = unit;
        this.semiMajorAxis = semiMajorAxis;
        return this;
    }

    public EllipseBuilder semiMinorAxis(String semiMinorAxis) {
        return this.semiMinorAxis(DistanceUnit.Distance.parseDistance((String)semiMinorAxis));
    }

    public EllipseBuilder semiMinorAxis(DistanceUnit.Distance semiMinorAxis) {
        return this.semiMinorAxis(semiMinorAxis.value, semiMinorAxis.unit);
    }

    public EllipseBuilder semiMinorAxis(double semiMinorAxis, String unit) {
        return this.semiMinorAxis(semiMinorAxis, DistanceUnit.fromString((String)unit));
    }

    public EllipseBuilder semiMinorAxis(double semiMinorAxis, DistanceUnit unit) {
        this.semiMinorAxisUnit = unit;
        this.semiMinorAxis = this.semiMajorAxis;
        return this;
    }

    public EllipseBuilder orientationDegrees(String orientationDegrees) {
        return this.orientationDegrees(Double.parseDouble(orientationDegrees));
    }

    public EllipseBuilder orientationDegrees(double orientationDegrees) {
        this.orientationDegrees = orientationDegrees;
        return this;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return null;
    }

    @Override
    public JtsGeometry buildS4J() {
        return null;
    }

    @Override
    public Ellipse buildGeometry() {
        return null;
    }

    @Override
    public GeoShapeType type() {
        return null;
    }

    @Override
    public int numDimensions() {
        return 0;
    }
}

